/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.iiif.service;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.iiif.model.generator.CanvasGenerator;
import org.dspace.app.iiif.model.generator.ImageContentGenerator;
import org.dspace.app.iiif.service.AbstractResourceService;
import org.dspace.app.iiif.service.ImageContentService;
import org.dspace.app.iiif.service.utils.BitstreamIIIFVirtualMetadata;
import org.dspace.app.iiif.service.utils.IIIFUtils;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.RequestScope;

@RequestScope
@Component
public class CanvasService
extends AbstractResourceService {
    private static final Logger log = LogManager.getLogger(CanvasService.class);
    @Autowired
    ImageContentService imageContentService;
    @Autowired
    IIIFUtils utils;
    @Autowired
    ApplicationContext applicationContext;
    protected String[] BITSTREAM_METADATA_FIELDS;
    int dynamicDefaultWidth = 0;
    int dynamicDefaultHeight = 0;

    public CanvasService(ConfigurationService configurationService) {
        this.setConfiguration(configurationService);
        this.BITSTREAM_METADATA_FIELDS = configurationService.getArrayProperty("iiif.metadata.bitstream");
        this.setDefaultCanvasDimensions();
    }

    protected void guessCanvasDimensions(Context context, List<Bundle> bundles) {
        boolean dimensionUpdated = false;
        block0: for (Bundle bundle : bundles) {
            if (dimensionUpdated) continue;
            for (Bitstream bitstream : bundle.getBitstreams()) {
                if (!this.utils.isIIIFBitstream(context, bitstream)) continue;
                if (this.utils.hasWidthMetadata(bitstream)) continue block0;
                int[] imageDims = this.utils.getImageDimensions(bitstream);
                if (imageDims != null && imageDims.length == 2) {
                    defaultCanvasWidthFallback = imageDims[0];
                    defaultCanvasHeightFallback = imageDims[1];
                }
                this.setDefaultCanvasDimensions();
                dimensionUpdated = true;
                continue block0;
            }
        }
    }

    private void setCanvasDimensions(Bitstream bitstream) {
        if (this.DEFAULT_CANVAS_HEIGHT == -1 && this.DEFAULT_CANVAS_WIDTH == -1 && bitstream.getMetadata().stream().noneMatch(m -> m.getMetadataField().toString('.').contentEquals("iiif.image.width"))) {
            int[] imageDims = this.utils.getImageDimensions(bitstream);
            if (imageDims != null && imageDims.length == 2) {
                this.dynamicDefaultWidth = imageDims[0];
                this.dynamicDefaultHeight = imageDims[1];
            }
            if (imageDims == null) {
                this.dynamicDefaultWidth = defaultCanvasWidthFallback;
                this.dynamicDefaultHeight = defaultCanvasHeightFallback;
                log.error("Unable to retrieve dimensions from the image server for: " + bitstream.getID() + " Using default dimensions.");
            }
        }
    }

    private int getDefaultWidth() {
        if (this.DEFAULT_CANVAS_WIDTH == -1) {
            return this.dynamicDefaultWidth;
        }
        return this.DEFAULT_CANVAS_WIDTH;
    }

    private int getDefaultHeight() {
        if (this.DEFAULT_CANVAS_HEIGHT == -1) {
            return this.dynamicDefaultHeight;
        }
        return this.DEFAULT_CANVAS_HEIGHT;
    }

    protected CanvasGenerator getCanvas(Context context, String manifestId, Bitstream bitstream, Bundle bundle, Item item, int count, String mimeType) {
        int pagePosition = count + 1;
        String canvasNaming = this.utils.getCanvasNaming(item, I18nUtil.getMessage((String)"iiif.canvas.default-naming"));
        String label = this.utils.getIIIFLabel((DSpaceObject)bitstream, canvasNaming + " " + pagePosition);
        this.setCanvasDimensions(bitstream);
        int canvasWidth = this.utils.getCanvasWidth(bitstream, bundle, item, this.getDefaultWidth());
        int canvasHeight = this.utils.getCanvasHeight(bitstream, bundle, item, this.getDefaultHeight());
        UUID bitstreamId = bitstream.getID();
        ImageContentGenerator image = this.imageContentService.getImageContent(bitstreamId, mimeType, this.imageUtil.getImageProfile(), "/full/full/0/default.jpg");
        ImageContentGenerator thumb = this.imageContentService.getImageContent(bitstreamId, mimeType, this.thumbUtil.getThumbnailProfile(), "/full/90,/0/default.jpg");
        return this.addMetadata(context, bitstream, new CanvasGenerator(this.IIIF_ENDPOINT + manifestId + "/canvas/c" + count).addImage(image.generateResource()).addThumbnail(thumb.generateResource()).setHeight(canvasHeight).setWidth(canvasWidth).setLabel(label));
    }

    protected CanvasGenerator getRangeCanvasReference(String startCanvas) {
        return new CanvasGenerator(startCanvas);
    }

    private CanvasGenerator addMetadata(Context context, Bitstream bitstream, CanvasGenerator canvasGenerator) {
        BitstreamService bService = ContentServiceFactory.getInstance().getBitstreamService();
        for (String field : this.BITSTREAM_METADATA_FIELDS) {
            if (StringUtils.startsWith((CharSequence)field, (CharSequence)"@") && StringUtils.endsWith((CharSequence)field, (CharSequence)"@")) {
                String virtualFieldName = field.substring(1, field.length() - 1);
                String beanName = "iiif.bitstream." + virtualFieldName;
                BitstreamIIIFVirtualMetadata virtual = (BitstreamIIIFVirtualMetadata)this.applicationContext.getBean(beanName, BitstreamIIIFVirtualMetadata.class);
                List<String> values = virtual.getValues(context, bitstream);
                if (values.size() <= 0) continue;
                if (values.size() > 1) {
                    canvasGenerator.addMetadata("bitstream.iiif-virtual." + virtualFieldName, values.get(0), values.subList(1, values.size()).toArray(new String[values.size() - 1]));
                    continue;
                }
                canvasGenerator.addMetadata("bitstream.iiif-virtual." + virtualFieldName, values.get(0), new String[0]);
                continue;
            }
            String[] eq = field.split("\\.");
            String schema = eq[0];
            String element = eq[1];
            String qualifier = null;
            if (eq.length > 2) {
                qualifier = eq[2];
            }
            List metadata = bService.getMetadata((DSpaceObject)bitstream, schema, element, qualifier, "*");
            ArrayList<String> values = new ArrayList<String>();
            for (MetadataValue meta : metadata) {
                if (meta.getValue() == null) continue;
                values.add(meta.getValue());
            }
            if (values.size() <= 0) continue;
            if (values.size() > 1) {
                canvasGenerator.addMetadata("bitstream." + field, (String)values.get(0), values.subList(1, values.size()).toArray(new String[values.size() - 1]));
                continue;
            }
            canvasGenerator.addMetadata("bitstream." + field, (String)values.get(0), new String[0]);
        }
        return canvasGenerator;
    }
}

