/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.iiif.model.generator;

import de.digitalcollections.iiif.model.enums.ViewingHint;
import de.digitalcollections.iiif.model.sharedcanvas.Canvas;
import de.digitalcollections.iiif.model.sharedcanvas.Range;
import de.digitalcollections.iiif.model.sharedcanvas.Resource;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.dspace.app.iiif.model.generator.BehaviorGenerator;
import org.dspace.app.iiif.model.generator.CanvasGenerator;
import org.dspace.app.iiif.model.generator.IIIFResource;
import org.dspace.app.iiif.service.RangeService;

public class RangeGenerator
implements IIIFResource {
    private String identifier;
    private String label;
    private final List<ViewingHint> viewingHint = new ArrayList<ViewingHint>();
    private final List<Canvas> canvasList = new ArrayList<Canvas>();
    private final List<Range> rangesList = new ArrayList<Range>();
    private final RangeService rangeService;

    public RangeGenerator(RangeService rangeService) {
        this.rangeService = rangeService;
    }

    public RangeGenerator setIdentifier(@NotNull String identifier) {
        if (identifier.isEmpty()) {
            throw new RuntimeException("Invalid range identifier. Cannot be an empty string.");
        }
        this.identifier = identifier;
        return this;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public RangeGenerator setLabel(String label) {
        this.label = label;
        return this;
    }

    public RangeGenerator addViewingHint(String hint) {
        this.viewingHint.add(new BehaviorGenerator().setType(hint).generateValue());
        return this;
    }

    public RangeGenerator addCanvas(CanvasGenerator canvas) {
        this.canvasList.add((Canvas)canvas.generateResource());
        return this;
    }

    public void addSubRange(RangeGenerator range) {
        range.setIdentifier(this.identifier + "-" + this.rangesList.size());
        RangeGenerator rangeReference = this.rangeService.getRangeReference(range);
        this.rangesList.add((Range)rangeReference.generateResource());
    }

    public Resource<Range> generateResource() {
        if (this.identifier == null) {
            throw new RuntimeException("The Range resource requires an identifier.");
        }
        Range range = this.label != null ? new Range(this.identifier, this.label) : new Range(this.identifier);
        if (this.viewingHint.size() > 0) {
            range.setViewingHints(this.viewingHint);
        }
        for (Canvas canvas : this.canvasList) {
            range.addCanvas(canvas, new Canvas[0]);
        }
        for (Range rangeResource : this.rangesList) {
            range.addRange(rangeResource, new Range[0]);
        }
        return range;
    }
}

