/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.iiif.model.generator;

import de.digitalcollections.iiif.model.openannotation.Annotation;
import de.digitalcollections.iiif.model.sharedcanvas.AnnotationList;
import de.digitalcollections.iiif.model.sharedcanvas.Resource;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.dspace.app.iiif.model.generator.AnnotationGenerator;
import org.dspace.app.iiif.model.generator.IIIFResource;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.RequestScope;

@RequestScope
@Component
public class AnnotationListGenerator
implements IIIFResource {
    private String identifier;
    private List<Annotation> annotations = new ArrayList<Annotation>();

    public void setIdentifier(@NotNull String identifier) {
        this.identifier = identifier;
    }

    public void addResource(AnnotationGenerator annotation) {
        this.annotations.add((Annotation)annotation.generateResource());
    }

    public Resource<Annotation> generateResource() {
        if (this.identifier == null) {
            throw new RuntimeException("Missing the required identifier for the annotation list.");
        }
        AnnotationList annotationList = new AnnotationList(this.identifier);
        annotationList.setResources(this.annotations);
        return annotationList;
    }
}

