/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.iiif.model.generator;

import de.digitalcollections.iiif.model.Motivation;
import de.digitalcollections.iiif.model.openannotation.Annotation;
import de.digitalcollections.iiif.model.sharedcanvas.Resource;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.dspace.app.iiif.model.generator.CanvasGenerator;
import org.dspace.app.iiif.model.generator.ContentAsTextGenerator;
import org.dspace.app.iiif.model.generator.ExternalLinksGenerator;
import org.dspace.app.iiif.model.generator.IIIFResource;
import org.dspace.app.iiif.model.generator.ManifestGenerator;

public class AnnotationGenerator
implements IIIFResource {
    public static final String TYPE = "sc:AnnotationList";
    public static final Motivation PAINTING = new Motivation("sc:painting");
    public static final Motivation COMMENTING = new Motivation("oa:commenting");
    public static final Motivation LINKING = new Motivation("oa:linking");
    private Motivation motivation;
    private String identifier;
    private CanvasGenerator canvasGenerator;
    private ContentAsTextGenerator contentAsTextGenerator;
    private ExternalLinksGenerator externalLinksGenerator;
    List<Resource> manifests = new ArrayList<Resource>();

    public AnnotationGenerator(@NotNull String identifier) {
        if (identifier.isEmpty()) {
            throw new RuntimeException("Invalid annotation identifier. Cannot be an empty string.");
        }
        this.identifier = identifier;
    }

    public AnnotationGenerator(@NotNull String identifier, @NotNull Motivation motivation) {
        if (identifier.isEmpty()) {
            throw new RuntimeException("Invalid annotation identifier. Cannot be an empty string.");
        }
        this.identifier = identifier;
        this.motivation = motivation;
    }

    public AnnotationGenerator setMotivation(@NotNull Motivation motivation) {
        this.motivation = motivation;
        return this;
    }

    public AnnotationGenerator setOnCanvas(CanvasGenerator canvas) {
        this.canvasGenerator = canvas;
        return this;
    }

    public AnnotationGenerator setResource(ContentAsTextGenerator contentAsText) {
        this.contentAsTextGenerator = contentAsText;
        return this;
    }

    public AnnotationGenerator setResource(ExternalLinksGenerator otherContent) {
        this.externalLinksGenerator = otherContent;
        return this;
    }

    public AnnotationGenerator setWithin(List<ManifestGenerator> within) {
        for (ManifestGenerator manifest : within) {
            this.manifests.add(manifest.generateResource());
        }
        return this;
    }

    public Resource<Annotation> generateResource() {
        if (this.identifier == null) {
            throw new RuntimeException("Annotations require an identifier.");
        }
        Annotation annotation = this.motivation != null ? new Annotation(this.identifier, this.motivation) : new Annotation(this.identifier);
        annotation.setWithin(this.manifests);
        if (this.canvasGenerator != null) {
            annotation.setOn(this.canvasGenerator.generateResource());
        }
        if (this.externalLinksGenerator != null) {
            annotation.setResource(this.externalLinksGenerator.generateResource());
        }
        if (this.contentAsTextGenerator != null) {
            annotation.setResource(this.contentAsTextGenerator.generateResource());
        }
        return annotation;
    }
}

