/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.export;

import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.services.ConfigurationService;
import org.dspace.services.model.Event;
import org.dspace.statistics.export.processor.BitstreamEventProcessor;
import org.dspace.statistics.export.processor.ItemEventProcessor;
import org.dspace.usage.AbstractUsageEventListener;
import org.dspace.usage.UsageEvent;
import org.springframework.beans.factory.annotation.Autowired;

public class IrusExportUsageEventListener
extends AbstractUsageEventListener {
    private static final Logger log = LogManager.getLogger();
    @Autowired
    ConfigurationService configurationService;

    public void receiveEvent(Event event) {
        if (this.configurationService.getBooleanProperty("irus.statistics.tracker.enabled", false) && event instanceof UsageEvent) {
            UsageEvent ue = (UsageEvent)event;
            Context context = ue.getContext();
            try {
                if (ue.getObject() instanceof Item) {
                    ItemEventProcessor itemEventProcessor = new ItemEventProcessor(context, ue.getRequest(), (Item)ue.getObject());
                    itemEventProcessor.processEvent();
                } else if (ue.getObject() instanceof Bitstream) {
                    BitstreamEventProcessor bitstreamEventProcessor = new BitstreamEventProcessor(context, ue.getRequest(), (Bitstream)ue.getObject());
                    bitstreamEventProcessor.processEvent();
                }
            }
            catch (Exception e) {
                int type;
                UUID id = ue.getObject().getID();
                try {
                    type = ue.getObject().getType();
                }
                catch (Exception e1) {
                    type = -1;
                }
                log.error(LogHelper.getHeader(ue.getContext(), "Error while processing export of use event", "Id: " + id + " type: " + type), (Throwable)e);
            }
        }
    }
}

