/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.scripts;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.dspace.cli.DSpaceSkipUnknownArgumentsParser;
import org.dspace.eperson.EPerson;
import org.dspace.scripts.configuration.ScriptConfiguration;
import org.dspace.scripts.handler.DSpaceRunnableHandler;

public abstract class DSpaceRunnable<T extends ScriptConfiguration>
implements Runnable {
    protected CommandLine commandLine;
    protected CommandLine helpCommandLine;
    private UUID epersonIdentifier;
    protected DSpaceRunnableHandler handler;

    public abstract T getScriptConfiguration();

    private void setHandler(DSpaceRunnableHandler dSpaceRunnableHandler) {
        this.handler = dSpaceRunnableHandler;
    }

    public StepResult initialize(String[] args, DSpaceRunnableHandler dSpaceRunnableHandler, EPerson currentUser) throws ParseException {
        if (currentUser != null) {
            this.setEpersonIdentifier(currentUser.getID());
        }
        this.setHandler(dSpaceRunnableHandler);
        StepResult result = this.parseForHelp(args);
        switch (result) {
            case Exit: {
                this.handleHelpCommandLine();
                break;
            }
            case Continue: {
                result = this.parse(args);
                break;
            }
        }
        return result;
    }

    private void handleHelpCommandLine() {
        this.printHelp();
    }

    protected StepResult parse(String[] args) throws ParseException {
        this.commandLine = new DefaultParser().parse(((ScriptConfiguration)this.getScriptConfiguration()).getOptions(), args);
        this.setup();
        return StepResult.Continue;
    }

    private StepResult parseForHelp(String[] args) throws ParseException {
        this.helpCommandLine = new DSpaceSkipUnknownArgumentsParser().parse(((ScriptConfiguration)this.getScriptConfiguration()).getHelpOptions(), args);
        if (this.helpCommandLine.getOptions() != null && this.helpCommandLine.getOptions().length > 0) {
            return StepResult.Exit;
        }
        return StepResult.Continue;
    }

    public abstract void setup() throws ParseException;

    @Override
    public void run() {
        try {
            this.handler.start();
            this.internalRun();
            this.handler.handleCompletion();
        }
        catch (Exception e) {
            this.handler.handleException(e);
        }
    }

    public abstract void internalRun() throws Exception;

    public void printHelp() {
        this.handler.printHelp(((ScriptConfiguration)this.getScriptConfiguration()).getOptions(), ((ScriptConfiguration)this.getScriptConfiguration()).getName());
    }

    public List<String> getFileNamesFromInputStreamOptions() {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (Option option : ((ScriptConfiguration)this.getScriptConfiguration()).getOptions().getOptions()) {
            if (option.getType() != InputStream.class || !StringUtils.isNotBlank((CharSequence)this.commandLine.getOptionValue(option.getOpt()))) continue;
            fileNames.add(this.commandLine.getOptionValue(option.getOpt()));
        }
        return fileNames;
    }

    public UUID getEpersonIdentifier() {
        return this.epersonIdentifier;
    }

    public void setEpersonIdentifier(UUID epersonIdentifier) {
        this.epersonIdentifier = epersonIdentifier;
    }

    public static enum StepResult {
        Continue,
        Exit;

    }
}

