/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.qaevent.action;

import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.RelationshipType;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.qaevent.QualityAssuranceAction;
import org.dspace.qaevent.service.dto.OpenaireMessageDTO;
import org.dspace.qaevent.service.dto.QAMessageDTO;
import org.springframework.beans.factory.annotation.Autowired;

public class QAEntityOpenaireMetadataAction
implements QualityAssuranceAction {
    private String relation;
    private String entityType;
    private Map<String, String> entityMetadata;
    @Autowired
    private InstallItemService installItemService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private EntityTypeService entityTypeService;
    @Autowired
    private RelationshipService relationshipService;
    @Autowired
    private RelationshipTypeService relationshipTypeService;
    @Autowired
    private WorkspaceItemService workspaceItemService;
    @Autowired
    private CollectionService collectionService;

    public void setItemService(ItemService itemService) {
        this.itemService = itemService;
    }

    public String getRelation() {
        return this.relation;
    }

    public void setRelation(String relation) {
        this.relation = relation;
    }

    public String[] splitMetadata(String metadata) {
        String[] result = new String[3];
        String[] split = metadata.split("\\.");
        result[0] = split[0];
        result[1] = split[1];
        if (split.length == 3) {
            result[2] = split[2];
        }
        return result;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public Map<String, String> getEntityMetadata() {
        return this.entityMetadata;
    }

    public void setEntityMetadata(Map<String, String> entityMetadata) {
        this.entityMetadata = entityMetadata;
    }

    @Override
    public void applyCorrection(Context context, Item item, Item relatedItem, QAMessageDTO message) {
        try {
            if (relatedItem != null) {
                this.link(context, item, relatedItem);
            } else {
                Collection collection = this.collectionService.retrieveCollectionWithSubmitByEntityType(context, item, this.entityType);
                if (collection == null) {
                    throw new IllegalStateException("No collection found by entity type: " + collection);
                }
                WorkspaceItem workspaceItem = this.workspaceItemService.create(context, collection, true);
                relatedItem = workspaceItem.getItem();
                for (String key : this.entityMetadata.keySet()) {
                    String value = this.getValue(message, key);
                    if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                    String[] targetMetadata = this.splitMetadata(this.entityMetadata.get(key));
                    this.itemService.addMetadata(context, relatedItem, targetMetadata[0], targetMetadata[1], targetMetadata[2], null, value);
                }
                this.installItemService.installItem(context, workspaceItem);
                this.itemService.update(context, relatedItem);
                this.link(context, item, relatedItem);
            }
        }
        catch (SQLException | AuthorizeException e) {
            throw new RuntimeException(e);
        }
    }

    private void link(Context context, Item item, Item relatedItem) throws SQLException, AuthorizeException {
        EntityType project = this.entityTypeService.findByEntityType(context, this.entityType);
        RelationshipType relType = this.relationshipTypeService.findByEntityType(context, project).stream().filter(r -> StringUtils.equals((CharSequence)r.getRightwardType(), (CharSequence)this.relation)).findFirst().orElseThrow(() -> new IllegalStateException("No relationshipType named " + this.relation + " was found for the entity type " + this.entityType + ". A proper configuration is required to use the QAEntitiyMetadataAction. If you don't manage funding in your repository please skip this topic in the qaevents.cfg"));
        this.relationshipService.create(context, item, relatedItem, relType, -1, -1);
    }

    private String getValue(QAMessageDTO message, String key) {
        if (!(message instanceof OpenaireMessageDTO)) {
            return null;
        }
        OpenaireMessageDTO openaireMessage = (OpenaireMessageDTO)message;
        if (StringUtils.equals((CharSequence)key, (CharSequence)"acronym")) {
            return openaireMessage.getAcronym();
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"code")) {
            return openaireMessage.getCode();
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"funder")) {
            return openaireMessage.getFunder();
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"fundingProgram")) {
            return openaireMessage.getFundingProgram();
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"jurisdiction")) {
            return openaireMessage.getJurisdiction();
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"openaireId")) {
            return openaireMessage.getOpenaireId();
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"title")) {
            return openaireMessage.getTitle();
        }
        return null;
    }
}

