/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.matomo.factory;

import jakarta.servlet.http.Cookie;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.dspace.matomo.factory.MatomoRequestDetailsEnricher;
import org.dspace.matomo.model.MatomoRequestDetails;
import org.dspace.usage.UsageEvent;

public class MatomoRequestCookieIdentifierEnricher
implements MatomoRequestDetailsEnricher {
    static final String _PK_ID_NAME = "_pk_id";
    static final Pattern _pk_id = Pattern.compile("(^([a-f]|[0-9]){16})");

    @Override
    public MatomoRequestDetails enrich(UsageEvent usageEvent, MatomoRequestDetails matomoRequestDetails) {
        Cookie[] cookies = usageEvent.getRequest().getCookies();
        if (cookies == null || cookies.length == 0) {
            return matomoRequestDetails;
        }
        return MatomoRequestCookieIdentifierEnricher.getCookie(cookies).filter(StringUtils::isNotEmpty).map(id -> matomoRequestDetails.addParameter("_id", (String)id)).orElse(matomoRequestDetails);
    }

    public static boolean hasCookie(Cookie[] cookies) {
        return cookies != null && MatomoRequestCookieIdentifierEnricher.getCookie(cookies).isPresent();
    }

    public static Optional<String> getCookie(Cookie[] cookies) {
        return Stream.of(cookies).filter(cookie -> cookie.getName().startsWith(_PK_ID_NAME)).map(cookie -> _pk_id.matcher(cookie.getValue())).filter(Matcher::find).findFirst().map(Matcher::group);
    }
}

