/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.csv.service;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.exceptions.CsvException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dspace.importer.external.exception.FileSourceException;
import org.dspace.importer.external.metadatamapping.MetadataFieldConfig;
import org.dspace.importer.external.metadatamapping.contributor.MetadataContributor;
import org.dspace.importer.external.service.components.AbstractPlainMetadataSource;
import org.dspace.importer.external.service.components.dto.PlainMetadataKeyValueItem;
import org.dspace.importer.external.service.components.dto.PlainMetadataSourceDto;

public class CharacterSeparatedImportMetadataSourceServiceImpl
extends AbstractPlainMetadataSource {
    private char separator = (char)44;
    private char quoteCharacter = (char)34;
    private char escapeCharacter = (char)92;
    private Integer skipLines = 1;
    private String importSource = "CsvMetadataSource";

    public void setSkipLines(Integer skipLines) {
        this.skipLines = skipLines;
    }

    public Integer getSkipLines() {
        return this.skipLines;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public void setQuoteCharacter(char quoteCharacter) {
        this.quoteCharacter = quoteCharacter;
    }

    public void setEscapeCharacter(char escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
    }

    @Override
    public String getImportSource() {
        return this.importSource;
    }

    public void setImportSource(String importSource) {
        this.importSource = importSource;
    }

    @Override
    protected List<PlainMetadataSourceDto> readData(InputStream inputStream) throws FileSourceException {
        ArrayList<PlainMetadataSourceDto> plainMetadataList = new ArrayList<PlainMetadataSourceDto>();
        CSVParser parser = new CSVParserBuilder().withSeparator(this.separator).withQuoteChar(this.quoteCharacter).withEscapeChar(this.escapeCharacter).build();
        try (InputStreamReader inputReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
             CSVReader csvReader = new CSVReaderBuilder((Reader)inputReader).withCSVParser((ICSVParser)parser).build();){
            List lines = csvReader.readAll();
            int listSize = lines == null ? 0 : lines.size();
            for (int count = this.skipLines.intValue(); count < listSize; ++count) {
                String[] items = (String[])lines.get(count);
                ArrayList<PlainMetadataKeyValueItem> keyValueList = new ArrayList<PlainMetadataKeyValueItem>();
                if (items == null) continue;
                int size = items.length;
                for (int index = 0; index < size; ++index) {
                    PlainMetadataKeyValueItem keyValueItem = new PlainMetadataKeyValueItem();
                    keyValueItem.setKey(String.valueOf(index));
                    keyValueItem.setValue(items[index]);
                    keyValueList.add(keyValueItem);
                }
                PlainMetadataSourceDto dto = new PlainMetadataSourceDto();
                dto.setMetadata(keyValueList);
                plainMetadataList.add(dto);
            }
        }
        catch (CsvException | IOException e) {
            throw new FileSourceException("Error reading file", e);
        }
        return plainMetadataList;
    }

    @Override
    public void setMetadataFieldMap(Map<MetadataFieldConfig, MetadataContributor<PlainMetadataSourceDto>> metadataFieldMap) {
        super.setMetadataFieldMap(metadataFieldMap);
    }
}

