/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalTime;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.Arrays;
import org.apache.commons.codec.binary.StringUtils;

public enum FrequencyType {
    DAY("D"),
    WEEK("W"),
    MONTH("M");

    private String shortName;

    private FrequencyType(String shortName) {
        this.shortName = shortName;
    }

    public static String findLastFrequency(String frequency) {
        String startDate = "";
        String endDate = "";
        switch (frequency) {
            case "D": {
                Instant startOfYesterday = ZonedDateTime.now(ZoneOffset.UTC).minusDays(1L).with(LocalTime.MIN).toInstant();
                startDate = startOfYesterday.toString();
                Instant endOfYesterday = ZonedDateTime.now(ZoneOffset.UTC).minusDays(1L).with(LocalTime.MAX).toInstant();
                endDate = endOfYesterday.toString();
                break;
            }
            case "M": {
                Instant startOfLastMonth = YearMonth.now(ZoneOffset.UTC).minusMonths(1L).atDay(1).atStartOfDay().toInstant(ZoneOffset.UTC);
                startDate = startOfLastMonth.toString();
                Instant endOfLastMonth = YearMonth.now(ZoneOffset.UTC).minusMonths(1L).atEndOfMonth().atTime(LocalTime.MAX).toInstant(ZoneOffset.UTC);
                endDate = endOfLastMonth.toString();
                break;
            }
            case "W": {
                Instant startOfLastWeek = ZonedDateTime.now(ZoneOffset.UTC).minusWeeks(1L).with(TemporalAdjusters.previousOrSame(DayOfWeek.SUNDAY)).with(LocalTime.MIN).toInstant();
                startDate = startOfLastWeek.toString();
                Instant endOfLastWeek = ZonedDateTime.now(ZoneOffset.UTC).minusWeeks(1L).with(TemporalAdjusters.nextOrSame(DayOfWeek.SATURDAY)).with(LocalTime.MAX).toInstant();
                endDate = endOfLastWeek.toString();
                break;
            }
            default: {
                return null;
            }
        }
        return "[" + startDate + " TO " + endDate + "]";
    }

    public static boolean isSupportedFrequencyType(String value) {
        for (FrequencyType ft : Arrays.asList(FrequencyType.values())) {
            if (!StringUtils.equals((CharSequence)ft.getShortName(), (CharSequence)value)) continue;
            return true;
        }
        return false;
    }

    public String getShortName() {
        return this.shortName;
    }
}

