/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import org.dspace.qaevent.service.dto.CorrectionTypeMessageDTO;
import org.dspace.qaevent.service.dto.NotifyMessageDTO;
import org.dspace.qaevent.service.dto.OpenaireMessageDTO;
import org.dspace.qaevent.service.dto.QAMessageDTO;
import org.dspace.util.RawJsonDeserializer;

public class QAEvent {
    public static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final String ACCEPTED = "accepted";
    public static final String REJECTED = "rejected";
    public static final String DISCARDED = "discarded";
    public static final String OPENAIRE_SOURCE = "openaire";
    public static final String DSPACE_USERS_SOURCE = "DSpaceUsers";
    public static final String COAR_NOTIFY_SOURCE = "coar-notify";
    private String source;
    private String eventId;
    private String originalId;
    private String target;
    private String related;
    private String title;
    private String topic;
    private double trust;
    @JsonDeserialize(using=RawJsonDeserializer.class)
    private String message;
    private Instant lastUpdate;
    private String status = "PENDING";

    public QAEvent() {
    }

    public QAEvent(String source, String originalId, String target, String title, String topic, double trust, String message, Instant lastUpdate) {
        this.source = source;
        this.originalId = originalId;
        this.target = target;
        this.title = title;
        this.topic = topic;
        this.trust = trust;
        this.message = message;
        this.lastUpdate = lastUpdate;
        try {
            this.computedEventId();
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getOriginalId() {
        return this.originalId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public double getTrust() {
        return this.trust;
    }

    public void setTrust(double trust) {
        this.trust = trust;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getEventId() {
        if (this.eventId == null) {
            try {
                this.computedEventId();
            }
            catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public Instant getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Instant lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public void setRelated(String related) {
        this.related = related;
    }

    public String getRelated() {
        return this.related;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public String getSource() {
        return this.source != null ? this.source : OPENAIRE_SOURCE;
    }

    public void setSource(String source) {
        this.source = source;
    }

    private void computedEventId() throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest digester = MessageDigest.getInstance("MD5");
        String dataToString = "source=" + this.source + ",originalId=" + this.originalId + ", title=" + this.title + ", topic=" + this.topic + ", trust=" + this.trust + ", message=" + this.message;
        digester.update(dataToString.getBytes("UTF-8"));
        byte[] signature = digester.digest();
        char[] arr = new char[signature.length << 1];
        for (int i = 0; i < signature.length; ++i) {
            byte b = signature[i];
            int idx = i << 1;
            arr[idx] = HEX_DIGITS[b >> 4 & 0xF];
            arr[idx + 1] = HEX_DIGITS[b & 0xF];
        }
        this.eventId = new String(arr);
    }

    public Class<? extends QAMessageDTO> getMessageDtoClass() {
        switch (this.getSource()) {
            case "openaire": {
                return OpenaireMessageDTO.class;
            }
            case "coar-notify": {
                return NotifyMessageDTO.class;
            }
            case "DSpaceUsers": {
                return CorrectionTypeMessageDTO.class;
            }
        }
        throw new IllegalArgumentException("Unknown event's source: " + this.getSource());
    }
}

