/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.dspace.checker.ChecksumResultCode;
import org.dspace.checker.MostRecentChecksum;
import org.dspace.checker.service.MostRecentChecksumService;
import org.dspace.checker.service.SimpleReporterService;
import org.dspace.content.Bitstream;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.springframework.beans.factory.annotation.Autowired;

public class SimpleReporterServiceImpl
implements SimpleReporterService {
    @Autowired(required=true)
    protected MostRecentChecksumService mostRecentChecksumService = null;
    @Autowired(required=true)
    protected BitstreamService bitstreamService = null;

    private String msg(String key) {
        return I18nUtil.getMessage("org.dspace.checker.SimpleReporterImpl." + key);
    }

    protected SimpleReporterServiceImpl() {
    }

    @Override
    public int getDeletedBitstreamReport(Context context, Instant startDate, Instant endDate, OutputStreamWriter osw) throws IOException, SQLException {
        List<MostRecentChecksum> recentChecksums = this.mostRecentChecksumService.findBitstreamResultTypeReport(context, startDate, endDate, ChecksumResultCode.BITSTREAM_MARKED_DELETED);
        osw.write("\n");
        osw.write(this.msg("deleted-bitstream-intro"));
        osw.write(" ");
        osw.write(this.applyDateFormatShort(startDate));
        osw.write(" ");
        osw.write(this.msg("date-range-to"));
        osw.write(" ");
        osw.write(this.applyDateFormatShort(endDate));
        osw.write("\n\n\n");
        if (recentChecksums.isEmpty()) {
            osw.write("\n\n");
            osw.write(this.msg("no-bitstreams-to-delete"));
            osw.write("\n");
        } else {
            this.printHistoryRecords(recentChecksums, osw);
        }
        return recentChecksums.size();
    }

    @Override
    public int getChangedChecksumReport(Context context, Instant startDate, Instant endDate, OutputStreamWriter osw) throws IOException, SQLException {
        List<MostRecentChecksum> history = this.mostRecentChecksumService.findBitstreamResultTypeReport(context, startDate, endDate, ChecksumResultCode.CHECKSUM_NO_MATCH);
        osw.write("\n");
        osw.write(this.msg("checksum-did-not-match"));
        osw.write(" ");
        osw.write(this.applyDateFormatShort(startDate));
        osw.write(" ");
        osw.write(this.msg("date-range-to"));
        osw.write(" ");
        osw.write(this.applyDateFormatShort(endDate));
        osw.write("\n\n\n");
        if (history.isEmpty()) {
            osw.write("\n\n");
            osw.write(this.msg("no-changed-bitstreams"));
            osw.write("\n");
        } else {
            this.printHistoryRecords(history, osw);
        }
        return history.size();
    }

    @Override
    public int getBitstreamNotFoundReport(Context context, Instant startDate, Instant endDate, OutputStreamWriter osw) throws IOException, SQLException {
        List<MostRecentChecksum> history = this.mostRecentChecksumService.findBitstreamResultTypeReport(context, startDate, endDate, ChecksumResultCode.BITSTREAM_NOT_FOUND);
        osw.write("\n");
        osw.write(this.msg("bitstream-not-found-report"));
        osw.write(" ");
        osw.write(this.applyDateFormatShort(startDate));
        osw.write(" ");
        osw.write(this.msg("date-range-to"));
        osw.write(" ");
        osw.write(this.applyDateFormatShort(endDate));
        osw.write("\n\n\n");
        if (history.isEmpty()) {
            osw.write("\n\n");
            osw.write(this.msg("no-bitstreams-changed"));
            osw.write("\n");
        } else {
            this.printHistoryRecords(history, osw);
        }
        return history.size();
    }

    @Override
    public int getNotToBeProcessedReport(Context context, Instant startDate, Instant endDate, OutputStreamWriter osw) throws IOException, SQLException {
        List<MostRecentChecksum> mostRecentChecksums = this.mostRecentChecksumService.findNotProcessedBitstreamsReport(context, startDate, endDate);
        osw.write("\n");
        osw.write(this.msg("bitstream-will-no-longer-be-processed"));
        osw.write(" ");
        osw.write(this.applyDateFormatShort(startDate));
        osw.write(" ");
        osw.write(this.msg("date-range-to"));
        osw.write(" ");
        osw.write(this.applyDateFormatShort(endDate));
        osw.write("\n\n\n");
        if (mostRecentChecksums.isEmpty()) {
            osw.write("\n\n");
            osw.write(this.msg("no-bitstreams-to-no-longer-be-processed"));
            osw.write("\n");
        } else {
            this.printHistoryRecords(mostRecentChecksums, osw);
        }
        return mostRecentChecksums.size();
    }

    @Override
    public int getUncheckedBitstreamsReport(Context context, OutputStreamWriter osw) throws IOException, SQLException {
        List<Bitstream> bitstreams = this.bitstreamService.findBitstreamsWithNoRecentChecksum(context);
        osw.write("\n");
        osw.write(this.msg("unchecked-bitstream-report"));
        osw.write(" ");
        osw.write(this.applyDateFormatShort(Instant.now()));
        osw.write("\n\n\n");
        if (bitstreams.isEmpty()) {
            osw.write("\n\n");
            osw.write(this.msg("no-unchecked-bitstreams"));
            osw.write("\n");
        } else {
            osw.write(this.msg("howto-add-unchecked-bitstreams"));
            osw.write("\n\n\n");
            this.printDSpaceInfoRecords(context, bitstreams, osw);
        }
        return bitstreams.size();
    }

    protected void printHistoryRecords(List<MostRecentChecksum> mostRecentChecksums, OutputStreamWriter osw) throws IOException {
        for (MostRecentChecksum mostRecentChecksum : mostRecentChecksums) {
            StringBuilder buf = new StringBuilder(1000);
            buf.append("------------------------------------------------ \n");
            buf.append(this.msg("bitstream-id")).append(" = ").append(mostRecentChecksum.getBitstream().getID()).append("\n");
            buf.append(this.msg("process-start-date")).append(" = ").append(this.applyDateFormatLong(mostRecentChecksum.getProcessStartDate())).append("\n");
            buf.append(this.msg("process-end-date")).append(" = ").append(this.applyDateFormatLong(mostRecentChecksum.getProcessEndDate())).append("\n");
            buf.append(this.msg("checksum-expected")).append(" = ").append(mostRecentChecksum.getExpectedChecksum()).append("\n");
            buf.append(this.msg("checksum-calculated")).append(" = ").append(mostRecentChecksum.getCurrentChecksum()).append("\n");
            buf.append(this.msg("result")).append(" = ").append((Object)mostRecentChecksum.getChecksumResult().getResultCode()).append("\n");
            buf.append("----------------------------------------------- \n\n");
            osw.write(buf.toString());
        }
    }

    protected void printDSpaceInfoRecords(Context context, List<Bitstream> bitstreams, OutputStreamWriter osw) throws IOException, SQLException {
        for (Bitstream info : bitstreams) {
            StringBuilder buf = new StringBuilder(1000);
            buf.append("------------------------------------------------ \n");
            buf.append(this.msg("format-id")).append(" =  ").append(info.getFormat(context).getID()).append("\n");
            buf.append(this.msg("deleted")).append(" = ").append(info.isDeleted()).append("\n");
            buf.append(this.msg("bitstream-id")).append(" = ").append(info.getID()).append("\n");
            buf.append(this.msg("checksum-algorithm")).append(" = ").append(info.getChecksumAlgorithm()).append("\n");
            buf.append(this.msg("internal-id")).append(" = ").append(info.getInternalId()).append("\n");
            buf.append(this.msg("name")).append(" = ").append(info.getName()).append("\n");
            buf.append(this.msg("size")).append(" = ").append(info.getSizeBytes()).append("\n");
            buf.append(this.msg("source")).append(" = ").append(info.getSource()).append("\n");
            buf.append(this.msg("checksum")).append(" = ").append(info.getChecksum()).append("\n");
            buf.append(this.msg("store-number")).append(" = ").append(info.getStoreNumber()).append("\n");
            buf.append(this.msg("description")).append(" = ").append(info.getUserFormatDescription()).append("\n");
            buf.append("----------------------------------------------- \n\n");
            osw.write(buf.toString());
        }
    }

    protected String applyDateFormatLong(Instant thisDate) {
        return DateTimeFormatter.ISO_INSTANT.format(thisDate);
    }

    protected String applyDateFormatShort(Instant thisDate) {
        return DateTimeFormatter.ISO_LOCAL_DATE.format(LocalDate.ofInstant(thisDate, ZoneOffset.UTC));
    }
}

