/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authorize;

import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.dspace.authorize.service.PasswordValidatorService;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class RegexPasswordValidator
implements PasswordValidatorService {
    @Autowired
    private ConfigurationService configurationService;

    @Override
    public boolean isPasswordValidationEnabled() {
        return StringUtils.isNotBlank((String)this.getPasswordValidationPattern());
    }

    @Override
    public boolean isPasswordValid(String password) {
        if (!this.isPasswordValidationEnabled()) {
            return true;
        }
        Pattern pattern = Pattern.compile(this.getPasswordValidationPattern());
        return pattern.matcher(password).find();
    }

    private String getPasswordValidationPattern() {
        return this.configurationService.getProperty("authentication-password.regex-validation.pattern");
    }
}

