/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.suggestion.runnable;

import java.sql.SQLException;
import java.util.List;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.suggestion.SolrSuggestionProvider;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DCDate;
import org.dspace.content.Item;
import org.dspace.content.MetadataFieldName;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResultItemIterator;
import org.dspace.discovery.indexobject.IndexableItem;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.scripts.configuration.ScriptConfiguration;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.util.UUIDUtils;
import org.dspace.utils.DSpace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicationLoaderRunnable
extends DSpaceRunnable<ScriptConfiguration<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PublicationLoaderRunnable.class);
    protected Context context;
    protected String profile;
    protected String loader;
    protected String filterQuery;
    private SolrSuggestionProvider publicationLoader = null;
    private ConfigurationService configurationService;
    private ItemService itemService;
    private Integer itemLimit;
    private List<SolrSuggestionProvider> providers;

    @Override
    public ScriptConfiguration<?> getScriptConfiguration() {
        return (ScriptConfiguration)new DSpace().getServiceManager().getServiceByName("import-loader-suggestions", ScriptConfiguration.class);
    }

    @Override
    public void setup() throws ParseException {
        this.configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        this.itemService = ContentServiceFactory.getInstance().getItemService();
        this.providers = new DSpace().getServiceManager().getServicesByType(SolrSuggestionProvider.class);
        this.loader = this.commandLine.getOptionValue("l");
        this.profile = this.commandLine.getOptionValue("s");
        String string = this.filterQuery = !this.commandLine.hasOption("f") ? "" : this.commandLine.getOptionValue("f");
        if (this.profile == null) {
            LOGGER.info("No argument for -s, process all profile");
        } else {
            LOGGER.info("Process eperson item with UUID " + this.profile);
        }
        this.itemLimit = this.commandLine.hasOption("m") ? Integer.valueOf(this.commandLine.getOptionValue("m")) : this.getDefaultLimit();
    }

    @Override
    public void internalRun() throws Exception {
        if (this.loader == null) {
            throw new NullPointerException("loader can't be null");
        }
        if (this.profile != null && UUIDUtils.fromString(this.profile) == null) {
            throw new IllegalArgumentException("The provided argument -s is not a valid uuid");
        }
        this.publicationLoader = this.getPublicationLoader(this.loader);
        try {
            this.context = new Context();
            this.context.turnOffAuthorisationSystem();
            DiscoverResultItemIterator researchers = this.findResearchers();
            while (researchers.hasNext()) {
                Item researcher = researchers.next();
                researcher = this.context.reloadEntity(researcher);
                this.publicationLoader.importRecords(this.context, researcher);
                this.setLastImportMetadataValue(researcher);
                this.context.commit();
                this.context.uncacheEntity(researcher);
            }
        }
        finally {
            this.context.restoreAuthSystemState();
            this.context.complete();
        }
    }

    private SolrSuggestionProvider getPublicationLoader(String loader) {
        return this.providers.stream().filter(provider -> StringUtils.equals((CharSequence)provider.getSourceName(), (CharSequence)loader)).findFirst().orElseThrow(() -> new IllegalArgumentException("IllegalArgumentException: Provider for: " + loader + " couldn't be found"));
    }

    private DiscoverResultItemIterator findResearchers() {
        DiscoverQuery discoverQuery = new DiscoverQuery();
        discoverQuery.setDSpaceObjectFilter(IndexableItem.TYPE);
        if (StringUtils.isNotBlank((CharSequence)this.profile)) {
            discoverQuery.setQuery("search.resourceid:" + this.profile);
        }
        discoverQuery.addFilterQueries("search.resourcetype:Item");
        discoverQuery.addFilterQueries("dspace.entity.type:Person");
        discoverQuery.setSortField("lastModified", DiscoverQuery.SORT_ORDER.asc);
        if (!this.filterQuery.isEmpty()) {
            discoverQuery.addFilterQueries(this.filterQuery);
        }
        DiscoverResultItemIterator iterator = new DiscoverResultItemIterator(this.context, discoverQuery, this.itemLimit);
        return iterator;
    }

    private void setLastImportMetadataValue(Item item) {
        try {
            item = this.context.reloadEntity(item);
            String metadataField = String.format("dspace.%s.lastimport", this.loader);
            String currentDate = DCDate.getCurrent().toString();
            this.itemService.setMetadataSingleValue(this.context, item, new MetadataFieldName(metadataField), null, currentDate);
            this.itemService.update(this.context, item);
        }
        catch (SQLException | AuthorizeException e) {
            throw new RuntimeException(e);
        }
    }

    private Integer getDefaultLimit() {
        return this.configurationService.getIntProperty("suggestion.publication-loader.max", -1);
    }
}

