/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.sitemap;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import org.dspace.app.sitemap.AbstractGenerator;

public class SitemapsOrgGenerator
extends AbstractGenerator {
    protected String indexURLStem;
    protected String indexURLTail;
    protected DateTimeFormatter w3dtfFormat = DateTimeFormatter.ISO_INSTANT;

    public SitemapsOrgGenerator(File outputDirIn, String urlStem, String urlTail) {
        super(outputDirIn);
        this.indexURLStem = urlStem;
        this.indexURLTail = urlTail == null ? "" : urlTail;
    }

    @Override
    public String getFilename(int number) {
        return "sitemap" + number + ".xml";
    }

    @Override
    public String getLeadingBoilerPlate() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">";
    }

    @Override
    public int getMaxSize() {
        return 0xA00000;
    }

    @Override
    public int getMaxURLs() {
        return 50000;
    }

    @Override
    public String getTrailingBoilerPlate() {
        return "</urlset>";
    }

    @Override
    public String getURLText(String url, Instant lastMod) {
        StringBuilder urlText = new StringBuilder();
        urlText.append("<url><loc>").append(url).append("</loc>");
        if (lastMod != null) {
            urlText.append("<lastmod>").append(this.w3dtfFormat.format(lastMod)).append("</lastmod>");
        }
        urlText.append("</url>\n");
        return urlText.toString();
    }

    @Override
    public boolean useCompression() {
        return false;
    }

    @Override
    public String getIndexFilename() {
        return "sitemap_index.xml";
    }

    @Override
    public void writeIndex(PrintStream output, int sitemapCount) throws IOException {
        String now = this.w3dtfFormat.format(Instant.now());
        output.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        output.println("<sitemapindex xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">");
        for (int i = 0; i < sitemapCount; ++i) {
            output.print("<sitemap><loc>" + this.indexURLStem + i + this.indexURLTail + "</loc>");
            output.print("<lastmod>" + now + "</lastmod></sitemap>\n");
        }
        output.println("</sitemapindex>");
    }
}

