/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.requestitem;

import jakarta.annotation.ManagedBean;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.sql.SQLException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.requestitem.RequestItem;
import org.dspace.app.requestitem.RequestItemAuthor;
import org.dspace.app.requestitem.RequestItemAuthorExtractor;
import org.dspace.app.requestitem.service.RequestItemService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogHelper;
import org.dspace.core.Utils;
import org.dspace.eperson.EPerson;
import org.dspace.handle.service.HandleService;
import org.dspace.services.ConfigurationService;

@Singleton
@ManagedBean
public class RequestItemEmailNotifier {
    private static final Logger LOG = LogManager.getLogger();
    @Inject
    protected BitstreamService bitstreamService;
    @Inject
    protected ConfigurationService configurationService;
    @Inject
    protected HandleService handleService;
    @Inject
    protected RequestItemService requestItemService;
    protected final RequestItemAuthorExtractor requestItemAuthorExtractor;

    @Inject
    public RequestItemEmailNotifier(RequestItemAuthorExtractor requestItemAuthorExtractor) {
        this.requestItemAuthorExtractor = requestItemAuthorExtractor;
    }

    public void sendRequest(Context context, RequestItem ri, String responseLink) throws IOException, SQLException {
        List<RequestItemAuthor> authors = this.requestItemAuthorExtractor.getRequestItemAuthor(context, ri.getItem());
        Email email = Email.getEmail(I18nUtil.getEmailFilename(context.getCurrentLocale(), "request_item.author"));
        for (RequestItemAuthor author : authors) {
            email.addRecipient(author.getEmail());
        }
        email.setReplyTo(ri.getReqEmail());
        email.addArgument(ri.getReqName());
        email.addArgument(ri.getReqEmail());
        email.addArgument(ri.isAllfiles() ? I18nUtil.getMessage("itemRequest.all") : ri.getBitstream().getName());
        email.addArgument(this.handleService.getCanonicalForm(ri.getItem().getHandle()));
        email.addArgument(ri.getItem().getName());
        email.addArgument(ri.getReqMessage());
        email.addArgument(responseLink);
        StringBuilder names = new StringBuilder();
        StringBuilder addresses = new StringBuilder();
        for (RequestItemAuthor author : authors) {
            if (names.length() > 0) {
                names.append("; ");
                addresses.append("; ");
            }
            names.append(author.getFullName());
            addresses.append(author.getEmail());
        }
        email.addArgument(names.toString());
        email.addArgument(addresses.toString());
        email.addArgument(this.configurationService.getProperty("dspace.name"));
        email.addArgument(this.configurationService.getProperty("mail.helpdesk"));
        try {
            email.send();
            Bitstream bitstream = ri.getBitstream();
            String bitstreamID = null == bitstream ? "null" : ri.getBitstream().getID().toString();
            LOG.info(LogHelper.getHeader(context, "sent_email_requestItem", "submitter_id={},bitstream_id={},requestEmail={}"), (Object)ri.getReqEmail(), (Object)bitstreamID, (Object)ri.getReqEmail());
        }
        catch (MessagingException e) {
            LOG.warn(LogHelper.getHeader(context, "error_mailing_requestItem", e.getMessage()));
            throw new IOException("Request not sent:  " + e.getMessage());
        }
    }

    public void sendResponse(Context context, RequestItem ri, String subject, String message) throws IOException {
        String grantorAddress;
        String grantorName;
        List<RequestItemAuthor> grantors;
        try {
            grantors = this.requestItemAuthorExtractor.getRequestItemAuthor(context, ri.getItem());
        }
        catch (SQLException e) {
            LOG.warn("Failed to get grantor's name and address:  {}", (Object)e.getMessage());
            grantors = List.of();
        }
        if (grantors.isEmpty()) {
            grantorName = this.configurationService.getProperty("mail.admin.name");
            grantorAddress = this.configurationService.getProperty("mail.admin");
        } else {
            RequestItemAuthor grantor = grantors.get(0);
            grantorName = grantor.getFullName();
            grantorAddress = grantor.getEmail();
        }
        String accessExpiryFormat = this.configurationService.getProperty("request.item.grant.link.dateformat", "yyyy-MM-dd");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(accessExpiryFormat).withZone(ZoneId.of("UTC"));
        Email email = ri.isAccept_request() && ri.getAccess_token() != null ? Email.getEmail(I18nUtil.getEmailFilename(context.getCurrentLocale(), "request_item.granted_token")) : Email.getEmail(I18nUtil.getEmailFilename(context.getCurrentLocale(), ri.isAccept_request() ? "request_item.granted" : "request_item.rejected"));
        email.addArgument(ri.getReqName());
        email.addArgument(this.handleService.getCanonicalForm(ri.getItem().getHandle()));
        email.addArgument(ri.getItem().getName());
        email.addArgument(grantorName);
        email.addArgument(grantorAddress);
        email.addArgument(message);
        email.setSubject(subject);
        email.addRecipient(ri.getReqEmail());
        try {
            if (ri.isAccept_request()) {
                if (ri.getAccess_token() != null) {
                    email.addArgument(this.configurationService.getProperty("dspace.ui.url") + "/items/" + ri.getItem().getID() + "?accessToken=" + ri.getAccess_token());
                    if (ri.getAccess_expiry() != null && !ri.getAccess_expiry().equals(Utils.getMaxTimestamp())) {
                        email.addArgument(dateTimeFormatter.format(ri.getAccess_expiry()));
                    } else {
                        email.addArgument(null);
                    }
                } else if (ri.isAllfiles()) {
                    Item item = ri.getItem();
                    List<Bundle> bundles = item.getBundles("ORIGINAL");
                    for (Bundle bundle : bundles) {
                        List<Bitstream> bitstreams = bundle.getBitstreams();
                        for (Bitstream bitstream : bitstreams) {
                            if (bitstream.getFormat(context).isInternal() || !this.requestItemService.isRestricted(context, bitstream)) continue;
                            context.turnOffAuthorisationSystem();
                            email.addAttachment(this.bitstreamService.retrieve(context, bitstream), bitstream.getName(), bitstream.getFormat(context).getMIMEType());
                            context.restoreAuthSystemState();
                        }
                    }
                } else {
                    Bitstream bitstream = ri.getBitstream();
                    context.turnOffAuthorisationSystem();
                    email.addAttachment(this.bitstreamService.retrieve(context, bitstream), bitstream.getName(), bitstream.getFormat(context).getMIMEType());
                    context.restoreAuthSystemState();
                }
                email.send();
            } else {
                boolean sendRejectEmail = this.configurationService.getBooleanProperty("request.item.reject.email", true);
                if (sendRejectEmail) {
                    email.send();
                }
            }
        }
        catch (MessagingException | IOException | SQLException | AuthorizeException e) {
            LOG.warn(LogHelper.getHeader(context, "error_mailing_requestItem", e.getMessage()));
            throw new IOException("Reply not sent:  " + e.getMessage());
        }
        LOG.info(LogHelper.getHeader(context, "sent_attach_requestItem", "token={}"), (Object)ri.getToken());
    }

    public void requestOpenAccess(Context context, RequestItem ri) throws IOException {
        Email message = Email.getEmail(I18nUtil.getEmailFilename(context.getCurrentLocale(), "request_item.admin"));
        Bitstream bitstream = ri.getBitstream();
        String bitstreamName = bitstream != null ? bitstream.getName() : "all";
        Item item = ri.getItem();
        EPerson approver = context.getCurrentUser();
        message.addArgument(bitstreamName);
        message.addArgument(item.getHandle());
        message.addArgument(ri.getToken());
        if (approver != null) {
            message.addArgument(approver.getFullName());
            message.addArgument(approver.getEmail());
        } else {
            message.addArgument("anonymous approver");
            message.addArgument(this.configurationService.getProperty("mail.admin"));
        }
        EPerson submitter = item.getSubmitter();
        String recipient = submitter != null ? submitter.getEmail() : this.configurationService.getProperty("mail.helpdesk");
        if (null == recipient) {
            recipient = this.configurationService.getProperty("mail.admin");
        }
        message.addRecipient(recipient);
        try {
            message.send();
        }
        catch (MessagingException ex) {
            LOG.warn(LogHelper.getHeader(context, "error_mailing_requestItem", ex.getMessage()));
            throw new IOException("Open Access request not sent:  " + ex.getMessage());
        }
    }
}

