/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.io.InputStream;
import org.dspace.app.mediafilter.JPEGFilter;
import org.dspace.app.mediafilter.MediaFilter;
import org.dspace.content.Item;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class BrandedPreviewJPEGFilter
extends MediaFilter {
    @Override
    public String getFilteredName(String oldFilename) {
        return oldFilename + ".preview.jpg";
    }

    @Override
    public String getBundleName() {
        return "BRANDED_PREVIEW";
    }

    @Override
    public String getFormatString() {
        return "JPEG";
    }

    @Override
    public String getDescription() {
        return "Generated Branded Preview";
    }

    @Override
    public InputStream getDestinationStream(Item currentItem, InputStream source, boolean verbose) throws Exception {
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        int xmax = configurationService.getIntProperty("webui.preview.maxwidth");
        int ymax = configurationService.getIntProperty("webui.preview.maxheight");
        boolean blurring = configurationService.getBooleanProperty("webui.preview.blurring");
        boolean hqscaling = configurationService.getBooleanProperty("webui.preview.hqscaling");
        int brandHeight = configurationService.getIntProperty("webui.preview.brand.height");
        String brandFont = configurationService.getProperty("webui.preview.brand.font");
        int brandFontPoint = configurationService.getIntProperty("webui.preview.brand.fontpoint");
        JPEGFilter jpegFilter = new JPEGFilter();
        return jpegFilter.getThumb(currentItem, source, verbose, xmax, ymax, blurring, hqscaling, brandHeight, brandFontPoint, brandFont);
    }
}

