/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.sql.SQLException;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.ArrayUtils;
import org.dspace.app.bulkedit.MetadataDeletionScriptConfiguration;
import org.dspace.content.MetadataField;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataValueService;
import org.dspace.core.Context;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.utils.DSpace;

public class MetadataDeletion
extends DSpaceRunnable<MetadataDeletionScriptConfiguration<MetadataDeletion>> {
    private MetadataValueService metadataValueService;
    private MetadataFieldService metadataFieldService;
    private ConfigurationService configurationService;
    private String metadataField;
    private boolean list;

    @Override
    public void internalRun() throws Exception {
        if (this.list) {
            this.listErasableMetadata();
            return;
        }
        Context context = new Context();
        try {
            context.turnOffAuthorisationSystem();
            this.performMetadataValuesDeletion(context);
        }
        finally {
            context.restoreAuthSystemState();
            context.complete();
        }
    }

    private void listErasableMetadata() {
        Object[] erasableMetadata = this.getErasableMetadata();
        if (ArrayUtils.isEmpty((Object[])erasableMetadata)) {
            this.handler.logInfo("No fields has been configured to be cleared via bulk deletion");
        } else {
            this.handler.logInfo("The fields that can be bulk deleted are: " + String.join((CharSequence)", ", (CharSequence[])erasableMetadata));
        }
    }

    private void performMetadataValuesDeletion(Context context) throws SQLException {
        MetadataField field = this.metadataFieldService.findByString(context, this.metadataField, '.');
        if (field == null) {
            throw new IllegalArgumentException("No metadata field found with name " + this.metadataField);
        }
        if (!ArrayUtils.contains((Object[])this.getErasableMetadata(), (Object)this.metadataField)) {
            throw new IllegalArgumentException("The given metadata field cannot be bulk deleted");
        }
        this.handler.logInfo(String.format("Deleting the field '%s' from all objects", this.metadataField));
        this.metadataValueService.deleteByMetadataField(context, field);
    }

    private String[] getErasableMetadata() {
        return this.configurationService.getArrayProperty("bulkedit.allow-bulk-deletion");
    }

    @Override
    public MetadataDeletionScriptConfiguration<MetadataDeletion> getScriptConfiguration() {
        return (MetadataDeletionScriptConfiguration)new DSpace().getServiceManager().getServiceByName("metadata-deletion", MetadataDeletionScriptConfiguration.class);
    }

    @Override
    public void setup() throws ParseException {
        this.metadataValueService = ContentServiceFactory.getInstance().getMetadataValueService();
        this.metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();
        this.configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        this.metadataField = this.commandLine.getOptionValue('m');
        this.list = this.commandLine.hasOption('l');
        if (!this.list && this.metadataField == null) {
            throw new ParseException("One of the following parameters is required: -m or -l");
        }
    }
}

