/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.dspace.core.HibernateProxyHelper;
import org.dspace.core.ReloadableEntity;
import org.dspace.versioning.Version;

@Entity
@Table(name="versionhistory")
public class VersionHistory
implements ReloadableEntity<Integer> {
    @Id
    @Column(name="versionhistory_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="versionhistory_seq")
    @SequenceGenerator(name="versionhistory_seq", sequenceName="versionhistory_seq", allocationSize=1)
    private Integer id;
    @OneToMany(fetch=FetchType.EAGER, mappedBy="versionHistory")
    @OrderBy(value="versionNumber desc")
    private List<Version> versions = new ArrayList<Version>();

    protected VersionHistory() {
    }

    @Override
    public Integer getID() {
        return this.id;
    }

    protected List<Version> getVersions() {
        return this.versions;
    }

    void setVersions(List<Version> versions) {
        this.versions = versions;
    }

    void addVersionAtStart(Version version) {
        this.versions.add(0, version);
    }

    void removeVersion(Version version) {
        this.versions.remove(version);
    }

    public boolean hasDraftVersion() {
        if (CollectionUtils.isNotEmpty(this.versions) && Objects.nonNull(this.versions.get(0).getItem())) {
            return !this.versions.get(0).getItem().isArchived();
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        Class objClass = HibernateProxyHelper.getClassWithoutInitializingProxy(o);
        if (!this.getClass().equals(objClass)) {
            return false;
        }
        VersionHistory that = (VersionHistory)o;
        return this.getID().equals(that.getID());
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + this.getID();
        return hash;
    }
}

