/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.content.filter;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import org.dspace.statistics.content.filter.StatisticsFilter;

public class StatisticsSolrDateFilter
implements StatisticsFilter {
    private LocalDateTime startDate;
    private LocalDateTime endDate;
    private String startStr;
    private String endStr;
    private String typeStr;

    public void setStartStr(String startStr) {
        this.startStr = startStr;
    }

    public void setEndStr(String endStr) {
        this.endStr = endStr;
    }

    public void setTypeStr(String typeStr) {
        this.typeStr = typeStr;
    }

    public void setStartDate(LocalDateTime startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(LocalDateTime endDate) {
        this.endDate = endDate;
    }

    @Override
    public String toQuery() {
        if (this.startDate == null || this.endDate == null) {
            ChronoUnit dateType;
            LocalDate startCal = LocalDate.now();
            if (this.typeStr.equalsIgnoreCase("day")) {
                dateType = ChronoUnit.DAYS;
            } else if (this.typeStr.equalsIgnoreCase("month")) {
                dateType = ChronoUnit.MONTHS;
                startCal = startCal.withDayOfMonth(1);
            } else if (this.typeStr.equalsIgnoreCase("year")) {
                startCal = startCal.withDayOfYear(1);
                dateType = ChronoUnit.YEARS;
            } else {
                return "";
            }
            LocalDate endCal = startCal;
            if (this.startDate == null) {
                if (this.startStr.startsWith("+")) {
                    this.startStr = this.startStr.substring(this.startStr.indexOf(43) + 1);
                }
                this.startDate = startCal.plus(Integer.parseInt(this.startStr), dateType).atStartOfDay();
            }
            if (this.endDate == null) {
                if (this.endStr.startsWith("+")) {
                    this.endStr = this.endStr.substring(this.endStr.indexOf(43) + 1);
                }
                this.endDate = endCal.plus(Integer.parseInt(this.endStr), dateType).atStartOfDay();
            }
        }
        DateTimeFormatter formatter = DateTimeFormatter.ISO_INSTANT;
        String startDateParsed = formatter.format(this.startDate.toInstant(ZoneOffset.UTC));
        String endDateParsed = formatter.format(this.endDate.toInstant(ZoneOffset.UTC));
        return "time:[" + startDateParsed + " TO " + endDateParsed + "]";
    }
}

