/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.crossref;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.importer.external.metadatamapping.contributor.JsonPathMetadataProcessor;

public class CrossRefDateMetadataProcessor
implements JsonPathMetadataProcessor {
    private static final Logger log = LogManager.getLogger();
    private String pathToArray;

    @Override
    public Collection<String> processMetadata(String json) {
        JsonNode rootNode = this.convertStringJsonToJsonNode(json);
        Iterator dates = rootNode.at(this.pathToArray).iterator();
        ArrayList<String> values = new ArrayList<String>();
        while (dates.hasNext()) {
            JsonNode date = (JsonNode)dates.next();
            LocalDate issuedDate = null;
            DateTimeFormatter issuedDateFormat = null;
            if (date.has(0) && date.has(1) && date.has(2)) {
                issuedDate = LocalDate.of(date.get(0).numberValue().intValue(), date.get(1).numberValue().intValue(), date.get(2).numberValue().intValue());
                issuedDateFormat = DateTimeFormatter.ISO_LOCAL_DATE;
            } else if (date.has(0) && date.has(1)) {
                issuedDate = LocalDate.of(date.get(0).numberValue().intValue(), date.get(1).numberValue().intValue(), 1);
                issuedDateFormat = DateTimeFormatter.ofPattern("yyyy-MM");
            } else if (date.has(0)) {
                issuedDate = LocalDate.of(date.get(0).numberValue().intValue(), 1, 1);
                issuedDateFormat = DateTimeFormatter.ofPattern("yyyy");
            }
            values.add(issuedDate.format(issuedDateFormat));
        }
        return values;
    }

    private JsonNode convertStringJsonToJsonNode(String json) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode body = null;
        try {
            body = mapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            log.error("Unable to process json response.", (Throwable)e);
        }
        return body;
    }

    public void setPathToArray(String pathToArray) {
        this.pathToArray = pathToArray;
    }
}

