/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery.configuration;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.discovery.configuration.DiscoverySortFieldConfiguration;

public class DiscoverySortConfiguration {
    public static final String SCORE = "score";
    private List<DiscoverySortFieldConfiguration> sortFields = new ArrayList<DiscoverySortFieldConfiguration>();
    @Nullable
    private DiscoverySortFieldConfiguration defaultSortField;

    public List<DiscoverySortFieldConfiguration> getSortFields() {
        return this.sortFields;
    }

    public void setSortFields(List<DiscoverySortFieldConfiguration> sortFields) {
        this.sortFields = sortFields;
    }

    public DiscoverySortFieldConfiguration getDefaultSortField() {
        return this.defaultSortField;
    }

    public void setDefaultSortField(DiscoverySortFieldConfiguration configuration) {
        this.defaultSortField = configuration;
    }

    public DiscoverySortFieldConfiguration getSortFieldConfiguration(String sortField) {
        if (StringUtils.isBlank((CharSequence)sortField)) {
            return null;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)SCORE, (CharSequence)sortField)) {
            DiscoverySortFieldConfiguration configuration = new DiscoverySortFieldConfiguration();
            configuration.setMetadataField(SCORE);
            return configuration;
        }
        for (DiscoverySortFieldConfiguration sortFieldConfiguration : CollectionUtils.emptyIfNull(this.sortFields)) {
            if (!StringUtils.equals((CharSequence)sortFieldConfiguration.getMetadataField(), (CharSequence)sortField)) continue;
            return sortFieldConfiguration;
        }
        return null;
    }
}

