/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.requestitem;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.text.ParseException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.apache.http.client.utils.URIBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.dspace.app.requestitem.RequestItem;
import org.dspace.app.requestitem.dao.RequestItemDAO;
import org.dspace.app.requestitem.service.RequestItemService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.core.Utils;
import org.dspace.services.ConfigurationService;
import org.dspace.util.DateMathParser;
import org.dspace.util.MultiFormatDateParser;
import org.springframework.beans.factory.annotation.Autowired;

public class RequestItemServiceImpl
implements RequestItemService {
    private final Logger log = LogManager.getLogger();
    @Autowired(required=true)
    protected RequestItemDAO requestItemDAO;
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected ResourcePolicyService resourcePolicyService;
    @Autowired
    protected ConfigurationService configurationService;
    static DateMathParser dateMathParser = new DateMathParser(TimeZone.getTimeZone("UTC"));
    private static final int DEFAULT_MINIMUM_FILE_SIZE = 20;

    protected RequestItemServiceImpl() {
    }

    @Override
    public String createRequest(Context context, Bitstream bitstream, Item item, boolean allFiles, String reqEmail, String reqName, String reqMessage) throws SQLException {
        RequestItem requestItem = this.requestItemDAO.create(context, new RequestItem());
        requestItem.setToken(Utils.generateHexKey());
        requestItem.setBitstream(bitstream);
        requestItem.setItem(item);
        requestItem.setAllfiles(allFiles);
        requestItem.setReqEmail(reqEmail);
        requestItem.setReqName(reqName);
        requestItem.setReqMessage(reqMessage);
        requestItem.setRequest_date(Instant.now());
        if (this.configurationService.getBooleanProperty("request.item.grant.link", false)) {
            boolean minimumSizeThresholdReached;
            long minimumSize = this.configurationService.getLongProperty("request.item.grant.link.filesize", 20L) * 1024L * 1024L;
            boolean bl = minimumSizeThresholdReached = null != bitstream && bitstream.getSizeBytes() >= minimumSize;
            if (!minimumSizeThresholdReached && allFiles) {
                String[] bundleNames;
                for (String bundleName : bundleNames = this.configurationService.getArrayProperty("request.item.grant.link.bundles", new String[]{"ORIGINAL"})) {
                    if (minimumSizeThresholdReached) continue;
                    block1: for (Bundle bundle : item.getBundles(bundleName)) {
                        if (null == bundle || minimumSizeThresholdReached) continue;
                        for (Bitstream bitstreamToCheck : bundle.getBitstreams()) {
                            if (bitstreamToCheck.getSizeBytes() < minimumSize) continue;
                            minimumSizeThresholdReached = true;
                            continue block1;
                        }
                    }
                }
            }
            if (minimumSizeThresholdReached) {
                requestItem.setAccess_token(Utils.generateHexKey());
            }
        }
        this.requestItemDAO.save(context, requestItem);
        Supplier[] supplierArray = new Supplier[4];
        supplierArray[0] = requestItem::getID;
        supplierArray[1] = requestItem::getToken;
        supplierArray[2] = requestItem::getAccess_token;
        supplierArray[3] = requestItem::getAccess_expiry;
        this.log.debug("Created RequestItem with ID {}, approval token {}, access token {}, access expiry {}", supplierArray);
        return requestItem.getToken();
    }

    @Override
    public List<RequestItem> findAll(Context context) throws SQLException {
        return this.requestItemDAO.findAll(context, RequestItem.class);
    }

    @Override
    public RequestItem findByToken(Context context, String token) {
        try {
            return this.requestItemDAO.findByToken(context, token);
        }
        catch (SQLException e) {
            this.log.error(e.getMessage());
            return null;
        }
    }

    @Override
    public Iterator<RequestItem> findByItem(Context context, Item item) throws SQLException {
        return this.requestItemDAO.findByItem(context, item);
    }

    @Override
    public void update(Context context, RequestItem requestItem) {
        try {
            this.requestItemDAO.save(context, requestItem);
        }
        catch (SQLException e) {
            this.log.error(e.getMessage());
        }
    }

    @Override
    public void delete(Context context, RequestItem requestItem) {
        this.log.debug(LogHelper.getHeader(context, "delete_itemrequest", "request_id={}"), (Object)requestItem.getID());
        try {
            this.requestItemDAO.delete(context, requestItem);
        }
        catch (SQLException e) {
            this.log.error(e.getMessage());
        }
    }

    @Override
    public boolean isRestricted(Context context, DSpaceObject o) throws SQLException {
        List<ResourcePolicy> policies = this.authorizeService.getPoliciesActionFilter(context, o, 0);
        for (ResourcePolicy rp : policies) {
            if (!this.resourcePolicyService.isDateValid(rp)) continue;
            return false;
        }
        return true;
    }

    @Override
    public RequestItem findByAccessToken(Context context, String accessToken) {
        try {
            return this.requestItemDAO.findByAccessToken(context, accessToken);
        }
        catch (SQLException e) {
            this.log.error(e.getMessage());
            return null;
        }
    }

    @Override
    public void setAccessExpiry(RequestItem requestItem, Instant accessExpiry) {
        requestItem.setAccess_expiry(accessExpiry);
    }

    @Override
    public void setAccessExpiry(RequestItem requestItem, String dateOrDelta) {
        try {
            this.setAccessExpiry(requestItem, RequestItemServiceImpl.parseDateOrDelta(dateOrDelta, requestItem.getDecision_date()));
        }
        catch (ParseException e) {
            this.log.error("Error parsing access expiry or duration: {}", (Object)e.getMessage());
        }
    }

    @Override
    public void authorizeAccessByAccessToken(Context context, RequestItem requestItem, Bitstream bitstream, String accessToken) throws AuthorizeException {
        if (requestItem == null || bitstream == null || context == null || accessToken == null) {
            throw new AuthorizeException("Null resources provided, not authorized");
        }
        if (requestItem.isAccept_request() && requestItem.getAccess_token() != null && requestItem.getAccess_token().equals(accessToken) && (requestItem.isAllfiles() || bitstream.equals(requestItem.getBitstream())) && (requestItem.getAccess_expiry() == null || requestItem.getAccess_expiry().isAfter(Instant.now()))) {
            this.log.info("Authorizing access to bitstream {} by access token", (Object)bitstream.getID());
            return;
        }
        throw new AuthorizeException("Unauthorized access to bitstream by access token for bitstream ID " + bitstream.getID());
    }

    @Override
    public void authorizeAccessByAccessToken(Context context, Bitstream bitstream, String accessToken) throws AuthorizeException {
        if (bitstream == null || context == null || accessToken == null) {
            throw new AuthorizeException("Null resources provided, not authorized");
        }
        RequestItem requestItem = this.findByAccessToken(context, accessToken);
        if (requestItem == null) {
            throw new AuthorizeException("Null item request provided, not authorized");
        }
        this.authorizeAccessByAccessToken(context, requestItem, bitstream, accessToken);
    }

    @Override
    public String getLinkTokenEmail(String token) throws URISyntaxException, MalformedURLException {
        String base = this.configurationService.getProperty("dspace.ui.url");
        URIBuilder uriBuilder = new URIBuilder(base);
        String currentPath = uriBuilder.getPath();
        String newPath = currentPath == null || currentPath.isEmpty() || currentPath.equals("/") ? "/request-a-copy/" + token : currentPath + "/request-a-copy/" + token;
        URI uri = uriBuilder.setPath(newPath).build();
        return uri.toURL().toExternalForm();
    }

    @Override
    public void sanitizeRequestItem(Context context, RequestItem requestItem) {
        if (null == requestItem) {
            this.log.error("Null request item passed for sanitization, skipping");
            return;
        }
        requestItem.sanitizePersonalData();
    }

    public static Instant parseDateOrDelta(String dateOrDelta, Instant decisionDate) throws ParseException, DateTimeException {
        if (dateOrDelta == null || dateOrDelta.equals("FOREVER")) {
            return Utils.getMaxTimestamp();
        }
        ZonedDateTime parsedExpiryDate = MultiFormatDateParser.parse(dateOrDelta);
        if (parsedExpiryDate == null) {
            dateMathParser.setNow(LocalDateTime.ofInstant(decisionDate, ZoneOffset.UTC));
            return dateMathParser.parseMath(dateOrDelta).toInstant(ZoneOffset.UTC);
        }
        return parsedExpiryDate.toInstant();
    }
}

