/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.requestitem;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dspace.app.requestitem.RequestItemAuthor;
import org.dspace.app.requestitem.RequestItemAuthorExtractor;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class CombiningRequestItemStrategy
implements RequestItemAuthorExtractor {
    private final List<RequestItemAuthorExtractor> strategies;

    public CombiningRequestItemStrategy(@NonNull List<RequestItemAuthorExtractor> strategies) {
        Assert.notNull(strategies, (String)"Strategy list may not be null");
        this.strategies = strategies;
    }

    private CombiningRequestItemStrategy() {
        throw new IllegalArgumentException();
    }

    @Override
    @NonNull
    public List<RequestItemAuthor> getRequestItemAuthor(Context context, Item item) throws SQLException {
        ArrayList<RequestItemAuthor> recipients = new ArrayList<RequestItemAuthor>();
        for (RequestItemAuthorExtractor strategy : this.strategies) {
            recipients.addAll(strategy.getRequestItemAuthor(context, item));
        }
        return recipients;
    }
}

