/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemupdate;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.dspace.app.itemupdate.ActionManager;
import org.dspace.app.itemupdate.AddBitstreamsAction;
import org.dspace.app.itemupdate.AddMetadataAction;
import org.dspace.app.itemupdate.BitstreamFilter;
import org.dspace.app.itemupdate.DeleteBitstreamsAction;
import org.dspace.app.itemupdate.DeleteBitstreamsByFilterAction;
import org.dspace.app.itemupdate.DeleteMetadataAction;
import org.dspace.app.itemupdate.ItemArchive;
import org.dspace.app.itemupdate.UpdateAction;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;

public class ItemUpdate {
    public static final String SUPPRESS_UNDO_FILENAME = "suppress_undo";
    public static final String CONTENTS_FILE = "contents";
    public static final String DELETE_CONTENTS_FILE = "delete_contents";
    public static String HANDLE_PREFIX = null;
    public static final Map<String, String> filterAliases = new HashMap<String, String>();
    public static boolean verbose = false;
    protected static final EPersonService epersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected static final ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected static final HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    static FilenameFilter directoryFilter;
    static FilenameFilter fileFilter;
    protected ActionManager actionMgr = new ActionManager();
    protected List<String> undoActionList = new ArrayList<String>();
    protected String eperson;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        options.addOption("s", "source", true, "root directory of source dspace archive ");
        options.addOption("a", "addmetadata", true, "add metadata specified for each item; multiples separated by semicolon ';'");
        options.addOption("d", "deletemetadata", true, "delete metadata specified for each item");
        options.addOption("A", "addbitstreams", false, "add bitstreams as specified for each item");
        Option delBitstreamOption = new Option("D", "deletebitstreams", true, "delete bitstreams as specified for each item");
        delBitstreamOption.setOptionalArg(true);
        delBitstreamOption.setArgName("BitstreamFilter");
        options.addOption(delBitstreamOption);
        options.addOption("e", "eperson", true, "email of eperson doing the update");
        options.addOption("i", "itemfield", true, "optional metadata field that containing item identifier; default is dc.identifier.uri");
        options.addOption("F", "filter-properties", true, "filter class name; only for deleting bitstream");
        options.addOption("v", "verbose", false, "verbose logging");
        options.addOption("t", "test", false, "test run - do not actually import items");
        options.addOption("P", "provenance", false, "suppress altering provenance field for bitstream changes");
        options.addOption("h", "help", false, "help");
        int status = 0;
        boolean isTest = false;
        boolean alterProvenance = true;
        String itemField = null;
        String metadataIndexName = null;
        Context context = null;
        ItemUpdate iu = new ItemUpdate();
        try {
            String[] targetFields;
            CommandLine line = parser.parse(options, argv);
            if (line.hasOption('h')) {
                HelpFormatter myhelp = new HelpFormatter();
                myhelp.printHelp("ItemUpdate", options);
                ItemUpdate.pr("");
                ItemUpdate.pr("Examples:");
                ItemUpdate.pr("  adding metadata:     ItemUpdate -e jsmith@mit.edu -s sourcedir -a dc.contributor -a dc.subject ");
                ItemUpdate.pr("  deleting metadata:   ItemUpdate -e jsmith@mit.edu -s sourcedir -d dc.description.other");
                ItemUpdate.pr("  adding bitstreams:   ItemUpdate -e jsmith@mit.edu -s sourcedir -A -i dc.identifier");
                ItemUpdate.pr("  deleting bitstreams: ItemUpdate -e jsmith@mit.edu -s sourcedir -D ORIGINAL ");
                ItemUpdate.pr("");
                System.exit(0);
            }
            if (line.hasOption('v')) {
                verbose = true;
            }
            if (line.hasOption('P')) {
                alterProvenance = false;
                ItemUpdate.pr("Suppressing changes to Provenance field option");
            }
            iu.eperson = line.getOptionValue('e');
            if (!line.hasOption('s')) {
                ItemUpdate.pr("Missing source archive option");
                System.exit(1);
            }
            String sourcedir = line.getOptionValue('s');
            if (line.hasOption('t')) {
                isTest = true;
                ItemUpdate.pr("**Test Run** - not actually updating items.");
            }
            if (line.hasOption('i')) {
                itemField = line.getOptionValue('i');
            }
            if (line.hasOption('d')) {
                targetFields = line.getOptionValues('d');
                DeleteMetadataAction delMetadataAction = (DeleteMetadataAction)iu.actionMgr.getUpdateAction(DeleteMetadataAction.class);
                delMetadataAction.addTargetFields(targetFields);
                for (String field : targetFields) {
                    iu.undoActionList.add(" -a " + field + " ");
                }
                ItemUpdate.pr("Delete metadata for fields: ");
                for (String s : targetFields) {
                    ItemUpdate.pr("    " + s);
                }
            }
            if (line.hasOption('a')) {
                targetFields = line.getOptionValues('a');
                AddMetadataAction addMetadataAction = (AddMetadataAction)iu.actionMgr.getUpdateAction(AddMetadataAction.class);
                addMetadataAction.addTargetFields(targetFields);
                for (String field : targetFields) {
                    iu.undoActionList.add(" -d " + field + " ");
                }
                for (String field : targetFields) {
                    iu.undoActionList.add(" -a " + field + " ");
                }
                ItemUpdate.pr("Add metadata for fields: ");
                for (String s : targetFields) {
                    ItemUpdate.pr("    " + s);
                }
            }
            if (line.hasOption('D')) {
                ItemUpdate.pr("Delete bitstreams ");
                String[] filterNames = line.getOptionValues('D');
                if (filterNames != null && filterNames.length > 1) {
                    ItemUpdate.pr("Error: Only one filter can be a used at a time.");
                    System.exit(1);
                }
                String filterName = line.getOptionValue('D');
                ItemUpdate.pr("Filter argument: " + filterName);
                if (filterName == null) {
                    DeleteBitstreamsAction delAction = (DeleteBitstreamsAction)iu.actionMgr.getUpdateAction(DeleteBitstreamsAction.class);
                    delAction.setAlterProvenance(alterProvenance);
                } else {
                    String filterClassname = filterAliases.get(filterName);
                    if (filterClassname == null) {
                        filterClassname = filterName;
                    }
                    BitstreamFilter filter = null;
                    try {
                        Class<?> cfilter = Class.forName(filterClassname);
                        ItemUpdate.pr("BitstreamFilter class to instantiate: " + cfilter.toString());
                        filter = (BitstreamFilter)cfilter.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        ItemUpdate.pr("Error:  Failure instantiating bitstream filter class: " + filterClassname);
                        System.exit(1);
                    }
                    Object filterPropertiesName = line.getOptionValue('F');
                    if (filterPropertiesName != null) {
                        try {
                            if (!((String)filterPropertiesName).startsWith("/")) {
                                filterPropertiesName = sourcedir + File.separator + (String)filterPropertiesName;
                            }
                            filter.initProperties((String)filterPropertiesName);
                        }
                        catch (Exception e) {
                            ItemUpdate.pr("Error:  Failure finding properties file for bitstream filter class: " + (String)filterPropertiesName);
                            System.exit(1);
                        }
                    }
                    DeleteBitstreamsByFilterAction delAction = (DeleteBitstreamsByFilterAction)iu.actionMgr.getUpdateAction(DeleteBitstreamsByFilterAction.class);
                    delAction.setAlterProvenance(alterProvenance);
                    delAction.setBitstreamFilter(filter);
                }
            }
            if (line.hasOption('A')) {
                ItemUpdate.pr("Add bitstreams ");
                AddBitstreamsAction addAction = (AddBitstreamsAction)iu.actionMgr.getUpdateAction(AddBitstreamsAction.class);
                addAction.setAlterProvenance(alterProvenance);
                iu.undoActionList.add(" -D ");
            }
            if (!iu.actionMgr.hasActions()) {
                ItemUpdate.pr("Error - an action must be specified");
                System.exit(1);
            } else {
                ItemUpdate.pr("Actions to be performed: ");
                for (UpdateAction ua : iu.actionMgr) {
                    ItemUpdate.pr("    " + ua.getClass().getName());
                }
            }
            ItemUpdate.pr("ItemUpdate - initializing run on " + Instant.now().toString());
            context = new Context(Context.Mode.BATCH_EDIT);
            iu.setEPerson(context, iu.eperson);
            context.turnOffAuthorisationSystem();
            HANDLE_PREFIX = handleService.getCanonicalPrefix();
            iu.processArchive(context, sourcedir, itemField, metadataIndexName, alterProvenance, isTest);
            context.complete();
        }
        catch (Exception e) {
            if (context != null && context.isValid()) {
                context.abort();
            }
            e.printStackTrace();
            ItemUpdate.pr(e.toString());
            status = 1;
        }
        finally {
            context.restoreAuthSystemState();
        }
        if (isTest) {
            ItemUpdate.pr("***End of Test Run***");
        } else {
            ItemUpdate.pr("End.");
        }
        System.exit(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processArchive(Context context, String sourceDirPath, String itemField, String metadataIndexName, boolean alterProvenance, boolean isTest) throws Exception {
        File sourceDir = new File(sourceDirPath);
        if (!sourceDir.exists() || !sourceDir.isDirectory()) {
            ItemUpdate.pr("Error, cannot open archive source directory " + sourceDirPath);
            throw new Exception("error with archive source directory " + sourceDirPath);
        }
        Object[] dircontents = sourceDir.list(directoryFilter);
        Arrays.sort(dircontents);
        boolean suppressUndo = false;
        File fSuppressUndo = new File(sourceDir, SUPPRESS_UNDO_FILENAME);
        if (fSuppressUndo.exists()) {
            suppressUndo = true;
        }
        File undoDir = null;
        if (!suppressUndo && !isTest) {
            undoDir = this.initUndoArchive(sourceDir);
        }
        int itemCount = 0;
        int successItemCount = 0;
        for (Object dirname : dircontents) {
            ++itemCount;
            ItemUpdate.pr("");
            ItemUpdate.pr("processing item " + (String)dirname);
            try {
                ItemArchive itarch = ItemArchive.create(context, new File(sourceDir, (String)dirname), itemField);
                for (UpdateAction action : this.actionMgr) {
                    ItemUpdate.pr("action: " + action.getClass().getName());
                    action.execute(context, itarch, isTest, suppressUndo);
                    if (isTest || suppressUndo) continue;
                    itarch.writeUndo(undoDir);
                }
                if (!isTest) {
                    Item item = itarch.getItem();
                    itemService.update(context, item);
                    context.uncacheEntity(item);
                }
                ItemUpdate.pr("Item " + (String)dirname + " completed");
                ++successItemCount;
            }
            catch (Exception e) {
                ItemUpdate.pr("Exception processing item " + (String)dirname + ": " + e.toString());
                e.printStackTrace();
            }
        }
        if (!suppressUndo && !isTest) {
            StringBuilder sb = new StringBuilder("dsrun org.dspace.app.itemupdate.ItemUpdate ");
            sb.append(" -e ").append(this.eperson);
            sb.append(" -s ").append(undoDir);
            if (itemField != null) {
                sb.append(" -i ").append(itemField);
            }
            if (!alterProvenance) {
                sb.append(" -P ");
            }
            if (isTest) {
                sb.append(" -t ");
            }
            for (String actionOption : this.undoActionList) {
                sb.append(actionOption);
            }
            try (PrintWriter pw = null;){
                File cmdFile = new File(undoDir.getParent(), undoDir.getName() + "_command.sh");
                pw = new PrintWriter(new BufferedWriter(new FileWriter(cmdFile)));
                pw.println(sb.toString());
            }
        }
        ItemUpdate.pr("");
        ItemUpdate.pr("Done processing.  Successful items: " + successItemCount + " of " + itemCount + " items in source archive");
        ItemUpdate.pr("");
    }

    protected File initUndoArchive(File sourceDir) throws FileNotFoundException, IOException {
        File parentDir = sourceDir.getCanonicalFile().getParentFile();
        if (parentDir == null) {
            throw new FileNotFoundException("Parent directory of archive directory not found; unable to write UndoArchive; no processing performed");
        }
        String sourceDirName = sourceDir.getName();
        int seqNo = 1;
        File undoDir = new File(parentDir, "undo_" + sourceDirName + "_" + seqNo);
        while (undoDir.exists()) {
            undoDir = new File(parentDir, "undo_" + sourceDirName + "_" + ++seqNo);
        }
        if (!undoDir.mkdir()) {
            ItemUpdate.pr("ERROR creating  Undo Archive directory " + undoDir.getCanonicalPath());
            throw new IOException("ERROR creating  Undo Archive directory " + undoDir.getCanonicalPath());
        }
        File fSuppressUndo = new File(undoDir, SUPPRESS_UNDO_FILENAME);
        try {
            fSuppressUndo.createNewFile();
        }
        catch (IOException e) {
            ItemUpdate.pr("ERROR creating Suppress Undo File " + e.toString());
            throw e;
        }
        return undoDir;
    }

    protected void setEPerson(Context context, String eperson) throws Exception {
        if (eperson == null) {
            ItemUpdate.pr("Error - an eperson to do the importing must be specified");
            ItemUpdate.pr(" (run with -h flag for details)");
            throw new Exception("EPerson not specified.");
        }
        EPerson myEPerson = null;
        myEPerson = eperson.indexOf(64) != -1 ? epersonService.findByEmail(context, eperson) : (EPerson)epersonService.find(context, UUID.fromString(eperson));
        if (myEPerson == null) {
            ItemUpdate.pr("Error, eperson cannot be found: " + eperson);
            throw new Exception("Invalid EPerson");
        }
        context.setCurrentUser(myEPerson);
    }

    static void pr(String s) {
        System.out.println(s);
    }

    static void prv(String s) {
        if (verbose) {
            System.out.println(s);
        }
    }

    static {
        filterAliases.put("ORIGINAL", "org.dspace.app.itemupdate.OriginalBitstreamFilter");
        filterAliases.put("ORIGINAL_AND_DERIVATIVES", "org.dspace.app.itemupdate.OriginalWithDerivativesBitstreamFilter");
        filterAliases.put("TEXT", "org.dspace.app.itemupdate.DerivativeTextBitstreamFilter");
        filterAliases.put("THUMBNAIL", "org.dspace.app.itemupdate.ThumbnailBitstreamFilter");
        directoryFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String n) {
                File f = new File(dir.getAbsolutePath() + File.separatorChar + n);
                return f.isDirectory();
            }
        };
        fileFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String n) {
                File f = new File(dir.getAbsolutePath() + File.separatorChar + n);
                return f.isFile();
            }
        };
    }
}

