/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.script;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.orcid.OrcidHistory;
import org.dspace.orcid.OrcidQueue;
import org.dspace.orcid.exception.OrcidValidationException;
import org.dspace.orcid.factory.OrcidServiceFactory;
import org.dspace.orcid.script.OrcidBulkPushScriptConfiguration;
import org.dspace.orcid.service.OrcidHistoryService;
import org.dspace.orcid.service.OrcidQueueService;
import org.dspace.orcid.service.OrcidSynchronizationService;
import org.dspace.profile.OrcidSynchronizationMode;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.utils.DSpace;

public class OrcidBulkPush
extends DSpaceRunnable<OrcidBulkPushScriptConfiguration<OrcidBulkPush>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private OrcidQueueService orcidQueueService;
    private OrcidHistoryService orcidHistoryService;
    private OrcidSynchronizationService orcidSynchronizationService;
    private ConfigurationService configurationService;
    private Context context;
    private final Map<Item, OrcidSynchronizationMode> synchronizationModeByProfileItem = new HashMap<Item, OrcidSynchronizationMode>();
    private boolean ignoreMaxAttempts = false;

    @Override
    public void setup() throws ParseException {
        OrcidServiceFactory orcidServiceFactory = OrcidServiceFactory.getInstance();
        this.orcidQueueService = orcidServiceFactory.getOrcidQueueService();
        this.orcidHistoryService = orcidServiceFactory.getOrcidHistoryService();
        this.orcidSynchronizationService = orcidServiceFactory.getOrcidSynchronizationService();
        this.configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        if (this.commandLine.hasOption('f')) {
            this.ignoreMaxAttempts = true;
        }
    }

    @Override
    public void internalRun() throws Exception {
        if (this.isOrcidSynchronizationDisabled()) {
            this.handler.logWarning("The ORCID synchronization is disabled. The script cannot proceed");
            return;
        }
        this.context = new Context();
        this.assignCurrentUserInContext();
        try {
            this.context.turnOffAuthorisationSystem();
            this.performBulkSynchronization();
            this.context.complete();
        }
        catch (Exception e) {
            this.handler.handleException(e);
            this.context.abort();
        }
        finally {
            this.context.restoreAuthSystemState();
        }
    }

    private void performBulkSynchronization() throws SQLException {
        List<OrcidQueue> queueRecords = this.findQueueRecordsToSynchronize();
        this.handler.logInfo("Found " + queueRecords.size() + " queue records to synchronize with ORCID");
        for (OrcidQueue queueRecord : queueRecords) {
            this.performSynchronization(queueRecord);
        }
    }

    private List<OrcidQueue> findQueueRecordsToSynchronize() throws SQLException {
        return this.findQueueRecords().stream().filter(record -> this.getProfileItemSynchronizationMode(record.getProfileItem()) == OrcidSynchronizationMode.BATCH).collect(Collectors.toList());
    }

    private List<OrcidQueue> findQueueRecords() throws SQLException {
        if (this.ignoreMaxAttempts) {
            return this.orcidQueueService.findAll(this.context);
        }
        int attempts = this.configurationService.getIntProperty("orcid.bulk-synchronization.max-attempts");
        return this.orcidQueueService.findByAttemptsLessThan(this.context, attempts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSynchronization(OrcidQueue queueRecord) {
        try {
            queueRecord = this.reload(queueRecord);
            this.handler.logInfo(this.getOperationInfoMessage(queueRecord));
            OrcidHistory orcidHistory = this.orcidHistoryService.synchronizeWithOrcid(this.context, queueRecord, false);
            this.handler.logInfo(this.getSynchronizationResultMessage(orcidHistory));
            this.commitTransaction();
        }
        catch (OrcidValidationException ex) {
            this.rollbackTransaction();
            this.handler.logError(this.getValidationErrorMessage(ex));
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            String errorMessage = this.getUnexpectedErrorMessage(ex);
            LOGGER.error(errorMessage, (Throwable)ex);
            this.handler.logError(errorMessage);
        }
        finally {
            this.incrementAttempts(queueRecord);
        }
    }

    private OrcidSynchronizationMode getProfileItemSynchronizationMode(Item profileItem) {
        OrcidSynchronizationMode synchronizationMode = this.synchronizationModeByProfileItem.get(profileItem);
        if (synchronizationMode == null) {
            synchronizationMode = this.orcidSynchronizationService.getSynchronizationMode(profileItem).orElse(OrcidSynchronizationMode.MANUAL);
            this.synchronizationModeByProfileItem.put(profileItem, synchronizationMode);
        }
        return synchronizationMode;
    }

    private String getOperationInfoMessage(OrcidQueue record) {
        UUID profileItemId = record.getProfileItem().getID();
        String putCode = record.getPutCode();
        String type = record.getRecordType();
        if (record.getOperation() == null) {
            return "Synchronization of " + type + " data for profile with ID: " + profileItemId;
        }
        switch (record.getOperation()) {
            case INSERT: {
                return "Addition of " + type + " for profile with ID: " + profileItemId;
            }
            case UPDATE: {
                return "Update of " + type + " for profile with ID: " + profileItemId + " by put code " + putCode;
            }
            case DELETE: {
                return "Deletion of " + type + " for profile with ID: " + profileItemId + " by put code " + putCode;
            }
        }
        return "Synchronization of " + type + " data for profile with ID: " + profileItemId;
    }

    private String getSynchronizationResultMessage(OrcidHistory orcidHistory) {
        String message = "History record created with status " + orcidHistory.getStatus();
        switch (orcidHistory.getStatus()) {
            case 200: 
            case 201: 
            case 204: {
                message = message + ". The operation was completed successfully";
                break;
            }
            case 400: {
                message = message + ". The resource sent to ORCID registry is not valid";
                break;
            }
            case 404: {
                message = message + ". The resource does not exists anymore on the ORCID registry";
                break;
            }
            case 409: {
                message = message + ". The resource is already present on the ORCID registry";
                break;
            }
            case 500: {
                message = message + ". An internal server error on ORCID registry side occurs";
                break;
            }
            default: {
                message = message + ". Details: " + orcidHistory.getResponseMessage();
            }
        }
        return message;
    }

    private String getValidationErrorMessage(OrcidValidationException ex) {
        return ex.getMessage();
    }

    private String getUnexpectedErrorMessage(Exception ex) {
        return "An unexpected error occurs during the synchronization: " + this.getRootMessage(ex);
    }

    private void incrementAttempts(OrcidQueue queueRecord) {
        if ((queueRecord = this.reload(queueRecord)) == null) {
            return;
        }
        try {
            queueRecord.setAttempts(queueRecord.getAttempts() != null ? queueRecord.getAttempts() + 1 : 1);
            this.orcidQueueService.update(this.context, queueRecord);
            this.commitTransaction();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void assignCurrentUserInContext() throws SQLException {
        UUID uuid = this.getEpersonIdentifier();
        if (uuid != null) {
            EPerson ePerson = (EPerson)EPersonServiceFactory.getInstance().getEPersonService().find(this.context, uuid);
            this.context.setCurrentUser(ePerson);
        }
    }

    private OrcidQueue reload(OrcidQueue queueRecord) {
        try {
            return this.context.reloadEntity(queueRecord);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void commitTransaction() {
        try {
            this.context.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void rollbackTransaction() {
        try {
            this.context.rollback();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private String getRootMessage(Exception ex) {
        String message = ExceptionUtils.getRootCauseMessage((Throwable)ex);
        return StringUtils.isNotEmpty((CharSequence)message) ? message.substring(message.indexOf(":") + 1).trim() : "Generic error";
    }

    private boolean isOrcidSynchronizationDisabled() {
        return !this.configurationService.getBooleanProperty("orcid.synchronization-enabled", true);
    }

    @Override
    public OrcidBulkPushScriptConfiguration<OrcidBulkPush> getScriptConfiguration() {
        return (OrcidBulkPushScriptConfiguration)new DSpace().getServiceManager().getServiceByName("orcid-bulk-push", OrcidBulkPushScriptConfiguration.class);
    }
}

