/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.scielo.service;

import jakarta.ws.rs.BadRequestException;
import java.io.BufferedReader;
import java.io.StringReader;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.http.client.utils.URIBuilder;
import org.dspace.content.Item;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.datamodel.Query;
import org.dspace.importer.external.exception.FileSourceException;
import org.dspace.importer.external.exception.MetadataSourceException;
import org.dspace.importer.external.liveimportclient.service.LiveImportClient;
import org.dspace.importer.external.service.AbstractImportMetadataSourceService;
import org.dspace.importer.external.service.components.QuerySource;
import org.springframework.beans.factory.annotation.Autowired;

public class ScieloImportMetadataSourceServiceImpl
extends AbstractImportMetadataSourceService<Map<String, List<String>>>
implements QuerySource {
    private static final String PATTERN = "^([A-Z][A-Z0-9])  - (.*)$";
    private static final String ID_PATTERN = "^(.....)-(.*)-(...)$";
    private int timeout = 1000;
    private String url;
    @Autowired
    private LiveImportClient liveImportClient;

    @Override
    public void init() throws Exception {
    }

    @Override
    public String getImportSource() {
        return "scielo";
    }

    @Override
    public Collection<ImportRecord> getRecords(String query, int start, int count) throws MetadataSourceException {
        return this.retry(new SearchByQueryCallable(query, count, start));
    }

    @Override
    public Collection<ImportRecord> getRecords(Query query) throws MetadataSourceException {
        return this.retry(new SearchByQueryCallable(query));
    }

    @Override
    public ImportRecord getRecord(Query query) throws MetadataSourceException {
        List<ImportRecord> records = this.retry(new SearchByQueryCallable(query));
        return CollectionUtils.isEmpty(records) ? null : records.get(0);
    }

    @Override
    public ImportRecord getRecord(String id) throws MetadataSourceException {
        List<ImportRecord> records = this.retry(new FindByIdCallable(id));
        return CollectionUtils.isEmpty(records) ? null : records.get(0);
    }

    @Override
    public int getRecordsCount(String query) throws MetadataSourceException {
        return this.retry(new SearchNBByQueryCallable(query));
    }

    @Override
    public int getRecordsCount(Query query) throws MetadataSourceException {
        throw new UnsupportedOperationException("This method is not implemented for Scielo");
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Item item) throws MetadataSourceException {
        throw new UnsupportedOperationException("This method is not implemented for Scielo");
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Query query) throws MetadataSourceException {
        throw new UnsupportedOperationException("This method is not implemented for Scielo");
    }

    private Map<Integer, Map<String, List<String>>> getRecords(String resp) throws FileSourceException {
        HashMap<Integer, Map<String, List<String>>> records = new HashMap<Integer, Map<String, List<String>>>();
        int countRecord = 0;
        try {
            String line;
            BufferedReader reader = new BufferedReader(new StringReader(resp));
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.equals("") || line.matches("^\\s*$")) continue;
                line = line.replaceAll("\\uFEFF", "").trim();
                Pattern risPattern = Pattern.compile(PATTERN);
                Matcher risMatcher = risPattern.matcher(line);
                if (!risMatcher.matches()) continue;
                if (risMatcher.group(1).equals("TY") & risMatcher.group(2).equals("JOUR")) {
                    HashMap newMap = new HashMap();
                    records.put(++countRecord, newMap);
                    continue;
                }
                Map tag2values = (Map)records.get(countRecord);
                List values = (List)tag2values.get(risMatcher.group(1));
                if (Objects.isNull(values)) {
                    ArrayList<String> newValues = new ArrayList<String>();
                    newValues.add(risMatcher.group(2));
                    tag2values.put(risMatcher.group(1), newValues);
                    continue;
                }
                values.add(risMatcher.group(2));
                tag2values.put(risMatcher.group(1), values);
            }
        }
        catch (Exception e) {
            throw new FileSourceException("Cannot parse RIS file", e);
        }
        return records;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    private class SearchByQueryCallable
    implements Callable<List<ImportRecord>> {
        private Query query;

        private SearchByQueryCallable(String queryString, Integer maxResult, Integer start) {
            this.query = new Query();
            this.query.addParameter("query", queryString);
            this.query.addParameter("start", start);
            this.query.addParameter("count", maxResult);
        }

        private SearchByQueryCallable(Query query) {
            this.query = query;
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            ArrayList<ImportRecord> results = new ArrayList<ImportRecord>();
            String q = this.query.getParameterAsClass("query", String.class);
            Integer count = this.query.getParameterAsClass("count", Integer.class);
            Integer start = this.query.getParameterAsClass("start", Integer.class);
            URIBuilder uriBuilder = new URIBuilder(ScieloImportMetadataSourceServiceImpl.this.url + URLEncoder.encode(q, StandardCharsets.UTF_8));
            uriBuilder.addParameter("start", start.toString());
            uriBuilder.addParameter("count", count.toString());
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            String resp = ScieloImportMetadataSourceServiceImpl.this.liveImportClient.executeHttpGetRequest(ScieloImportMetadataSourceServiceImpl.this.timeout, uriBuilder.toString(), params);
            Map<Integer, Map<String, List<String>>> records = ScieloImportMetadataSourceServiceImpl.this.getRecords(resp);
            for (int record : records.keySet()) {
                results.add(ScieloImportMetadataSourceServiceImpl.this.transformSourceRecords(records.get(record)));
            }
            return results;
        }
    }

    private class FindByIdCallable
    implements Callable<List<ImportRecord>> {
        private String id;

        private FindByIdCallable(String id) {
            this.id = id;
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            ArrayList<ImportRecord> results = new ArrayList<ImportRecord>();
            String scieloId = this.id.trim();
            Pattern risPattern = Pattern.compile(ScieloImportMetadataSourceServiceImpl.ID_PATTERN);
            Matcher risMatcher = risPattern.matcher(scieloId);
            if (risMatcher.matches()) {
                HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
                URIBuilder uriBuilder = new URIBuilder(ScieloImportMetadataSourceServiceImpl.this.url + URLEncoder.encode(scieloId, StandardCharsets.UTF_8));
                String resp = ScieloImportMetadataSourceServiceImpl.this.liveImportClient.executeHttpGetRequest(ScieloImportMetadataSourceServiceImpl.this.timeout, uriBuilder.toString(), params);
                Map<Integer, Map<String, List<String>>> records = ScieloImportMetadataSourceServiceImpl.this.getRecords(resp);
                if (Objects.nonNull(records) & !records.isEmpty()) {
                    results.add(ScieloImportMetadataSourceServiceImpl.this.transformSourceRecords(records.get(1)));
                }
            } else {
                throw new BadRequestException("id provided : " + scieloId + " is not an ScieloID");
            }
            return results;
        }
    }

    private class SearchNBByQueryCallable
    implements Callable<Integer> {
        private String query;

        private SearchNBByQueryCallable(String queryString) {
            this.query = queryString;
        }

        private SearchNBByQueryCallable(Query query) {
            this.query = query.getParameterAsClass("query", String.class);
        }

        @Override
        public Integer call() throws Exception {
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            URIBuilder uriBuilder = new URIBuilder(ScieloImportMetadataSourceServiceImpl.this.url + URLEncoder.encode(this.query, StandardCharsets.UTF_8));
            String resp = ScieloImportMetadataSourceServiceImpl.this.liveImportClient.executeHttpGetRequest(ScieloImportMetadataSourceServiceImpl.this.timeout, uriBuilder.toString(), params);
            Map<Integer, Map<String, List<String>>> records = ScieloImportMetadataSourceServiceImpl.this.getRecords(resp);
            return Objects.nonNull(records.size()) ? records.size() : 0;
        }
    }
}

