/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.contributor;

import java.util.Collection;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.metadatamapping.contributor.JsonPathMetadataProcessor;
import org.dspace.importer.external.metadatamapping.contributor.SimpleJsonPathMetadataContributor;

public class ConditionEqualJsonPathMetadataContributor
extends SimpleJsonPathMetadataContributor {
    private static final Logger log = LogManager.getLogger(ConditionEqualJsonPathMetadataContributor.class);
    private JsonPathMetadataProcessor leftOperandProcessor;
    private String rightOperand;
    private SimpleJsonPathMetadataContributor metadatumContributor;

    @Override
    public Collection<MetadatumDTO> contributeMetadata(String json) {
        Collection<String> leftOperands = this.leftOperandProcessor.processMetadata(json);
        if (leftOperands == null || leftOperands.size() != 1) {
            log.debug("No left operands found in json path: {}", (Object)json);
            return Collections.emptyList();
        }
        if (this.rightOperand.equals(leftOperands.iterator().next())) {
            return this.metadatumContributor.contributeMetadata(json);
        }
        log.debug("No matching condition found in json path: {}", (Object)json);
        return Collections.emptyList();
    }

    public void setLeftOperandProcessor(JsonPathMetadataProcessor leftOperandProcessor) {
        this.leftOperandProcessor = leftOperandProcessor;
    }

    public void setRightOperand(String rightOperand) {
        this.rightOperand = rightOperand;
    }

    public void setMetadatumContributor(SimpleJsonPathMetadataContributor metadatumContributor) {
        this.metadatumContributor = metadatumContributor;
    }
}

