/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.health;

import jakarta.mail.MessagingException;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.core.Email;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.core.service.PluginService;
import org.dspace.health.Check;
import org.dspace.health.ReportInfo;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class Report {
    private static final Logger log = LogManager.getLogger(Report.class);
    public static final String EMAIL_PATH = "config/emails/healthcheck";
    private final StringBuilder summary_ = new StringBuilder();

    public void run(List<Integer> to_perform, ReportInfo ri) {
        int pos = -1;
        for (Map.Entry<String, Check> check_entry : Report.checks().entrySet()) {
            if (null != to_perform && !to_perform.contains(++pos)) continue;
            String check_name = check_entry.getKey();
            Check check = check_entry.getValue();
            log.info(String.format("#%d. Processing [%s] at [%s]", pos, check_name, Instant.now().toString()));
            try {
                check.report(ri);
                this.store(check_name, check.took_, check.report_);
            }
            catch (Exception e) {
                this.store(check_name, -1L, "Exception occurred when processing report - " + ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    public static LinkedHashMap<String, Check> checks() {
        LinkedHashMap<String, Check> checks = new LinkedHashMap<String, Check>();
        String[] check_names = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("healthcheck.checks");
        PluginService pluginService = CoreServiceFactory.getInstance().getPluginService();
        for (String check_name : check_names) {
            Check check = (Check)pluginService.getNamedPlugin(Check.class, check_name);
            if (null != check) {
                checks.put(check_name, check);
                continue;
            }
            log.warn(String.format("Could not find implementation for [%s]", check_name));
        }
        return checks;
    }

    public String toString() {
        return this.summary_.toString();
    }

    private void store(String name, long took, String report) {
        name = (String)name + String.format(" [took: %ds] [# lines: %d]", took / 1000L, new StringTokenizer(report, "\r\n").countTokens());
        String one_summary = String.format("\n#### %s\n%s\n\n###############################\n", name, report.replaceAll("\\s+$", ""));
        this.summary_.append(one_summary);
        System.out.println(one_summary);
    }

    public static void main(String[] args) {
        log.info("Starting healthcheck report...");
        String option_help = "h";
        String option_email = "e";
        String option_check = "c";
        String option_last_n = "f";
        String option_verbose = "v";
        Options options = new Options();
        options.addOption("h", "help", false, "Show available checks and their index.");
        options.addOption("e", "email", true, "Send report to this email address.");
        options.addOption("c", "check", true, "Perform only specific check (use index starting from 0).");
        options.addOption("f", "for", true, "For last N days.");
        options.addOption("v", "verbose", false, "Verbose report.");
        CommandLine cmdline = null;
        try {
            cmdline = new DefaultParser().parse(options, args);
        }
        catch (ParseException e) {
            log.fatal("Invalid command line " + e.toString(), (Throwable)e);
            System.exit(1);
        }
        if (cmdline.hasOption("h")) {
            Object checks_summary = "";
            int pos = 0;
            for (String check_name : Report.checks().keySet()) {
                checks_summary = (String)checks_summary + String.format("%d. %s\n", pos++, check_name);
            }
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("dspace healthcheck", options);
            System.out.println("\nAvailable checks:\n" + (String)checks_summary);
            return;
        }
        ArrayList<Integer> to_perform = null;
        if (null != cmdline.getOptionValues("c")) {
            to_perform = new ArrayList<Integer>();
            for (String s : cmdline.getOptionValues('c')) {
                to_perform.add(Integer.valueOf(s));
            }
        }
        try {
            ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
            int for_last_n_days = configurationService.getIntProperty("healthcheck.last_n_days");
            if (cmdline.hasOption("f")) {
                for_last_n_days = Integer.getInteger(cmdline.getOptionValue("f"));
            }
            ReportInfo ri = new ReportInfo(for_last_n_days);
            if (cmdline.hasOption("v")) {
                ri.verbose(true);
            }
            Report r = new Report();
            r.run(to_perform, ri);
            log.info("reports generated...");
            if (cmdline.hasOption("e")) {
                String to = cmdline.getOptionValue("e");
                if (!to.contains("@")) {
                    to = configurationService.getProperty(to);
                }
                try {
                    String dspace_dir = configurationService.getProperty("dspace.dir");
                    Object email_path = dspace_dir.endsWith("/") ? dspace_dir : dspace_dir + "/";
                    email_path = (String)email_path + EMAIL_PATH;
                    log.info(String.format("Looking for email template at [%s]", email_path));
                    Email email = Email.getEmail((String)email_path);
                    email.addRecipient(to);
                    email.addArgument(r.toString());
                    email.send();
                }
                catch (MessagingException | IOException e) {
                    log.fatal("Error sending email:", e);
                    System.err.println("Error sending email:\n" + e.getMessage());
                    System.exit(1);
                }
            }
        }
        catch (Exception e) {
            log.fatal((Object)e);
            e.printStackTrace();
        }
    }
}

