/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson.dao.impl;

import jakarta.persistence.Query;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.sql.SQLException;
import java.time.Instant;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.dspace.eperson.RegistrationData;
import org.dspace.eperson.RegistrationData_;
import org.dspace.eperson.RegistrationTypeEnum;
import org.dspace.eperson.dao.RegistrationDataDAO;

public class RegistrationDataDAOImpl
extends AbstractHibernateDAO<RegistrationData>
implements RegistrationDataDAO {
    protected RegistrationDataDAOImpl() {
    }

    @Override
    public RegistrationData findByEmail(Context context, String email) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<RegistrationData> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, RegistrationData.class);
        Root registrationDataRoot = criteriaQuery.from(RegistrationData.class);
        criteriaQuery.select((Selection)registrationDataRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)registrationDataRoot.get(RegistrationData_.email), (Object)email));
        return this.uniqueResult(context, criteriaQuery, false, RegistrationData.class);
    }

    @Override
    public RegistrationData findBy(Context context, String email, RegistrationTypeEnum type) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<RegistrationData> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, RegistrationData.class);
        Root registrationDataRoot = criteriaQuery.from(RegistrationData.class);
        criteriaQuery.select((Selection)registrationDataRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)registrationDataRoot.get(RegistrationData_.email), (Object)email), (Expression)criteriaBuilder.equal((Expression)registrationDataRoot.get(RegistrationData_.registrationType), (Object)type)));
        return this.uniqueResult(context, criteriaQuery, false, RegistrationData.class);
    }

    @Override
    public RegistrationData findByToken(Context context, String token) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<RegistrationData> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, RegistrationData.class);
        Root registrationDataRoot = criteriaQuery.from(RegistrationData.class);
        criteriaQuery.select((Selection)registrationDataRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)registrationDataRoot.get(RegistrationData_.token), (Object)token));
        return this.uniqueResult(context, criteriaQuery, false, RegistrationData.class);
    }

    @Override
    public void deleteByToken(Context context, String token) throws SQLException {
        String hql = "delete from RegistrationData where token=:token";
        Query query = this.createQuery(context, hql);
        query.setParameter("token", (Object)token);
        query.executeUpdate();
    }

    @Override
    public void deleteExpiredBy(Context context, Instant instant) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaDelete deleteQuery = criteriaBuilder.createCriteriaDelete(RegistrationData.class);
        Root deleteRoot = deleteQuery.from(RegistrationData.class);
        deleteQuery.where((Expression)criteriaBuilder.lessThanOrEqualTo((Expression)deleteRoot.get(RegistrationData_.expires), (Comparable)instant));
        this.getHibernateSession(context).createQuery(deleteQuery).executeUpdate();
    }
}

