/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.disseminate;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class PdfGenerator {
    public String parseTemplate(String templateName, Map<String, String> variables) {
        ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver(this.getClass().getClassLoader());
        templateResolver.setSuffix(".html");
        templateResolver.setOrder(Integer.valueOf(2));
        templateResolver.setTemplateMode(TemplateMode.HTML);
        TemplateEngine templateEngine = new TemplateEngine();
        templateEngine.addTemplateResolver((ITemplateResolver)templateResolver);
        Context context = new Context();
        context.setVariables(PdfGenerator.fixTypes(variables));
        return templateEngine.process(templateName, (IContext)context);
    }

    private static Map<String, Object> fixTypes(Map<String, String> variables) {
        return variables.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void generateToFile(String html, File toFile) {
        try (FileOutputStream out = new FileOutputStream(toFile);){
            this.generate(html, out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public PDDocument generate(String html) {
        PDDocument pDDocument;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.generate(html, out);
            pDDocument = PDDocument.load((byte[])out.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        out.close();
        return pDDocument;
    }

    private void generate(String html, OutputStream out) {
        ITextRenderer renderer = new ITextRenderer();
        renderer.setDocumentFromString(html);
        renderer.layout();
        renderer.createPDF(out);
    }
}

