/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.disseminate;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.disseminate.CoverPageContributor;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class DefaultCoverPageContributor
implements CoverPageContributor {
    private ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    @Override
    public Map<String, String> processCoverPageParams(Item item, Map<String, String> parameters) {
        parameters.put("page_format", this.configurationService.getProperty("citation-page.page_format", "LETTER"));
        String dcTitle = parameters.get("dc_title");
        String dcTitleSubtitle = parameters.get("dc_title_alternative");
        if (StringUtils.isBlank((CharSequence)dcTitleSubtitle)) {
            parameters.put("metadata_title", dcTitle);
        } else {
            parameters.put("metadata_title", String.format("%s: %s", dcTitle, dcTitleSubtitle));
        }
        List<String> authors = Stream.concat(this.getParams(item, "dc_contributor_author").stream(), this.getParams(item, "dc_creator").stream()).collect(Collectors.toList());
        parameters.put("metadata_author", DefaultCoverPageContributor.join(authors, "; ", 5, " ..."));
        List<String> editors = this.getParams(item, "dc_contributor_editor");
        parameters.put("metadata_editor", DefaultCoverPageContributor.join(editors, "; ", 5, " ..."));
        return parameters;
    }

    protected List<String> getParams(Item item, String metaDataField) {
        return item.getMetadata().stream().filter(meta -> meta.getMetadataField().toString().equals(metaDataField)).map(MetadataValue::getValue).collect(Collectors.toList());
    }

    protected static String join(List<String> items, String separator, int limit, String limitMessage) {
        StringBuilder sb = new StringBuilder();
        if (items.size() > limit) {
            sb.append(String.join((CharSequence)separator, items.subList(0, limit)));
            sb.append(limitMessage);
        } else {
            sb.append(String.join((CharSequence)separator, items));
        }
        return sb.toString();
    }
}

