/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.contentreport;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.dspace.contentreport.Filter;

public enum FilterCategory {
    PROPERTY("property"),
    BITSTREAM("bitstream"),
    BITSTREAM_MIME("bitstream_mime"),
    MIME("mime"),
    BUNDLE("bundle"),
    PERMISSION("permission");

    private String id;
    private List<Filter> filters;

    private FilterCategory(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = Arrays.stream(Filter.values()).filter(f -> f.getCategory() == this).collect(Collectors.toUnmodifiableList());
        }
        return this.filters;
    }
}

