/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.contentreport;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.contentreport.FilterCategory;
import org.dspace.contentreport.ItemFilterUtil;
import org.dspace.core.Context;
import org.dspace.services.factory.DSpaceServicesFactory;

public enum Filter {
    IS_ITEM(FilterCategory.PROPERTY, (context, item) -> true),
    IS_WITHDRAWN(FilterCategory.PROPERTY, (context, item) -> item.isWithdrawn()),
    IS_NOT_WITHDRAWN(FilterCategory.PROPERTY, (context, item) -> !item.isWithdrawn()),
    IS_DISCOVERABLE(FilterCategory.PROPERTY, (context, item) -> item.isDiscoverable()),
    IS_NOT_DISCOVERABLE(FilterCategory.PROPERTY, (context, item) -> !item.isDiscoverable()),
    HAS_MULTIPLE_ORIGINALS(FilterCategory.BITSTREAM, (context, item) -> ItemFilterUtil.countOriginalBitstream(item) > 1),
    HAS_NO_ORIGINALS(FilterCategory.BITSTREAM, (context, item) -> ItemFilterUtil.countOriginalBitstream(item) == 0),
    HAS_ONE_ORIGINAL(FilterCategory.BITSTREAM, (context, item) -> ItemFilterUtil.countOriginalBitstream(item) == 1),
    HAS_DOC_ORIGINAL(FilterCategory.BITSTREAM_MIME, (context, item) -> ItemFilterUtil.countOriginalBitstreamMime(context, item, ItemFilterUtil.getDocumentMimeTypes()) > 0),
    HAS_IMAGE_ORIGINAL(FilterCategory.BITSTREAM_MIME, (context, item) -> ItemFilterUtil.countOriginalBitstreamMimeStartsWith(context, item, "image") > 0),
    HAS_UNSUPPORTED_TYPE(FilterCategory.BITSTREAM_MIME, (context, item) -> {
        int imgCount;
        int bitCount = ItemFilterUtil.countOriginalBitstream(item);
        if (bitCount == 0) {
            return false;
        }
        int docCount = ItemFilterUtil.countOriginalBitstreamMime(context, item, ItemFilterUtil.getDocumentMimeTypes());
        return bitCount - docCount - (imgCount = ItemFilterUtil.countOriginalBitstreamMimeStartsWith(context, item, "image")) > 0;
    }),
    HAS_MIXED_ORIGINAL(FilterCategory.BITSTREAM_MIME, (context, item) -> {
        int countBit = ItemFilterUtil.countOriginalBitstream(item);
        if (countBit <= 1) {
            return false;
        }
        int countDoc = ItemFilterUtil.countOriginalBitstreamMime(context, item, ItemFilterUtil.getDocumentMimeTypes());
        if (countDoc > 0) {
            return countDoc != countBit;
        }
        int countImg = ItemFilterUtil.countOriginalBitstreamMimeStartsWith(context, item, "image");
        if (countImg > 0) {
            return countImg != countBit;
        }
        return false;
    }),
    HAS_PDF_ORIGINAL(FilterCategory.BITSTREAM_MIME, (context, item) -> ItemFilterUtil.countOriginalBitstreamMime(context, item, ItemFilterUtil.MIMES_PDF) > 0),
    HAS_JPEG_ORIGINAL(FilterCategory.BITSTREAM_MIME, (context, item) -> ItemFilterUtil.countOriginalBitstreamMime(context, item, ItemFilterUtil.MIMES_JPG) > 0),
    HAS_SMALL_PDF(FilterCategory.BITSTREAM_MIME, (context, item) -> ItemFilterUtil.countBitstreamSmallerThanMinSize(context, ItemFilterUtil.BundleName.ORIGINAL, item, ItemFilterUtil.MIMES_PDF, "rest.report-pdf-min-size") > 0),
    HAS_LARGE_PDF(FilterCategory.BITSTREAM_MIME, (context, item) -> ItemFilterUtil.countBitstreamLargerThanMaxSize(context, ItemFilterUtil.BundleName.ORIGINAL, item, ItemFilterUtil.MIMES_PDF, "rest.report-pdf-max-size") > 0),
    HAS_DOC_WITHOUT_TEXT(FilterCategory.BITSTREAM_MIME, (context, item) -> {
        int countDoc = ItemFilterUtil.countOriginalBitstreamMime(context, item, ItemFilterUtil.getDocumentMimeTypes());
        if (countDoc == 0) {
            return false;
        }
        int countText = ItemFilterUtil.countBitstream(ItemFilterUtil.BundleName.TEXT, item);
        return countDoc > countText;
    }),
    HAS_ONLY_SUPPORTED_IMAGE_TYPE(FilterCategory.MIME, (context, item) -> {
        int imageCount = ItemFilterUtil.countOriginalBitstreamMimeStartsWith(context, item, "image/");
        if (imageCount == 0) {
            return false;
        }
        int suppImageCount = ItemFilterUtil.countOriginalBitstreamMime(context, item, ItemFilterUtil.getSupportedImageMimeTypes());
        return imageCount == suppImageCount;
    }),
    HAS_UNSUPPORTED_IMAGE_TYPE(FilterCategory.MIME, (context, item) -> {
        int imageCount = ItemFilterUtil.countOriginalBitstreamMimeStartsWith(context, item, "image/");
        if (imageCount == 0) {
            return false;
        }
        int suppImageCount = ItemFilterUtil.countOriginalBitstreamMime(context, item, ItemFilterUtil.getSupportedImageMimeTypes());
        return imageCount - suppImageCount > 0;
    }),
    HAS_ONLY_SUPPORTED_DOC_TYPE(FilterCategory.MIME, (context, item) -> {
        int docCount = ItemFilterUtil.countOriginalBitstreamMime(context, item, ItemFilterUtil.getDocumentMimeTypes());
        if (docCount == 0) {
            return false;
        }
        int suppDocCount = ItemFilterUtil.countOriginalBitstreamMime(context, item, ItemFilterUtil.getSupportedDocumentMimeTypes());
        return docCount == suppDocCount;
    }),
    HAS_UNSUPPORTED_DOC_TYPE(FilterCategory.MIME, (context, item) -> {
        int docCount = ItemFilterUtil.countOriginalBitstreamMime(context, item, ItemFilterUtil.getDocumentMimeTypes());
        if (docCount == 0) {
            return false;
        }
        int suppDocCount = ItemFilterUtil.countOriginalBitstreamMime(context, item, ItemFilterUtil.getSupportedDocumentMimeTypes());
        return docCount - suppDocCount > 0;
    }),
    HAS_UNSUPPORTED_BUNDLE(FilterCategory.BUNDLE, (context, item) -> {
        String[] bundleList = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("rest.report-supp-bundles");
        return ItemFilterUtil.hasUnsupportedBundle(item, bundleList);
    }),
    HAS_SMALL_THUMBNAIL(FilterCategory.BUNDLE, (context, item) -> ItemFilterUtil.countBitstreamSmallerThanMinSize(context, ItemFilterUtil.BundleName.THUMBNAIL, item, ItemFilterUtil.MIMES_JPG, "rest.report-thumbnail-min-size") > 0),
    HAS_ORIGINAL_WITHOUT_THUMBNAIL(FilterCategory.BUNDLE, (context, item) -> {
        int countBit = ItemFilterUtil.countOriginalBitstream(item);
        if (countBit == 0) {
            return false;
        }
        int countThumb = ItemFilterUtil.countBitstream(ItemFilterUtil.BundleName.THUMBNAIL, item);
        return countBit > countThumb;
    }),
    HAS_INVALID_THUMBNAIL_NAME(FilterCategory.BUNDLE, (context, item) -> {
        List<String> originalNames = ItemFilterUtil.getBitstreamNames(ItemFilterUtil.BundleName.ORIGINAL, item);
        List<String> thumbNames = ItemFilterUtil.getBitstreamNames(ItemFilterUtil.BundleName.THUMBNAIL, item);
        if (thumbNames.size() != originalNames.size()) {
            return false;
        }
        return originalNames.stream().anyMatch(name -> !thumbNames.contains(name + ".jpg") && !thumbNames.contains(name + ".jpeg"));
    }),
    HAS_NON_GENERATED_THUMBNAIL(FilterCategory.BUNDLE, (context, item) -> {
        String[] generatedThumbDesc = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("rest.report-gen-thumbnail-desc");
        int countThumb = ItemFilterUtil.countBitstream(ItemFilterUtil.BundleName.THUMBNAIL, item);
        if (countThumb == 0) {
            return false;
        }
        int countGen = ItemFilterUtil.countBitstreamByDesc(ItemFilterUtil.BundleName.THUMBNAIL, item, generatedThumbDesc);
        return countThumb > countGen;
    }),
    NO_LICENSE(FilterCategory.BUNDLE, (context, item) -> ItemFilterUtil.countBitstream(ItemFilterUtil.BundleName.LICENSE, item) == 0),
    HAS_LICENSE_DOCUMENTATION(FilterCategory.BUNDLE, (context, item) -> {
        List<String> names = ItemFilterUtil.getBitstreamNames(ItemFilterUtil.BundleName.LICENSE, item);
        return names.stream().anyMatch(name -> !name.equals("license.txt"));
    }),
    HAS_RESTRICTED_ORIGINAL(FilterCategory.PERMISSION, (context, item) -> item.getBundles().stream().filter(bundle -> bundle.getName().equals(ItemFilterUtil.BundleName.ORIGINAL.name())).map(Bundle::getBitstreams).flatMap(Collection::stream).anyMatch(bit -> {
        try {
            if (!Filter.getAuthorizeService().authorizeActionBoolean(Filter.getAnonymousContext(), (DSpaceObject)bit, 0)) {
                return true;
            }
        }
        catch (SQLException e) {
            Filter.getLog().warn("SQL Exception testing original bitstream access " + e.getMessage(), (Throwable)e);
        }
        return false;
    })),
    HAS_RESTRICTED_THUMBNAIL(FilterCategory.PERMISSION, (context, item) -> item.getBundles().stream().filter(bundle -> bundle.getName().equals(ItemFilterUtil.BundleName.THUMBNAIL.name())).map(Bundle::getBitstreams).flatMap(Collection::stream).anyMatch(bit -> {
        try {
            if (!Filter.getAuthorizeService().authorizeActionBoolean(Filter.getAnonymousContext(), (DSpaceObject)bit, 0)) {
                return true;
            }
        }
        catch (SQLException e) {
            Filter.getLog().warn("SQL Exception testing thumbnail bitstream access " + e.getMessage(), (Throwable)e);
        }
        return false;
    })),
    HAS_RESTRICTED_METADATA(FilterCategory.PERMISSION, (context, item) -> {
        try {
            return !Filter.getAuthorizeService().authorizeActionBoolean(Filter.getAnonymousContext(), (DSpaceObject)item, 0);
        }
        catch (SQLException e) {
            Filter.getLog().warn("SQL Exception testing item metadata access " + e.getMessage(), (Throwable)e);
            return false;
        }
    });

    private static final Logger log;
    private static AuthorizeService authorizeService;
    private static Context anonymousContext;
    private String id;
    private FilterCategory category;
    private BiPredicate<Context, Item> itemTester;

    private Filter(FilterCategory category, BiPredicate<Context, Item> itemTester) {
        try {
            JsonProperty jp = ((Object)((Object)this)).getClass().getField(this.name()).getAnnotation(JsonProperty.class);
            this.id = Optional.ofNullable(jp).map(JsonProperty::value).orElse(this.name());
        }
        catch (Exception e) {
            this.id = this.name();
        }
        this.category = category;
        this.itemTester = itemTester;
    }

    public String getId() {
        return this.id;
    }

    public FilterCategory getCategory() {
        return this.category;
    }

    public boolean testItem(Context context, Item item) {
        return this.itemTester.test(context, item);
    }

    private static Logger getLog() {
        return log;
    }

    private static AuthorizeService getAuthorizeService() {
        if (authorizeService == null) {
            authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
        }
        return authorizeService;
    }

    private static Context getAnonymousContext() {
        if (anonymousContext == null) {
            anonymousContext = new Context();
        }
        return anonymousContext;
    }

    @JsonCreator
    public static Filter get(String id) {
        return Arrays.stream(Filter.values()).filter(item -> Objects.equals(item.id, id)).findFirst().orElse(null);
    }

    public static Set<Filter> getFilters(String filters) {
        String[] ids = Optional.ofNullable(filters).orElse("").split("[^a-z_]+");
        EnumSet<Filter> set = Arrays.stream(ids).map(Filter::get).filter(f -> f != null).collect(Collectors.toCollection(() -> EnumSet.noneOf(Filter.class)));
        if (set == null) {
            set = EnumSet.noneOf(Filter.class);
        }
        return set;
    }

    static {
        log = LogManager.getLogger();
    }
}

