/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.model.factory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.JSONObject;

public final class OrcidFactoryUtils {
    private OrcidFactoryUtils() {
    }

    public static Map<String, String> parseConfigurations(String configurations) {
        HashMap<String, String> configurationMap = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)configurations)) {
            return configurationMap;
        }
        for (String configuration : configurations.split(",")) {
            String[] configurationSections = OrcidFactoryUtils.parseConfiguration(configuration);
            configurationMap.put(configurationSections[0], configurationSections[1]);
        }
        return configurationMap;
    }

    private static String[] parseConfiguration(String configuration) {
        String[] configurations = configuration.split("::");
        if (configurations.length != 2) {
            throw new IllegalStateException("The configuration '" + configuration + "' is not valid. Expected field::type");
        }
        return configurations;
    }

    public static Optional<String> retrieveAccessToken(String clientId, String clientSecret, String oauthUrl) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)clientSecret) && StringUtils.isNotBlank((CharSequence)clientId) && StringUtils.isNotBlank((CharSequence)oauthUrl)) {
            CloseableHttpResponse response;
            String authenticationParameters = "?client_id=" + clientId + "&client_secret=" + clientSecret + "&scope=/read-public&grant_type=client_credentials";
            HttpPost httpPost = new HttpPost(oauthUrl + authenticationParameters);
            httpPost.addHeader("Accept", "application/json");
            httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
            try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
                response = httpClient.execute((HttpUriRequest)httpPost);
            }
            JSONObject responseObject = null;
            if (response != null && response.getStatusLine().getStatusCode() == 200) {
                try (InputStream is = response.getEntity().getContent();
                     BufferedReader streamReader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                    String inputStr;
                    while ((inputStr = streamReader.readLine()) != null && responseObject == null) {
                        if (!inputStr.startsWith("{") || !inputStr.endsWith("}") || !inputStr.contains("access_token")) continue;
                        responseObject = new JSONObject(inputStr);
                    }
                }
            }
            if (responseObject != null && responseObject.has("access_token")) {
                return Optional.of((String)responseObject.get("access_token"));
            }
        }
        return Optional.empty();
    }
}

