/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.matomo.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.matomo.model.MatomoRequestDetails;

public class MatomoRequestDetailsListConverter<T extends Collection<MatomoRequestDetails>>
extends JsonSerializer<T> {
    private static final Logger log = LogManager.getLogger(MatomoRequestDetailsListConverter.class);
    private final String requestTemplate = "?{0}";
    private final String keyValueTemplate = "{0}={1}";

    public void serialize(T requests, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeObject(requests.stream().map(this::mapRequest).collect(Collectors.toList()));
    }

    private String mapRequest(MatomoRequestDetails request) {
        return MessageFormat.format("?{0}", this.getRequestURL(request));
    }

    private String getRequestURL(MatomoRequestDetails request) {
        return request.parameters.entrySet().stream().filter(entry -> StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{(CharSequence)entry.getValue(), (CharSequence)entry.getKey()})).map(entry -> MessageFormat.format("{0}={1}", entry.getKey(), entry.getValue())).collect(Collectors.joining("&"));
    }
}

