/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.matomo;

import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.matomo.MatomoAbstractHandler;
import org.dspace.matomo.client.MatomoClient;
import org.dspace.matomo.model.MatomoRequestDetails;
import org.dspace.matomo.model.MatomoRequestDetailsBuilder;
import org.dspace.matomo.model.MatomoRequestDetailsSplitter;
import org.dspace.usage.UsageEvent;
import org.springframework.beans.factory.annotation.Autowired;

public class MatomoAsyncBulkRequestHandler
extends MatomoAbstractHandler {
    private static final Logger log = LogManager.getLogger(MatomoAsyncBulkRequestHandler.class);
    private final LinkedBlockingDeque<MatomoRequestDetails> deque;
    private final Lock lock = new ReentrantLock();

    public MatomoAsyncBulkRequestHandler(@Autowired MatomoRequestDetailsBuilder builder, @Autowired MatomoClient matomoClient, int capacity) {
        super(matomoClient, builder);
        this.deque = new LinkedBlockingDeque(capacity);
    }

    @Override
    public void handleEvent(UsageEvent usageEvent) {
        if (usageEvent == null) {
            log.error("Skipping UsageEvent is null");
            return;
        }
        this.lock.lock();
        try {
            this.deque.add(this.toDetails(usageEvent));
            if (this.deque.remainingCapacity() <= 1) {
                this.sendEvents();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void sendEvents() {
        this.lock.lock();
        try {
            ArrayList<MatomoRequestDetails> details = new ArrayList<MatomoRequestDetails>();
            this.deque.drainTo(details);
            MatomoRequestDetailsSplitter.split(details).values().forEach(this.matomoClient::sendDetails);
        }
        finally {
            this.lock.unlock();
        }
    }
}

