/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.ctask.general;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.curate.AbstractCurationTask;
import org.dspace.curate.Curator;
import org.dspace.curate.Distributive;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

@Distributive
public abstract class AbstractTranslator
extends AbstractCurationTask {
    protected int status = -2;
    protected final String PLUGIN_PREFIX = "translator";
    protected String authLangField = "dc.language";
    protected String authLang = "en";
    protected String[] toTranslate;
    protected String[] langs;
    protected String apiKey = "";
    private static Logger log = LogManager.getLogger(AbstractTranslator.class);
    protected List<String> results = new ArrayList<String>();
    private final transient ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    @Override
    public void init(Curator curator, String taskId) throws IOException {
        super.init(curator, taskId);
        this.authLang = this.configurationService.getProperty("default.locale");
        this.authLangField = this.configurationService.getProperty("translator.field.language");
        String[] toTranslate = this.configurationService.getArrayProperty("translator.field.targets");
        String[] langs = this.configurationService.getArrayProperty("translator.language.targets");
        if (toTranslate.length <= 0 || langs.length <= 0) {
            this.status = -1;
            this.results.add("Configuration error");
            this.setResult(this.results.toString());
            this.report(this.results.toString());
            return;
        }
        this.initApi();
    }

    @Override
    public int perform(DSpaceObject dso) throws IOException {
        if (dso instanceof Item) {
            Item item = (Item)dso;
            this.status = 0;
            String handle = item.getHandle();
            log.debug("Translating metadata for " + handle);
            List<MetadataValue> authLangs = this.itemService.getMetadataByMetadataString(item, this.authLangField);
            if (authLangs.size() > 0) {
                this.authLang = authLangs.get(0).getValue();
                log.debug("Authoritative language for " + handle + " is " + this.authLang);
            }
            for (String lang : this.langs) {
                lang = lang.trim();
                for (String field : this.toTranslate) {
                    boolean translated = false;
                    field = field.trim();
                    String[] fieldSegments = field.split("\\.");
                    List<MetadataValue> fieldMetadata = null;
                    if (fieldSegments.length > 2) {
                        checkMetadata = this.itemService.getMetadata(item, fieldSegments[0], fieldSegments[1], fieldSegments[2], lang);
                        if (checkMetadata.size() > 0) {
                            log.debug(handle + "already has " + field + " in " + lang + ", skipping");
                            this.results.add(handle + ": Skipping " + lang + " translation (" + field + ")");
                            translated = true;
                        }
                        fieldMetadata = this.itemService.getMetadata(item, fieldSegments[0], fieldSegments[1], fieldSegments[2], this.authLang);
                    } else {
                        checkMetadata = this.itemService.getMetadata(item, fieldSegments[0], fieldSegments[1], null, lang);
                        if (checkMetadata.size() > 0) {
                            log.debug(handle + "already has " + field + " in " + lang + ", skipping");
                            this.results.add(handle + ": Skipping " + lang + " translation (" + field + ")");
                            translated = true;
                        }
                        fieldMetadata = this.itemService.getMetadata(item, fieldSegments[0], fieldSegments[1], null, this.authLang);
                    }
                    if (translated || fieldMetadata.size() <= 0) continue;
                    for (MetadataValue metadataValue : fieldMetadata) {
                        String value = metadataValue.getValue();
                        String translatedText = this.translateText(this.authLang, lang, value);
                        if (translatedText != null && !"".equals(translatedText)) {
                            try {
                                if (fieldSegments.length > 2) {
                                    this.itemService.addMetadata(Curator.curationContext(), item, fieldSegments[0], fieldSegments[1], fieldSegments[2], lang, translatedText);
                                } else {
                                    this.itemService.addMetadata(Curator.curationContext(), item, fieldSegments[0], fieldSegments[1], null, lang, translatedText);
                                }
                                this.itemService.update(Curator.curationContext(), item);
                                this.results.add(handle + ": Translated " + this.authLang + " -> " + lang + " (" + field + ")");
                            }
                            catch (Exception e) {
                                log.info(e.getLocalizedMessage());
                                this.status = -1;
                            }
                            continue;
                        }
                        this.results.add(handle + ": Failed translation of " + this.authLang + " -> " + lang + "(" + field + ")");
                    }
                }
            }
        }
        this.processResults();
        return this.status;
    }

    protected void initApi() {
    }

    protected String translateText(String from, String to, String text) throws IOException {
        return null;
    }

    private void processResults() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("Translation report: \n----------------\n");
        for (String result : this.results) {
            sb.append(result).append("\n");
        }
        this.setResult(sb.toString());
        this.report(sb.toString());
    }
}

