/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.contentreport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.dspace.contentreport.Filter;
import org.dspace.contentreport.QueryPredicate;

public class FilteredItemsQuery {
    private List<String> collections = new ArrayList<String>();
    private List<QueryPredicate> queryPredicates = new ArrayList<QueryPredicate>();
    private long offset;
    private int pageLimit;
    private Set<Filter> filters = EnumSet.noneOf(Filter.class);
    private List<String> additionalFields = new ArrayList<String>();

    public static FilteredItemsQuery of(Collection<String> collectionUuids, Collection<QueryPredicate> predicates, long offset, int pageLimit, Collection<Filter> filters, Collection<String> additionalFields) {
        FilteredItemsQuery query = new FilteredItemsQuery();
        Optional.ofNullable(collectionUuids).ifPresent(query.collections::addAll);
        Optional.ofNullable(predicates).ifPresent(query.queryPredicates::addAll);
        query.offset = offset;
        query.pageLimit = pageLimit;
        Optional.ofNullable(filters).ifPresent(query.filters::addAll);
        Optional.ofNullable(additionalFields).ifPresent(query.additionalFields::addAll);
        return query;
    }

    public List<String> getCollections() {
        return this.collections;
    }

    public void setCollections(List<String> collections) {
        this.collections.clear();
        if (collections != null) {
            this.collections.addAll(collections);
        }
    }

    public List<QueryPredicate> getQueryPredicates() {
        return this.queryPredicates;
    }

    public void setQueryPredicates(List<QueryPredicate> queryPredicates) {
        this.queryPredicates.clear();
        if (queryPredicates != null) {
            this.queryPredicates.addAll(queryPredicates);
        }
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public int getPageLimit() {
        return this.pageLimit;
    }

    public void setPageLimit(int pageLimit) {
        this.pageLimit = pageLimit;
    }

    public Set<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(Set<Filter> filters) {
        this.filters.clear();
        if (filters != null) {
            this.filters.addAll(filters);
        }
    }

    public List<String> getAdditionalFields() {
        return this.additionalFields;
    }

    public void setAdditionalFields(List<String> additionalFields) {
        this.additionalFields.clear();
        if (additionalFields != null) {
            this.additionalFields.addAll(additionalFields);
        }
    }
}

