/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.statistics;

import java.io.File;
import java.io.FilenameFilter;
import java.time.Instant;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class StatisticsLoader {
    private static Map<String, StatsFile> monthlyAnalysis = null;
    private static Map<String, StatsFile> monthlyReports = null;
    private static StatsFile generalAnalysis = null;
    private static StatsFile generalReport = null;
    private static Instant lastLoaded = null;
    private static int fileCount = 0;
    private static Pattern analysisMonthlyPattern = Pattern.compile("dspace-log-monthly-([0-9][0-9][0-9][0-9]-[0-9]+)\\.dat");
    private static Pattern analysisGeneralPattern = Pattern.compile("dspace-log-general-([0-9]+-[0-9]+-[0-9]+)\\.dat");
    private static Pattern reportMonthlyPattern = Pattern.compile("report-([0-9][0-9][0-9][0-9]-[0-9]+)\\.html");
    private static Pattern reportGeneralPattern = Pattern.compile("report-general-([0-9]+-[0-9]+-[0-9]+)\\.html");
    private static ThreadLocal<DateTimeFormatter> monthlySDF = new ThreadLocal<DateTimeFormatter>(){

        @Override
        protected DateTimeFormatter initialValue() {
            return DateTimeFormatter.ofPattern("yyyy'-'M");
        }
    };
    private static ThreadLocal<DateTimeFormatter> generalSDF = new ThreadLocal<DateTimeFormatter>(){

        @Override
        protected DateTimeFormatter initialValue() {
            return DateTimeFormatter.ofPattern("yyyy'-'M'-'dd");
        }
    };

    private StatisticsLoader() {
    }

    public static LocalDate[] getMonthlyReportDates() {
        return StatisticsLoader.sortDatesDescending(StatisticsLoader.getDatesFromMap(monthlyReports));
    }

    public static LocalDate[] getMonthlyAnalysisDates() {
        return StatisticsLoader.sortDatesDescending(StatisticsLoader.getDatesFromMap(monthlyAnalysis));
    }

    protected static LocalDate[] getDatesFromMap(Map<String, StatsFile> monthlyMap) {
        Set<String> keys = monthlyMap.keySet();
        LocalDate[] dates = new LocalDate[keys.size()];
        int i = 0;
        for (String date : keys) {
            try {
                dates[i] = YearMonth.parse(date, monthlySDF.get()).atDay(1);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
            ++i;
        }
        return dates;
    }

    protected static LocalDate[] sortDatesDescending(LocalDate[] dates) {
        Arrays.sort(dates, new Comparator<LocalDate>(){

            @Override
            public int compare(LocalDate d1, LocalDate d2) {
                if (d1 == null && d2 == null) {
                    return 0;
                }
                if (d1 == null) {
                    return -1;
                }
                if (d2 == null) {
                    return 1;
                }
                if (d1.isBefore(d2)) {
                    return 1;
                }
                if (d2.isBefore(d1)) {
                    return -1;
                }
                return 0;
            }
        });
        return dates;
    }

    public static File getAnalysisFor(String date) {
        StatisticsLoader.syncFileList();
        StatsFile sf = monthlyAnalysis == null ? null : monthlyAnalysis.get(date);
        return sf == null ? null : sf.file;
    }

    public static File getReportFor(String date) {
        StatisticsLoader.syncFileList();
        StatsFile sf = monthlyReports == null ? null : monthlyReports.get(date);
        return sf == null ? null : sf.file;
    }

    public static File getGeneralAnalysis() {
        StatisticsLoader.syncFileList();
        return generalAnalysis == null ? null : StatisticsLoader.generalAnalysis.file;
    }

    public static File getGeneralReport() {
        StatisticsLoader.syncFileList();
        return generalReport == null ? null : StatisticsLoader.generalReport.file;
    }

    private static void syncFileList() {
        File[] fileList = StatisticsLoader.getAnalysisAndReportFileList();
        if (fileList != null && fileList.length != fileCount) {
            StatisticsLoader.loadFileList(fileList);
        } else if (lastLoaded == null) {
            StatisticsLoader.loadFileList(fileList);
        } else if (Instant.now().isAfter(lastLoaded.plus(1L, ChronoUnit.HOURS))) {
            StatisticsLoader.loadFileList(fileList);
        }
    }

    private static synchronized void loadFileList(File[] fileList) {
        if (fileList == null || fileList.length == 0) {
            fileList = StatisticsLoader.getAnalysisAndReportFileList();
        }
        HashMap<String, StatsFile> newMonthlyAnalysis = new HashMap<String, StatsFile>();
        HashMap<String, StatsFile> newMonthlyReports = new HashMap<String, StatsFile>();
        StatsFile newGeneralAnalysis = null;
        StatsFile newGeneralReport = null;
        if (fileList != null) {
            for (File thisFile : fileList) {
                StatsFile statsFile = null;
                if (statsFile == null && (statsFile = StatisticsLoader.makeStatsFile(thisFile, analysisMonthlyPattern, monthlySDF.get())) != null) {
                    newMonthlyAnalysis.put(statsFile.dateStr, statsFile);
                }
                if (statsFile == null && (statsFile = StatisticsLoader.makeStatsFile(thisFile, reportMonthlyPattern, monthlySDF.get())) != null) {
                    newMonthlyReports.put(statsFile.dateStr, statsFile);
                }
                if (statsFile == null && (statsFile = StatisticsLoader.makeStatsFile(thisFile, analysisGeneralPattern, generalSDF.get())) != null && (newGeneralAnalysis == null || statsFile.date.isAfter(newGeneralAnalysis.date))) {
                    newGeneralAnalysis = statsFile;
                }
                if (statsFile != null || (statsFile = StatisticsLoader.makeStatsFile(thisFile, reportGeneralPattern, generalSDF.get())) == null || newGeneralReport != null && !statsFile.date.isAfter(newGeneralReport.date)) continue;
                newGeneralReport = statsFile;
            }
        }
        monthlyAnalysis = newMonthlyAnalysis;
        monthlyReports = newMonthlyReports;
        generalAnalysis = newGeneralAnalysis;
        generalReport = newGeneralReport;
        lastLoaded = Instant.now();
    }

    private static StatsFile makeStatsFile(File thisFile, Pattern thisPattern, DateTimeFormatter formatter) {
        Matcher matcher = thisPattern.matcher(thisFile.getName());
        if (matcher.matches()) {
            StatsFile sf = new StatsFile();
            sf.file = thisFile;
            sf.path = thisFile.getPath();
            sf.dateStr = matcher.group(1).trim();
            try {
                sf.date = LocalDate.parse(sf.dateStr, formatter);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
            return sf;
        }
        return null;
    }

    private static File[] getAnalysisAndReportFileList() {
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        File reportDir = new File(configurationService.getProperty("log.report.dir"));
        return reportDir.listFiles(new AnalysisAndReportFilter());
    }

    private static class StatsFile {
        File file;
        String path;
        LocalDate date;
        String dateStr;

        private StatsFile() {
        }
    }

    private static class AnalysisAndReportFilter
    implements FilenameFilter {
        private AnalysisAndReportFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            if (analysisMonthlyPattern.matcher(name).matches()) {
                return true;
            }
            if (analysisGeneralPattern.matcher(name).matches()) {
                return true;
            }
            if (reportMonthlyPattern.matcher(name).matches()) {
                return true;
            }
            return reportGeneralPattern.matcher(name).matches();
        }
    }
}

