/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.access.status;

import java.sql.SQLException;
import java.time.LocalDate;
import java.time.ZoneId;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.access.status.AccessStatusHelper;
import org.dspace.access.status.service.AccessStatusService;
import org.dspace.content.AccessStatus;
import org.dspace.content.Bitstream;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.service.PluginService;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class AccessStatusServiceImpl
implements AccessStatusService {
    private static final Logger log = LogManager.getLogger(AccessStatusServiceImpl.class);
    protected AccessStatusHelper helper = null;
    protected LocalDate forever_date = null;
    protected String itemCalculationType = null;
    protected String bitstreamCalculationType = null;
    @Autowired(required=true)
    protected ConfigurationService configurationService;
    @Autowired(required=true)
    protected PluginService pluginService;

    public void init() throws Exception {
        if (this.helper == null) {
            this.helper = (AccessStatusHelper)this.pluginService.getSinglePlugin(AccessStatusHelper.class);
            if (this.helper == null) {
                throw new IllegalStateException("The AccessStatusHelper plugin was not defined in DSpace configuration.");
            }
            int year = this.configurationService.getIntProperty("access.status.embargo.forever.year");
            int month = this.configurationService.getIntProperty("access.status.embargo.forever.month");
            int day = this.configurationService.getIntProperty("access.status.embargo.forever.day");
            this.forever_date = LocalDate.of(year, month, day).atStartOfDay().atZone(ZoneId.systemDefault()).toLocalDate();
            this.itemCalculationType = this.getAccessStatusCalculationType("access.status.for-user.item");
            this.bitstreamCalculationType = this.getAccessStatusCalculationType("access.status.for-user.bitstream");
        }
    }

    @Override
    public AccessStatus getAccessStatus(Context context, Item item) throws SQLException {
        return this.helper.getAccessStatusFromItem(context, item, this.forever_date, this.itemCalculationType);
    }

    @Override
    public AccessStatus getAnonymousAccessStatus(Context context, Item item) throws SQLException {
        return this.helper.getAnonymousAccessStatusFromItem(context, item, this.forever_date);
    }

    @Override
    public AccessStatus getAccessStatus(Context context, Bitstream bitstream) throws SQLException {
        return this.helper.getAccessStatusFromBitstream(context, bitstream, this.forever_date, this.bitstreamCalculationType);
    }

    private String getAccessStatusCalculationType(String key) {
        String value = this.configurationService.getProperty(key, "anonymous");
        if (!StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)"anonymous") && !StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)"current")) {
            log.warn("The configuration parameter \"" + key + "\" contains an invalid value. Valid values include: 'anonymous' and 'current'.");
            value = "anonymous";
        }
        return value;
    }
}

