/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.state.actions.processingaction;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.MetadataValue;
import org.dspace.core.Context;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.actions.ActionResult;
import org.dspace.xmlworkflow.state.actions.processingaction.ProcessingAction;
import org.dspace.xmlworkflow.state.actions.processingaction.ScoreReviewAction;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;

public class ScoreEvaluationAction
extends ProcessingAction {
    private int minimumAcceptanceScore;

    @Override
    public void activate(Context c, XmlWorkflowItem wf) {
    }

    @Override
    public ActionResult execute(Context c, XmlWorkflowItem wfi, Step step, HttpServletRequest request) throws SQLException, AuthorizeException, IOException {
        int scoreMean = this.getMeanScore(wfi);
        boolean hasPassed = this.getMinimumAcceptanceScore() <= scoreMean;
        this.itemService.clearMetadata(c, wfi.getItem(), ScoreReviewAction.SCORE_FIELD.schema, ScoreReviewAction.SCORE_FIELD.element, ScoreReviewAction.SCORE_FIELD.qualifier, "*");
        if (hasPassed) {
            this.addRatingInfoToProv(c, wfi, scoreMean);
            return new ActionResult(ActionResult.TYPE.TYPE_OUTCOME, 0);
        }
        XmlWorkflowServiceFactory.getInstance().getXmlWorkflowService().sendWorkflowItemBackSubmission(c, wfi, c.getCurrentUser(), this.getProvenanceStartId(), "The item was reject due to a bad review score.");
        return new ActionResult(ActionResult.TYPE.TYPE_SUBMISSION_PAGE);
    }

    private int getMeanScore(XmlWorkflowItem wfi) {
        List<MetadataValue> scores = this.itemService.getMetadata(wfi.getItem(), ScoreReviewAction.SCORE_FIELD.schema, ScoreReviewAction.SCORE_FIELD.element, ScoreReviewAction.SCORE_FIELD.qualifier, "*");
        int scoreMean = 0;
        if (0 < scores.size()) {
            int totalScoreCount = 0;
            for (MetadataValue score : scores) {
                totalScoreCount += Integer.parseInt(score.getValue());
            }
            scoreMean = totalScoreCount / scores.size();
        }
        return scoreMean;
    }

    private void addRatingInfoToProv(Context c, XmlWorkflowItem wfi, int scoreMean) throws SQLException, AuthorizeException {
        StringBuilder provDescription = new StringBuilder();
        provDescription.append(String.format("%s Approved for entry into archive with a score of: %s", this.getProvenanceStartId(), scoreMean));
        List<MetadataValue> reviews = this.itemService.getMetadata(wfi.getItem(), ScoreReviewAction.REVIEW_FIELD.schema, ScoreReviewAction.REVIEW_FIELD.element, ScoreReviewAction.REVIEW_FIELD.qualifier, "*");
        if (!reviews.isEmpty()) {
            provDescription.append(" | Reviews: ");
        }
        for (MetadataValue review : reviews) {
            provDescription.append(String.format("; %s", review.getValue()));
        }
        c.turnOffAuthorisationSystem();
        this.itemService.addMetadata(c, wfi.getItem(), MetadataSchemaEnum.DC.getName(), "description", "provenance", "en", provDescription.toString());
        this.itemService.update(c, wfi.getItem());
        c.restoreAuthSystemState();
    }

    @Override
    public List<String> getOptions() {
        ArrayList<String> options = new ArrayList<String>();
        options.add("return_to_pool");
        return options;
    }

    public int getMinimumAcceptanceScore() {
        return this.minimumAcceptanceScore;
    }

    public void setMinimumAcceptanceScore(int minimumAcceptanceScore) {
        this.minimumAcceptanceScore = minimumAcceptanceScore;
    }
}

