/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.model.factory.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.orcid.model.OrcidEntityType;
import org.dspace.orcid.model.OrcidWorkFieldMapping;
import org.dspace.orcid.model.factory.OrcidCommonObjectFactory;
import org.dspace.orcid.model.factory.OrcidEntityFactory;
import org.orcid.jaxb.model.common.ContributorRole;
import org.orcid.jaxb.model.common.LanguageCode;
import org.orcid.jaxb.model.common.Relationship;
import org.orcid.jaxb.model.common.WorkType;
import org.orcid.jaxb.model.v3.release.common.Contributor;
import org.orcid.jaxb.model.v3.release.common.PublicationDate;
import org.orcid.jaxb.model.v3.release.common.Subtitle;
import org.orcid.jaxb.model.v3.release.common.Title;
import org.orcid.jaxb.model.v3.release.common.Url;
import org.orcid.jaxb.model.v3.release.record.Activity;
import org.orcid.jaxb.model.v3.release.record.ExternalID;
import org.orcid.jaxb.model.v3.release.record.ExternalIDs;
import org.orcid.jaxb.model.v3.release.record.Work;
import org.orcid.jaxb.model.v3.release.record.WorkContributors;
import org.orcid.jaxb.model.v3.release.record.WorkTitle;
import org.springframework.beans.factory.annotation.Autowired;

public class OrcidWorkFactory
implements OrcidEntityFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    @Autowired
    private ItemService itemService;
    @Autowired
    private OrcidCommonObjectFactory orcidCommonObjectFactory;
    private OrcidWorkFieldMapping fieldMapping;

    @Override
    public OrcidEntityType getEntityType() {
        return OrcidEntityType.PUBLICATION;
    }

    @Override
    public Activity createOrcidObject(Context context, Item item) {
        Work work = new Work();
        work.setWorkType(this.getWorkType(context, item));
        work.setJournalTitle(this.getJournalTitle(context, item));
        work.setWorkContributors(this.getWorkContributors(context, item));
        work.setWorkTitle(this.getWorkTitle(context, item));
        work.setPublicationDate(this.getPublicationDate(context, item));
        work.setWorkExternalIdentifiers(this.getWorkExternalIds(context, item, work));
        work.setShortDescription(this.getShortDescription(context, item));
        work.setLanguageCode(this.getLanguageCode(context, item));
        work.setUrl(this.getUrl(context, item));
        return work;
    }

    private Title getJournalTitle(Context context, Item item) {
        return this.getMetadataValue(context, item, this.fieldMapping.getJournalTitleField()).map(metadataValue -> new Title(metadataValue.getValue())).orElse(null);
    }

    private WorkContributors getWorkContributors(Context context, Item item) {
        Map<String, ContributorRole> contributorFields = this.fieldMapping.getContributorFields();
        List contributors = this.getMetadataValues(context, item, contributorFields.keySet()).stream().map(metadataValue -> this.getContributor(context, (MetadataValue)metadataValue)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return new WorkContributors(contributors);
    }

    private Optional<Contributor> getContributor(Context context, MetadataValue metadataValue) {
        Map<String, ContributorRole> contributorFields = this.fieldMapping.getContributorFields();
        ContributorRole role = contributorFields.get(metadataValue.getMetadataField().toString('.'));
        return this.orcidCommonObjectFactory.createContributor(context, metadataValue, role);
    }

    private WorkTitle getWorkTitle(Context context, Item item) {
        Optional<String> workTitleValue = this.getWorkTitleValue(context, item);
        if (workTitleValue.isEmpty()) {
            return null;
        }
        WorkTitle workTitle = new WorkTitle();
        workTitle.setTitle(new Title(workTitleValue.get()));
        this.getSubTitle(context, item).ifPresent(arg_0 -> ((WorkTitle)workTitle).setSubtitle(arg_0));
        return workTitle;
    }

    private Optional<String> getWorkTitleValue(Context context, Item item) {
        return this.getMetadataValue(context, item, this.fieldMapping.getTitleField()).map(MetadataValue::getValue);
    }

    private Optional<Subtitle> getSubTitle(Context context, Item item) {
        return this.getMetadataValue(context, item, this.fieldMapping.getSubTitleField()).map(MetadataValue::getValue).map(Subtitle::new);
    }

    private PublicationDate getPublicationDate(Context context, Item item) {
        return this.getMetadataValue(context, item, this.fieldMapping.getPublicationDateField()).flatMap(this.orcidCommonObjectFactory::createFuzzyDate).map(PublicationDate::new).orElse(null);
    }

    private ExternalIDs getWorkExternalIds(Context context, Item item, Work work) {
        ExternalIDs externalIDs = new ExternalIDs();
        externalIDs.getExternalIdentifier().addAll(this.getWorkExternalIdList(context, item, work));
        return externalIDs;
    }

    private List<ExternalID> getWorkExternalIdList(Context context, Item item, Work work) {
        ArrayList<ExternalID> externalIds = new ArrayList<ExternalID>();
        Map<String, String> externalIdentifierFields = this.fieldMapping.getExternalIdentifierFields();
        if (externalIdentifierFields.containsKey("$simple-handle")) {
            String handleType = externalIdentifierFields.get("$simple-handle");
            ExternalID handle = new ExternalID();
            handle.setType(handleType);
            handle.setValue(item.getHandle());
            handle.setRelationship(Relationship.SELF);
            externalIds.add(handle);
        }
        String workType = work != null && work.getWorkType() != null ? work.getWorkType().value() : WorkType.OTHER.value();
        this.getMetadataValues(context, item, externalIdentifierFields.keySet()).stream().map(metadataValue -> this.getExternalId((MetadataValue)metadataValue, workType)).forEach(externalIds::add);
        return externalIds;
    }

    private ExternalID getExternalId(MetadataValue metadataValue, String workType) {
        Map<String, String> externalIdentifierFields = this.fieldMapping.getExternalIdentifierFields();
        Map<String, List<String>> externalIdentifierPartOfMap = this.fieldMapping.getExternalIdentifierPartOfMap();
        String metadataField = metadataValue.getMetadataField().toString('.');
        String identifierType = externalIdentifierFields.get(metadataField);
        Relationship relationship = Relationship.SELF;
        if (externalIdentifierPartOfMap.containsKey(identifierType) && externalIdentifierPartOfMap.get(identifierType).contains(workType)) {
            relationship = Relationship.PART_OF;
        }
        ExternalID externalID = new ExternalID();
        externalID.setType(identifierType);
        externalID.setValue(metadataValue.getValue());
        externalID.setRelationship(relationship);
        return externalID;
    }

    private WorkType getWorkType(Context context, Item item) {
        return this.getMetadataValue(context, item, this.fieldMapping.getTypeField()).map(MetadataValue::getValue).map(type -> this.fieldMapping.convertType((String)type)).flatMap(this::getWorkType).orElse(WorkType.UNDEFINED);
    }

    private Optional<WorkType> getWorkType(String workType) {
        try {
            return Optional.ofNullable(WorkType.fromValue((String)workType));
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn("The type {} is not valid for ORCID works", (Object)workType);
            return Optional.empty();
        }
    }

    private String getShortDescription(Context context, Item item) {
        return this.getMetadataValue(context, item, this.fieldMapping.getShortDescriptionField()).map(MetadataValue::getValue).orElse(null);
    }

    private String getLanguageCode(Context context, Item item) {
        return this.getMetadataValue(context, item, this.fieldMapping.getLanguageField()).map(MetadataValue::getValue).map(language -> this.fieldMapping.convertLanguage((String)language)).filter(language -> this.isValidLanguage((String)language)).orElse(null);
    }

    private boolean isValidLanguage(String language) {
        if (StringUtils.isBlank((CharSequence)language)) {
            return false;
        }
        boolean isValid = EnumUtils.isValidEnum(LanguageCode.class, (String)language);
        if (!isValid) {
            LOGGER.warn("The language {} is not a valid language code for ORCID works", (Object)language);
        }
        return isValid;
    }

    private Url getUrl(Context context, Item item) {
        return this.orcidCommonObjectFactory.createUrl(context, item).orElse(null);
    }

    private List<MetadataValue> getMetadataValues(Context context, Item item, Collection<String> metadataFields) {
        return metadataFields.stream().flatMap(metadataField -> this.itemService.getMetadataByMetadataString(item, (String)metadataField).stream()).collect(Collectors.toList());
    }

    private Optional<MetadataValue> getMetadataValue(Context context, Item item, String metadataField) {
        if (StringUtils.isBlank((CharSequence)metadataField)) {
            return Optional.empty();
        }
        return this.itemService.getMetadataByMetadataString(item, metadataField).stream().filter(metadataValue -> StringUtils.isNotBlank((CharSequence)metadataValue.getValue())).findFirst();
    }

    public void setFieldMapping(OrcidWorkFieldMapping fieldMapping) {
        this.fieldMapping = fieldMapping;
    }
}

