/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.dspace.orcid.model.factory.OrcidFactoryUtils;
import org.dspace.util.SimpleMapConverter;
import org.orcid.jaxb.model.common.ContributorRole;

public class OrcidWorkFieldMapping {
    private Map<String, ContributorRole> contributorFields = new HashMap<String, ContributorRole>();
    private Map<String, String> externalIdentifierFields = new HashMap<String, String>();
    private Map<String, List<String>> externalIdentifierPartOfMap = new HashMap<String, List<String>>();
    private String publicationDateField;
    private String titleField;
    private String typeField;
    private String journalTitleField;
    private String shortDescriptionField;
    private String languageField;
    private String subTitleField;
    private SimpleMapConverter typeConverter;
    private SimpleMapConverter languageConverter;

    public String convertType(String type) {
        return this.typeConverter != null ? this.typeConverter.getValue(type) : type;
    }

    public String convertLanguage(String language) {
        return this.languageConverter != null ? this.languageConverter.getValue(language) : language;
    }

    public String getTitleField() {
        return this.titleField;
    }

    public void setTitleField(String titleField) {
        this.titleField = titleField;
    }

    public String getTypeField() {
        return this.typeField;
    }

    public void setTypeField(String typeField) {
        this.typeField = typeField;
    }

    public void setTypeConverter(SimpleMapConverter typeConverter) {
        this.typeConverter = typeConverter;
    }

    public Map<String, ContributorRole> getContributorFields() {
        return this.contributorFields;
    }

    public void setContributorFields(String contributorFields) {
        this.contributorFields = this.parseContributors(contributorFields);
    }

    public Map<String, String> getExternalIdentifierFields() {
        return this.externalIdentifierFields;
    }

    public void setExternalIdentifierFields(String externalIdentifierFields) {
        this.externalIdentifierFields = OrcidFactoryUtils.parseConfigurations(externalIdentifierFields);
    }

    public Map<String, List<String>> getExternalIdentifierPartOfMap() {
        return this.externalIdentifierPartOfMap;
    }

    public void setExternalIdentifierPartOfMap(HashMap<String, List<String>> externalIdentifierPartOfMap) {
        this.externalIdentifierPartOfMap = externalIdentifierPartOfMap;
    }

    public String getPublicationDateField() {
        return this.publicationDateField;
    }

    public void setPublicationDateField(String publicationDateField) {
        this.publicationDateField = publicationDateField;
    }

    public String getJournalTitleField() {
        return this.journalTitleField;
    }

    public void setJournalTitleField(String journalTitleField) {
        this.journalTitleField = journalTitleField;
    }

    public String getShortDescriptionField() {
        return this.shortDescriptionField;
    }

    public void setShortDescriptionField(String shortDescriptionField) {
        this.shortDescriptionField = shortDescriptionField;
    }

    public String getLanguageField() {
        return this.languageField;
    }

    public void setLanguageField(String languageField) {
        this.languageField = languageField;
    }

    public void setLanguageConverter(SimpleMapConverter languageConverter) {
        this.languageConverter = languageConverter;
    }

    public String getSubTitleField() {
        return this.subTitleField;
    }

    public void setSubTitleField(String subTitleField) {
        this.subTitleField = subTitleField;
    }

    private Map<String, ContributorRole> parseContributors(String contributors) {
        Map<String, String> contributorsMap = OrcidFactoryUtils.parseConfigurations(contributors);
        return contributorsMap.keySet().stream().collect(Collectors.toMap(Function.identity(), field -> this.parseContributorRole((String)contributorsMap.get(field))));
    }

    private ContributorRole parseContributorRole(String contributorRole) {
        try {
            return ContributorRole.fromValue((String)contributorRole);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("The contributor role " + contributorRole + " is invalid, allowed values are " + this.getAllowedContributorRoles(), ex);
        }
    }

    private List<String> getAllowedContributorRoles() {
        return Arrays.asList(ContributorRole.values()).stream().map(ContributorRole::value).collect(Collectors.toList());
    }
}

