/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Transient;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.content.CacheableDSpaceObject;
import org.dspace.content.DSpaceObjectLegacySupport;
import org.dspace.core.Context;
import org.dspace.core.HibernateProxyHelper;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;

@Entity
@Table(name="eperson")
public class EPerson
extends CacheableDSpaceObject
implements DSpaceObjectLegacySupport {
    @Column(name="eperson_id", insertable=false, updatable=false)
    private Integer legacyId;
    @Column(name="netid", length=64)
    private String netid;
    @Column(name="last_active")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastActive;
    @Column(name="can_log_in", nullable=true)
    private Boolean canLogIn;
    @Column(name="email", unique=true, length=64)
    private String email;
    @Column(name="require_certificate")
    private boolean requireCertificate = false;
    @Column(name="self_registered")
    private boolean selfRegistered = false;
    @Column(name="password", length=128)
    private String password;
    @Column(name="salt", length=32)
    private String salt;
    @Column(name="session_salt", length=32)
    private String sessionSalt;
    @Column(name="digest_algorithm", length=16)
    private String digestAlgorithm;
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="epeople")
    private final List<Group> groups = new ArrayList<Group>();
    public static final int EMAIL = 1;
    public static final int LASTNAME = 2;
    public static final int ID = 3;
    public static final int NETID = 4;
    public static final int LANGUAGE = 5;
    @Transient
    protected transient EPersonService ePersonService;
    @Transient
    private Date previousActive;

    protected EPerson() {
    }

    @Override
    public Integer getLegacyId() {
        return this.legacyId;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Class objClass = HibernateProxyHelper.getClassWithoutInitializingProxy(obj);
        if (this.getClass() != objClass) {
            return false;
        }
        EPerson other = (EPerson)obj;
        if (!this.getID().equals(other.getID())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)this.getEmail(), (CharSequence)other.getEmail())) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.getFullName(), (CharSequence)other.getFullName());
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + this.getID().hashCode();
        hash = 89 * hash + (this.getEmail() != null ? this.getEmail().hashCode() : 0);
        hash = 89 * hash + (this.getFullName() != null ? this.getFullName().hashCode() : 0);
        return hash;
    }

    public String getLanguage() {
        return this.getePersonService().getMetadataFirstValue(this, "eperson", "language", null, "*");
    }

    public void setLanguage(Context context, String language) throws SQLException {
        this.getePersonService().setMetadataSingleValue(context, this, "eperson", "language", null, null, language);
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String s) {
        this.email = StringUtils.lowerCase((String)s);
        this.setModified();
    }

    public String getNetid() {
        return this.netid;
    }

    public void setNetid(String netid) {
        this.netid = netid;
        this.setModified();
    }

    public String getFullName() {
        String f = this.getFirstName();
        String l = this.getLastName();
        if (l == null && f == null) {
            return this.getEmail();
        }
        if (f == null) {
            return l;
        }
        return f + " " + l;
    }

    public String getFirstName() {
        return this.getePersonService().getMetadataFirstValue(this, "eperson", "firstname", null, "*");
    }

    public void setFirstName(Context context, String firstname) throws SQLException {
        this.getePersonService().setMetadataSingleValue(context, this, "eperson", "firstname", null, null, firstname);
        this.setModified();
    }

    public String getLastName() {
        return this.getePersonService().getMetadataFirstValue(this, "eperson", "lastname", null, "*");
    }

    public void setLastName(Context context, String lastname) throws SQLException {
        this.getePersonService().setMetadataSingleValue(context, this, "eperson", "lastname", null, null, lastname);
        this.setModified();
    }

    public void setCanLogIn(boolean login) {
        this.canLogIn = login;
        this.setModified();
    }

    public boolean canLogIn() {
        return BooleanUtils.isTrue((Boolean)this.canLogIn);
    }

    public void setRequireCertificate(boolean isrequired) {
        this.requireCertificate = isrequired;
        this.setModified();
    }

    public boolean getRequireCertificate() {
        return this.requireCertificate;
    }

    public void setSelfRegistered(boolean sr) {
        this.selfRegistered = sr;
        this.setModified();
    }

    public boolean getSelfRegistered() {
        return this.selfRegistered;
    }

    public void setLastActive(Date when) {
        this.previousActive = this.lastActive;
        this.lastActive = when;
    }

    public Date getLastActive() {
        return this.lastActive;
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public String getName() {
        return this.getFullName();
    }

    String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    String getSalt() {
        return this.salt;
    }

    void setSalt(String salt) {
        this.salt = salt;
    }

    String getPassword() {
        return this.password;
    }

    void setPassword(String password) {
        this.password = password;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    private EPersonService getePersonService() {
        if (this.ePersonService == null) {
            this.ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
        }
        return this.ePersonService;
    }

    public String getSessionSalt() {
        return this.sessionSalt;
    }

    public void setSessionSalt(String sessionSalt) {
        this.sessionSalt = sessionSalt;
    }

    public Date getPreviousActive() {
        if (this.previousActive == null) {
            return new Date(0L);
        }
        return this.previousActive;
    }

    public boolean hasPasswordSet() {
        return StringUtils.isNotBlank((CharSequence)this.getPassword());
    }
}

