/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import jakarta.mail.MessagingException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.json.BucketBasedJsonFacet;
import org.apache.solr.client.solrj.response.json.BucketJsonFacet;
import org.apache.solr.client.solrj.response.json.NestableJsonFacet;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogHelper;
import org.dspace.discovery.DiscoverFacetField;
import org.dspace.discovery.DiscoverFilterQuery;
import org.dspace.discovery.DiscoverHitHighlightingField;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.FacetYearRange;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.IndexingService;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SolrSearchCore;
import org.dspace.discovery.SolrServiceSearchPlugin;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoveryConfigurationParameters;
import org.dspace.discovery.configuration.DiscoveryMoreLikeThisConfiguration;
import org.dspace.discovery.configuration.DiscoverySearchFilterFacet;
import org.dspace.discovery.indexobject.IndexableCollection;
import org.dspace.discovery.indexobject.IndexableCommunity;
import org.dspace.discovery.indexobject.IndexableItem;
import org.dspace.discovery.indexobject.factory.IndexFactory;
import org.dspace.discovery.indexobject.factory.IndexObjectFactoryFactory;
import org.dspace.discovery.indexobject.factory.ItemIndexFactory;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SolrServiceImpl
implements SearchService,
IndexingService {
    private static final Logger log = LogManager.getLogger(SolrServiceImpl.class);
    public static final String SOLR_FIELD_SUFFIX_FACET_PREFIXES = "_prefix";
    @Autowired
    protected ContentServiceFactory contentServiceFactory;
    @Autowired
    protected GroupService groupService;
    @Autowired
    protected IndexObjectFactoryFactory indexObjectServiceFactory;
    @Autowired
    protected SolrSearchCore solrSearchCore;
    @Autowired
    protected ConfigurationService configurationService;

    protected SolrServiceImpl() {
    }

    @Override
    public void indexContent(Context context, IndexableObject dso) throws SQLException {
        this.indexContent(context, dso, false);
    }

    @Override
    public void indexContent(Context context, IndexableObject indexableObject, boolean force) {
        try {
            IndexFactory indexableObjectFactory = this.indexObjectServiceFactory.getIndexableObjectFactory(indexableObject);
            if (force || this.requiresIndexing(indexableObject.getUniqueIndexID(), indexableObject.getLastModified())) {
                this.update(context, indexableObjectFactory, indexableObject);
                log.info(LogHelper.getHeader(context, "indexed_object", indexableObject.getUniqueIndexID()));
            }
        }
        catch (IOException | SQLException | SolrServerException | SearchServiceException e) {
            log.error(e.getMessage(), e);
        }
    }

    protected void update(Context context, IndexFactory indexableObjectService, IndexableObject indexableObject) throws IOException, SQLException, SolrServerException {
        SolrInputDocument solrInputDocument = indexableObjectService.buildDocument(context, indexableObject);
        indexableObjectService.writeDocument(context, indexableObject, solrInputDocument);
    }

    protected void update(Context context, IndexFactory indexableObjectService, IndexableObject indexableObject, boolean preDB) throws IOException, SQLException, SolrServerException {
        if (preDB) {
            SolrInputDocument solrInputDocument = indexableObjectService.buildNewDocument(context, indexableObject);
            indexableObjectService.writeDocument(context, indexableObject, solrInputDocument);
        } else {
            this.update(context, indexableObjectService, indexableObject);
        }
    }

    @Override
    public void unIndexContent(Context context, IndexableObject dso) throws SQLException, IOException {
        this.unIndexContent(context, dso, false);
    }

    @Override
    public void unIndexContent(Context context, IndexableObject indexableObject, boolean commit) throws SQLException, IOException {
        try {
            if (indexableObject == null) {
                return;
            }
            String uniqueID = indexableObject.getUniqueIndexID();
            log.info("Try to delete uniqueID:" + uniqueID);
            this.indexObjectServiceFactory.getIndexableObjectFactory(indexableObject).delete(indexableObject);
            if (commit) {
                this.solrSearchCore.getSolr().commit();
            }
        }
        catch (IOException | SolrServerException exception) {
            log.error(exception.getMessage(), exception);
            this.emailException((Exception)exception);
        }
    }

    @Override
    public void unIndexContent(Context context, String searchUniqueID) throws IOException {
        this.unIndexContent(context, searchUniqueID, false);
    }

    @Override
    public void unIndexContent(Context context, String searchUniqueID, boolean commit) throws IOException {
        try {
            if (this.solrSearchCore.getSolr() != null) {
                IndexFactory index = this.indexObjectServiceFactory.getIndexableObjectFactory(searchUniqueID);
                if (index != null) {
                    index.delete(searchUniqueID);
                } else {
                    log.warn("Object not found in Solr index: " + searchUniqueID);
                }
                if (commit) {
                    this.solrSearchCore.getSolr().commit();
                }
            }
        }
        catch (SolrServerException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void reIndexContent(Context context, IndexableObject dso) throws SQLException, IOException {
        try {
            this.indexContent(context, dso);
        }
        catch (SQLException exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            this.emailException(exception);
        }
    }

    @Override
    public void createIndex(Context c) throws SQLException, IOException {
        this.updateIndex(c, true);
    }

    @Override
    public void updateIndex(Context context) {
        this.updateIndex(context, false);
    }

    @Override
    public void updateIndex(Context context, boolean force) {
        this.updateIndex(context, force, null);
    }

    @Override
    public void updateIndex(Context context, boolean force, String type) {
        try {
            List<IndexFactory> indexableObjectServices = this.indexObjectServiceFactory.getIndexFactories();
            int indexObject = 0;
            for (IndexFactory indexableObjectService : indexableObjectServices) {
                if (type != null && !StringUtils.equals((CharSequence)indexableObjectService.getType(), (CharSequence)type)) continue;
                Iterator indexableObjects = indexableObjectService.findAll(context);
                while (indexableObjects.hasNext()) {
                    IndexableObject indexableObject = (IndexableObject)indexableObjects.next();
                    this.indexContent(context, indexableObject, force);
                    context.uncacheEntity(indexableObject.getIndexedObject());
                    if (++indexObject % 100 != 0 || !(indexableObjectService instanceof ItemIndexFactory)) continue;
                    context.uncacheEntities();
                }
            }
            if (this.solrSearchCore.getSolr() != null) {
                this.solrSearchCore.getSolr().commit();
            }
        }
        catch (IOException | SQLException | SolrServerException e) {
            log.error(e.getMessage(), e);
        }
    }

    @Override
    public void deleteIndex() {
        try {
            List<IndexFactory> indexableObjectServices = this.indexObjectServiceFactory.getIndexFactories();
            for (IndexFactory indexableObjectService : indexableObjectServices) {
                indexableObjectService.deleteAll();
            }
        }
        catch (IOException | SolrServerException e) {
            log.error("Error cleaning discovery index: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanIndex() throws IOException, SQLException, SearchServiceException {
        Context context = new Context();
        context.turnOffAuthorisationSystem();
        try {
            if (this.solrSearchCore.getSolr() == null) {
                return;
            }
            SolrQuery countQuery = new SolrQuery("*:*");
            countQuery.setRows(Integer.valueOf(0));
            QueryResponse totalResponse = this.solrSearchCore.getSolr().query((SolrParams)countQuery, this.solrSearchCore.REQUEST_METHOD);
            long total = totalResponse.getResults().getNumFound();
            int start = 0;
            int batch = 100;
            SolrQuery query = new SolrQuery();
            query.setFields(new String[]{"search.uniqueid", "search.resourceid", "search.resourcetype"});
            query.addSort("search.uniqueid", SolrQuery.ORDER.asc);
            query.setQuery("*:*");
            query.setRows(Integer.valueOf(batch));
            while ((long)start < total) {
                query.setStart(Integer.valueOf(start));
                QueryResponse rsp = this.solrSearchCore.getSolr().query((SolrParams)query, this.solrSearchCore.REQUEST_METHOD);
                SolrDocumentList docs = rsp.getResults();
                for (SolrDocument doc : docs) {
                    String uniqueID = (String)doc.getFieldValue("search.uniqueid");
                    IndexableObject o = this.findIndexableObject(context, doc);
                    if (o == null) {
                        log.info("Deleting: " + uniqueID);
                        this.unIndexContent(context, uniqueID);
                        continue;
                    }
                    log.debug("Keeping: " + o.getUniqueIndexID());
                }
                start += batch;
            }
        }
        catch (IOException | SQLException | SolrServerException e) {
            log.error("Error cleaning discovery index: " + e.getMessage(), e);
        }
        finally {
            context.abort();
        }
    }

    @Override
    public void optimize() {
        try {
            if (this.solrSearchCore.getSolr() == null) {
                return;
            }
            long start = System.currentTimeMillis();
            System.out.println("SOLR Search Optimize -- Process Started:" + start);
            this.solrSearchCore.getSolr().optimize();
            long finish = System.currentTimeMillis();
            System.out.println("SOLR Search Optimize -- Process Finished:" + finish);
            System.out.println("SOLR Search Optimize -- Total time taken:" + (finish - start) + " (ms).");
        }
        catch (IOException | SolrServerException e) {
            System.err.println(e.getMessage());
        }
    }

    @Override
    public void buildSpellCheck() throws SearchServiceException, IOException {
        try {
            if (this.solrSearchCore.getSolr() == null) {
                return;
            }
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.set("spellcheck", true);
            solrQuery.set("spellcheck.build", true);
            this.solrSearchCore.getSolr().query((SolrParams)solrQuery, this.solrSearchCore.REQUEST_METHOD);
        }
        catch (SolrServerException e) {
            log.error((Object)e, (Throwable)e);
            throw new SearchServiceException(e);
        }
    }

    @Override
    public void atomicUpdate(Context context, String uniqueIndexId, String field, Map<String, Object> fieldModifier) throws SolrServerException, IOException {
        SolrInputDocument solrInputDocument = new SolrInputDocument(new String[0]);
        solrInputDocument.addField("search.uniqueid", (Object)uniqueIndexId);
        solrInputDocument.addField(field, fieldModifier);
        this.solrSearchCore.getSolr().add(solrInputDocument);
    }

    protected void emailException(Exception exception) {
        try {
            String recipient = this.configurationService.getProperty("alert.recipient");
            if (StringUtils.isNotBlank((CharSequence)recipient)) {
                String stackTrace;
                Email email = Email.getEmail(I18nUtil.getEmailFilename(Locale.getDefault(), "internal_error"));
                email.addRecipient(recipient);
                email.addArgument(this.configurationService.getProperty("dspace.ui.url"));
                email.addArgument(new Date());
                if (exception != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    exception.printStackTrace(pw);
                    pw.flush();
                    stackTrace = sw.toString();
                } else {
                    stackTrace = "No exception";
                }
                email.addArgument(stackTrace);
                email.send();
            }
        }
        catch (MessagingException | IOException e) {
            log.warn("Unable to send email alert", e);
        }
    }

    protected boolean requiresIndexing(String uniqueId, Date lastModified) throws SQLException, IOException, SearchServiceException {
        QueryResponse rsp;
        if (lastModified == null) {
            return true;
        }
        boolean reindexItem = false;
        boolean inIndex = false;
        SolrQuery query = new SolrQuery();
        query.setQuery("search.uniqueid:" + uniqueId);
        query.setFields(new String[]{"SolrIndexer.lastIndexed"});
        try {
            if (this.solrSearchCore.getSolr() == null) {
                return false;
            }
            rsp = this.solrSearchCore.getSolr().query((SolrParams)query, this.solrSearchCore.REQUEST_METHOD);
        }
        catch (SolrServerException e) {
            throw new SearchServiceException(e.getMessage(), e);
        }
        for (SolrDocument doc : rsp.getResults()) {
            Date lastIndexed;
            inIndex = true;
            Object value = doc.getFieldValue("SolrIndexer.lastIndexed");
            if (!(value instanceof Date) || !(lastIndexed = (Date)value).before(lastModified)) continue;
            reindexItem = true;
        }
        return reindexItem || !inIndex;
    }

    @Override
    public String createLocationQueryForAdministrableItems(Context context) throws SQLException {
        StringBuilder locationQuery = new StringBuilder();
        if (context.getCurrentUser() != null) {
            List<Group> groupList = EPersonServiceFactory.getInstance().getGroupService().allMemberGroups(context, context.getCurrentUser());
            List<ResourcePolicy> communitiesPolicies = AuthorizeServiceFactory.getInstance().getResourcePolicyService().find(context, context.getCurrentUser(), groupList, 11, 4);
            List<ResourcePolicy> collectionsPolicies = AuthorizeServiceFactory.getInstance().getResourcePolicyService().find(context, context.getCurrentUser(), groupList, 11, 3);
            ArrayList<org.dspace.content.Collection> allCollections = new ArrayList<org.dspace.content.Collection>();
            for (ResourcePolicy rp : collectionsPolicies) {
                org.dspace.content.Collection collection = (org.dspace.content.Collection)ContentServiceFactory.getInstance().getCollectionService().find(context, rp.getdSpaceObject().getID());
                allCollections.add(collection);
            }
            if (CollectionUtils.isNotEmpty(communitiesPolicies) || CollectionUtils.isNotEmpty(allCollections)) {
                locationQuery.append("location:( ");
                for (int i = 0; i < communitiesPolicies.size(); ++i) {
                    ResourcePolicy rp;
                    rp = communitiesPolicies.get(i);
                    Community community = (Community)ContentServiceFactory.getInstance().getCommunityService().find(context, rp.getdSpaceObject().getID());
                    locationQuery.append("m").append(community.getID());
                    if (i != communitiesPolicies.size() - 1) {
                        locationQuery.append(" OR ");
                    }
                    allCollections.addAll(ContentServiceFactory.getInstance().getCommunityService().getAllCollections(context, community));
                }
                Iterator collIter = allCollections.iterator();
                if (communitiesPolicies.size() > 0 && allCollections.size() > 0) {
                    locationQuery.append(" OR ");
                }
                while (collIter.hasNext()) {
                    locationQuery.append("l").append(((org.dspace.content.Collection)collIter.next()).getID());
                    if (!collIter.hasNext()) continue;
                    locationQuery.append(" OR ");
                }
                locationQuery.append(")");
            } else {
                log.warn("We have a collection or community admin with ID: " + context.getCurrentUser().getID() + " without any administrable collection or community!");
            }
        }
        return locationQuery.toString();
    }

    public Date toDate(String t) {
        SimpleDateFormat[] dfArr;
        switch (((String)t).length()) {
            case 1: {
                t = "0" + (String)t;
            }
            case 2: {
                t = "0" + (String)t;
            }
            case 3: {
                t = "0" + (String)t;
            }
            case 4: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy")};
                break;
            }
            case 6: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyyMM")};
                break;
            }
            case 7: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM")};
                break;
            }
            case 8: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyyMMdd"), new SimpleDateFormat("yyyy MMM")};
                break;
            }
            case 10: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd")};
                break;
            }
            case 11: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy MMM dd")};
                break;
            }
            case 20: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'")};
                break;
            }
            default: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")};
            }
        }
        for (SimpleDateFormat df : dfArr) {
            try {
                df.setCalendar(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                df.setLenient(false);
                return df.parse((String)t);
            }
            catch (ParseException pe) {
                log.error("Unable to parse date format", (Throwable)pe);
            }
        }
        return null;
    }

    public String locationToName(Context context, String field, String value) throws SQLException {
        if ("location.comm".equals(field) || "location.coll".equals(field)) {
            int type = "location.comm".equals(field) ? 4 : 3;
            DSpaceObject commColl = null;
            if (StringUtils.isNotBlank((CharSequence)value)) {
                commColl = this.contentServiceFactory.getDSpaceObjectService(type).find(context, UUID.fromString(value));
            }
            if (commColl != null) {
                return commColl.getName();
            }
        }
        return value;
    }

    @Override
    public DiscoverResult search(Context context, IndexableObject dso, DiscoverQuery discoveryQuery) throws SearchServiceException {
        if (dso != null) {
            if (dso instanceof IndexableCommunity) {
                discoveryQuery.addFilterQueries("location:m" + dso.getID());
            } else if (dso instanceof IndexableCollection) {
                discoveryQuery.addFilterQueries("location:l" + dso.getID());
            } else if (dso instanceof IndexableItem) {
                discoveryQuery.addFilterQueries("search.uniqueid:" + dso.getUniqueIndexID());
            }
        }
        return this.search(context, discoveryQuery);
    }

    @Override
    public Iterator<Item> iteratorSearch(Context context, IndexableObject dso, DiscoverQuery query) throws SearchServiceException {
        return new SearchIterator(context, dso, query);
    }

    @Override
    public DiscoverResult search(Context context, DiscoverQuery discoveryQuery) throws SearchServiceException {
        try {
            if (this.solrSearchCore.getSolr() == null) {
                return new DiscoverResult();
            }
            return this.retrieveResult(context, discoveryQuery);
        }
        catch (Exception e) {
            throw new SearchServiceException(e.getMessage(), e);
        }
    }

    protected SolrQuery resolveToSolrQuery(Context context, DiscoverQuery discoveryQuery) throws SearchServiceException {
        int i;
        SolrQuery solrQuery = new SolrQuery();
        String query = "*:*";
        if (discoveryQuery.getQuery() != null) {
            query = discoveryQuery.getQuery();
        }
        solrQuery.setQuery(query);
        if (discoveryQuery.getMaxResults() != 0) {
            for (String string : discoveryQuery.getSearchFields()) {
                solrQuery.addField(string);
            }
            solrQuery.addField("search.resourcetype");
            solrQuery.addField("search.resourceid");
            solrQuery.addField("search.uniqueid");
            solrQuery.addField("database_status");
        }
        if (discoveryQuery.isSpellCheck()) {
            solrQuery.setParam("spellcheck.q", new String[]{query});
            solrQuery.setParam("spellcheck.collate", Boolean.TRUE.booleanValue());
            solrQuery.setParam("spellcheck", Boolean.TRUE.booleanValue());
        }
        for (i = 0; i < discoveryQuery.getFilterQueries().size(); ++i) {
            String string = discoveryQuery.getFilterQueries().get(i);
            solrQuery.addFilterQuery(new String[]{string});
        }
        if (discoveryQuery.getDSpaceObjectFilters() != null) {
            solrQuery.addFilterQuery(new String[]{discoveryQuery.getDSpaceObjectFilters().stream().map(filter -> "search.resourcetype:" + filter).collect(Collectors.joining(" OR "))});
        }
        for (i = 0; i < discoveryQuery.getFieldPresentQueries().size(); ++i) {
            String string = discoveryQuery.getFieldPresentQueries().get(i);
            solrQuery.addFilterQuery(new String[]{string + ":[* TO *]"});
        }
        if (discoveryQuery.getStart() != -1) {
            solrQuery.setStart(Integer.valueOf(discoveryQuery.getStart()));
        }
        if (discoveryQuery.getMaxResults() != -1) {
            solrQuery.setRows(Integer.valueOf(discoveryQuery.getMaxResults()));
        }
        if (discoveryQuery.getSortField() != null) {
            SolrQuery.ORDER order = SolrQuery.ORDER.asc;
            if (discoveryQuery.getSortOrder().equals((Object)DiscoverQuery.SORT_ORDER.desc)) {
                order = SolrQuery.ORDER.desc;
            }
            solrQuery.addSort(discoveryQuery.getSortField(), order);
        }
        for (String string : discoveryQuery.getProperties().keySet()) {
            List<String> list = discoveryQuery.getProperties().get(string);
            solrQuery.add(string, list.toArray(new String[list.size()]));
        }
        List<DiscoverFacetField> facetFields = discoveryQuery.getFacetFields();
        if (0 < facetFields.size()) {
            for (DiscoverFacetField discoverFacetField : facetFields) {
                String field2 = this.transformFacetField(discoverFacetField, discoverFacetField.getField(), false);
                if (discoverFacetField.getPrefix() != null) {
                    field2 = this.transformPrefixFacetField(discoverFacetField, discoverFacetField.getField(), false);
                }
                solrQuery.addFacetField(new String[]{field2});
                solrQuery.add("f." + field2 + ".facet.limit", new String[]{String.valueOf(discoverFacetField.getLimit())});
                String facetSort = DiscoveryConfigurationParameters.SORT.COUNT.equals((Object)discoverFacetField.getSortOrder()) ? "count" : "index";
                solrQuery.add("f." + field2 + ".facet.sort", new String[]{facetSort});
                if (discoverFacetField.getOffset() != -1) {
                    solrQuery.setParam("f." + field2 + ".facet.offset", new String[]{String.valueOf(discoverFacetField.getOffset())});
                }
                if (discoverFacetField.getPrefix() == null) continue;
                solrQuery.setFacetPrefix(field2, discoverFacetField.getPrefix());
            }
        }
        List<String> list = discoveryQuery.getFacetQueries();
        for (String facetQuery : list) {
            solrQuery.addFacetQuery(facetQuery);
        }
        if (discoveryQuery.getFacetMinCount() != -1) {
            solrQuery.setFacetMinCount(discoveryQuery.getFacetMinCount());
        }
        if (CollectionUtils.isNotEmpty(facetFields) || CollectionUtils.isNotEmpty(list)) {
            solrQuery.setParam("facet.offset", new String[]{String.valueOf(discoveryQuery.getFacetOffset())});
        }
        if (0 < discoveryQuery.getHitHighlightingFields().size()) {
            solrQuery.setHighlight(true);
            solrQuery.add("hl.usePhraseHighlighter", new String[]{Boolean.TRUE.toString()});
            boolean bl = this.configurationService.getBooleanProperty("discovery.highlights.escape-html", true);
            String[] renderHTMLForFields = this.configurationService.getArrayProperty("discovery.highlights.html-allowed-fields");
            for (DiscoverHitHighlightingField highlightingField : discoveryQuery.getHitHighlightingFields()) {
                solrQuery.addHighlightField(highlightingField.getField() + "_hl");
                boolean allowHTMLInField = Arrays.stream(renderHTMLForFields).anyMatch(field -> highlightingField.getField().matches((String)field));
                if (!bl || allowHTMLInField) {
                    solrQuery.add("f." + highlightingField.getField() + "_hl.hl.method", new String[]{"original"});
                } else {
                    solrQuery.add("f." + highlightingField.getField() + "_hl.hl.method", new String[]{"unified"});
                    solrQuery.add("f." + highlightingField.getField() + "_hl.hl.encoder", new String[]{"html"});
                }
                solrQuery.add("f." + highlightingField.getField() + "_hl.hl.fragsize", new String[]{String.valueOf(highlightingField.getMaxChars())});
                solrQuery.add("f." + highlightingField.getField() + "_hl.hl.snippets", new String[]{String.valueOf(highlightingField.getMaxSnippets())});
            }
        }
        List list2 = DSpaceServicesFactory.getInstance().getServiceManager().getServicesByType(SolrServiceSearchPlugin.class);
        for (SolrServiceSearchPlugin searchPlugin : list2) {
            searchPlugin.additionalSearchParameters(context, discoveryQuery, solrQuery);
        }
        return solrQuery;
    }

    protected DiscoverResult retrieveResult(Context context, DiscoverQuery query) throws SQLException, SolrServerException, IOException, SearchServiceException {
        boolean valid = false;
        int executionCount = 0;
        DiscoverResult result = null;
        SolrQuery solrQuery = this.resolveToSolrQuery(context, query);
        int maxAttempts = this.configurationService.getIntProperty("discovery.removestale.attempts", 3);
        do {
            ++executionCount;
            result = new DiscoverResult();
            boolean skipLoadingResponse = false;
            ArrayList<String> zombieDocs = new ArrayList<String>();
            QueryResponse solrQueryResponse = this.solrSearchCore.getSolr().query((SolrParams)solrQuery, this.solrSearchCore.REQUEST_METHOD);
            if (solrQueryResponse != null) {
                result.setSearchTime(solrQueryResponse.getQTime());
                result.setStart(query.getStart());
                result.setMaxResults(query.getMaxResults());
                result.setTotalSearchResults(solrQueryResponse.getResults().getNumFound());
                List<String> searchFields = query.getSearchFields();
                for (SolrDocument doc : solrQueryResponse.getResults()) {
                    Map highlightedFields;
                    IndexableObject indexableObject = this.findIndexableObject(context, doc);
                    if (indexableObject == null) {
                        Object statusObj;
                        log.warn(LogHelper.getHeader(context, "Stale entry found in Discovery index, as we could not find the DSpace object it refers to. ", "Unique identifier: " + doc.getFirstValue("search.uniqueid")));
                        if (maxAttempts < 0 || (statusObj = doc.getFirstValue("database_status")) instanceof String && statusObj.equals("predb")) continue;
                        zombieDocs.add((String)doc.getFirstValue("search.uniqueid"));
                        skipLoadingResponse = maxAttempts + 1 != executionCount;
                        continue;
                    }
                    result.addIndexableObject(indexableObject);
                    if (skipLoadingResponse) continue;
                    DiscoverResult.SearchDocument resultDoc = new DiscoverResult.SearchDocument();
                    for (String field : searchFields) {
                        ArrayList valuesAsString = new ArrayList();
                        Optional.ofNullable(doc.getFieldValues(field)).ifPresent(l -> l.forEach(o -> valuesAsString.add(String.valueOf(o))));
                        resultDoc.addSearchField(field, valuesAsString.toArray(new String[valuesAsString.size()]));
                    }
                    result.addSearchDocument(indexableObject, resultDoc);
                    if (solrQueryResponse.getHighlighting() == null || !MapUtils.isNotEmpty((Map)(highlightedFields = (Map)solrQueryResponse.getHighlighting().get(indexableObject.getUniqueIndexID())))) continue;
                    HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
                    for (String key : highlightedFields.keySet()) {
                        resultMap.put(key.substring(0, key.lastIndexOf("_hl")), (List)highlightedFields.get(key));
                    }
                    result.addHighlightedResult(indexableObject, new DiscoverResult.IndexableObjectHighlightResult(indexableObject, resultMap));
                }
                this.resolveFacetFields(context, query, result, skipLoadingResponse, solrQueryResponse);
                this.resolveJsonFacetFields(context, result, solrQueryResponse);
            }
            if (!zombieDocs.isEmpty()) {
                log.info("Cleaning " + zombieDocs.size() + " stale objects from Discovery Index");
                log.info("ZombieDocs ");
                zombieDocs.forEach(arg_0 -> ((Logger)log).info(arg_0));
                this.solrSearchCore.getSolr().deleteById(zombieDocs);
                this.solrSearchCore.getSolr().commit();
                continue;
            }
            valid = true;
        } while (!valid && executionCount <= maxAttempts);
        if (!valid && executionCount == maxAttempts) {
            String message = "The Discovery (Solr) index has a large number of stale entries, and we could not complete this request. Please reindex all content to remove these stale entries (e.g. dspace index-discovery -f).";
            log.fatal(message);
            throw new RuntimeException(message);
        }
        return result;
    }

    private void resolveJsonFacetFields(Context context, DiscoverResult result, QueryResponse solrQueryResponse) throws SQLException {
        NestableJsonFacet response = solrQueryResponse.getJsonFacetingResponse();
        if (response != null && response.getBucketBasedFacetNames() != null) {
            for (String facetName : response.getBucketBasedFacetNames()) {
                BucketBasedJsonFacet facet = response.getBucketBasedFacets(facetName);
                if (facet == null) continue;
                result.setTotalEntries(facet.getNumBucketsCount());
                for (BucketJsonFacet bucket : facet.getBuckets()) {
                    String facetValue = bucket.getVal() != null ? bucket.getVal().toString() : "";
                    String field = facetName + "_filter";
                    String displayedValue = this.transformDisplayedValue(context, field, facetValue);
                    String authorityValue = this.transformAuthorityValue(context, field, facetValue);
                    String sortValue = this.transformSortValue(context, field, facetValue);
                    String filterValue = displayedValue;
                    if (StringUtils.isNotBlank((CharSequence)authorityValue)) {
                        filterValue = authorityValue;
                    }
                    result.addFacetResult(facetName, new DiscoverResult.FacetResult(filterValue, displayedValue, authorityValue, sortValue, bucket.getCount(), "text"));
                }
            }
        }
    }

    private void resolveFacetFields(Context context, DiscoverQuery query, DiscoverResult result, boolean skipLoadingResponse, QueryResponse solrQueryResponse) throws SQLException {
        List facetFields = solrQueryResponse.getFacetFields();
        if (!skipLoadingResponse) {
            String recommendedQuery;
            if (facetFields != null) {
                for (int i = 0; i < facetFields.size(); ++i) {
                    FacetField facetField = (FacetField)facetFields.get(i);
                    DiscoverFacetField facetFieldConfig = query.getFacetFields().get(i);
                    List facetValues = facetField.getValues();
                    if (facetValues == null) continue;
                    if (facetFieldConfig.getType().equals("date") && facetFieldConfig.getSortOrder().equals((Object)DiscoveryConfigurationParameters.SORT.VALUE)) {
                        Collections.reverse(facetValues);
                    }
                    for (FacetField.Count facetValue : facetValues) {
                        String displayedValue = this.transformDisplayedValue(context, facetField.getName(), facetValue.getName());
                        String field = this.transformFacetField(facetFieldConfig, facetField.getName(), true);
                        String authorityValue = this.transformAuthorityValue(context, facetField.getName(), facetValue.getName());
                        String sortValue = this.transformSortValue(context, facetField.getName(), facetValue.getName());
                        String filterValue = displayedValue;
                        if (StringUtils.isNotBlank((CharSequence)authorityValue)) {
                            filterValue = authorityValue;
                        }
                        result.addFacetResult(field, new DiscoverResult.FacetResult(filterValue, displayedValue, authorityValue, sortValue, facetValue.getCount(), facetFieldConfig.getType()));
                    }
                }
            }
            if (solrQueryResponse.getFacetQuery() != null && !skipLoadingResponse) {
                LinkedHashMap sortedFacetQueries = new LinkedHashMap(solrQueryResponse.getFacetQuery());
                for (String facetQuery : sortedFacetQueries.keySet()) {
                    Integer count;
                    String facetField = facetQuery.substring(0, facetQuery.indexOf(":"));
                    String name = "";
                    String filter = "";
                    if (facetQuery.indexOf(91) > -1 && facetQuery.lastIndexOf(93) > -1) {
                        name = facetQuery.substring(facetQuery.indexOf(91) + 1);
                        name = name.substring(0, name.lastIndexOf(93)).replaceAll("TO", "-");
                        filter = facetQuery.substring(facetQuery.indexOf(91));
                        filter = filter.substring(0, filter.lastIndexOf(93) + 1);
                    }
                    if (0 >= (count = (Integer)sortedFacetQueries.get(facetQuery))) continue;
                    result.addFacetResult(facetField, new DiscoverResult.FacetResult(filter, name, null, name, count.intValue(), "date"));
                }
            }
            if (solrQueryResponse.getSpellCheckResponse() != null && !skipLoadingResponse && StringUtils.isNotBlank((CharSequence)(recommendedQuery = solrQueryResponse.getSpellCheckResponse().getCollatedResult()))) {
                result.setSpellCheckQuery(recommendedQuery);
            }
        }
    }

    protected IndexableObject findIndexableObject(Context context, SolrDocument doc) throws SQLException {
        String type = (String)doc.getFirstValue("search.resourcetype");
        String id = (String)doc.getFirstValue("search.resourceid");
        IndexFactory indexableObjectService = this.indexObjectServiceFactory.getIndexFactoryByType(type);
        Optional indexableObject = indexableObjectService.findIndexableObject(context, id);
        if (!indexableObject.isPresent()) {
            log.warn("Not able to retrieve object RESOURCE_ID:" + id + " - RESOURCE_TYPE_ID:" + type);
        }
        return indexableObject.orElse(null);
    }

    public List<IndexableObject> search(Context context, String query, int offset, int max, String ... filterquery) {
        return this.search(context, query, null, true, offset, max, filterquery);
    }

    @Override
    public List<IndexableObject> search(Context context, String query, String orderfield, boolean ascending, int offset, int max, String ... filterquery) {
        try {
            if (this.solrSearchCore.getSolr() == null) {
                return Collections.emptyList();
            }
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setQuery(query);
            solrQuery.setFields(new String[]{"search.resourceid", "search.resourcetype"});
            solrQuery.setStart(Integer.valueOf(offset));
            solrQuery.setRows(Integer.valueOf(max));
            if (orderfield != null) {
                solrQuery.addSort(orderfield, ascending ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
            }
            if (filterquery != null) {
                solrQuery.addFilterQuery(filterquery);
            }
            QueryResponse rsp = this.solrSearchCore.getSolr().query((SolrParams)solrQuery, this.solrSearchCore.REQUEST_METHOD);
            SolrDocumentList docs = rsp.getResults();
            Iterator iter = docs.iterator();
            ArrayList<IndexableObject> result = new ArrayList<IndexableObject>();
            while (iter.hasNext()) {
                SolrDocument doc = (SolrDocument)iter.next();
                IndexableObject o = this.findIndexableObject(context, doc);
                if (o == null) continue;
                result.add(o);
            }
            return result;
        }
        catch (IOException | SQLException | SolrServerException e) {
            log.error(LogHelper.getHeader(context, "Error while quering solr", "Query: " + query), e);
            return new ArrayList<IndexableObject>(0);
        }
    }

    @Override
    public DiscoverFilterQuery toFilterQuery(Context context, String field, String operator, String value, DiscoveryConfiguration config) throws SQLException {
        DiscoverFilterQuery result = new DiscoverFilterQuery();
        StringBuilder filterQuery = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)field) && StringUtils.isNotBlank((CharSequence)value)) {
            filterQuery.append(field);
            if (operator.endsWith("equals")) {
                boolean isStandardField = Optional.ofNullable(config).flatMap(c -> Optional.ofNullable(c.getSidebarFacet(field))).map(facet -> facet.getType().equals("standard")).orElse(false);
                if (!isStandardField) {
                    filterQuery.append("_keyword");
                }
            } else if (operator.endsWith("authority")) {
                filterQuery.append("_authority");
            }
            if (operator.startsWith("not")) {
                filterQuery.insert(0, "-");
            }
            filterQuery.append(":");
            if ("equals".equals(operator) || "notequals".equals(operator)) {
                if (!((String)value).matches("\\[.*TO.*\\]")) {
                    value = ClientUtils.escapeQueryChars((String)value);
                    filterQuery.append((String)value);
                } else {
                    if (((String)value).matches("\\[\\d{1,4} TO \\d{1,4}\\]")) {
                        int minRange = Integer.parseInt(((String)value).substring(1, ((String)value).length() - 1).split(" TO ")[0]);
                        int maxRange = Integer.parseInt(((String)value).substring(1, ((String)value).length() - 1).split(" TO ")[1]);
                        value = "[" + String.format("%04d", minRange) + " TO " + String.format("%04d", maxRange) + "]";
                    }
                    filterQuery.append((String)value);
                }
            } else if (!((String)value).matches("\\[.*TO.*\\]")) {
                value = ClientUtils.escapeQueryChars((String)value);
                filterQuery.append("\"").append((String)value).append("\"");
            } else {
                filterQuery.append((String)value);
            }
            result.setDisplayedValue(this.transformDisplayedValue(context, field, (String)value));
        }
        result.setFilterQuery(filterQuery.toString());
        return result;
    }

    @Override
    public List<Item> getRelatedItems(Context context, Item item, DiscoveryMoreLikeThisConfiguration mltConfig) {
        ArrayList<Item> results = new ArrayList<Item>();
        try {
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setQuery("search.uniqueid: " + new IndexableItem(item).getUniqueIndexID());
            solrQuery.setFields(new String[]{"search.resourcetype", "search.resourceid"});
            solrQuery.setParam("mlt", true);
            Collection similarityMetadataFields = CollectionUtils.collect(mltConfig.getSimilarityMetadataFields(), (Transformer)new Transformer(){

                public Object transform(Object input) {
                    return input + "_mlt";
                }
            });
            solrQuery.setParam("mlt.fl", new String[]{StringUtils.join((Iterable)similarityMetadataFields, (char)',')});
            solrQuery.setParam("mlt.mintf", new String[]{String.valueOf(mltConfig.getMinTermFrequency())});
            solrQuery.setParam("mlt.count", new String[]{String.valueOf(mltConfig.getMax())});
            solrQuery.setParam("mlt.minwl", new String[]{String.valueOf(mltConfig.getMinWordLength())});
            if (this.solrSearchCore.getSolr() == null) {
                return Collections.emptyList();
            }
            QueryResponse rsp = this.solrSearchCore.getSolr().query((SolrParams)solrQuery, this.solrSearchCore.REQUEST_METHOD);
            NamedList mltResults = (NamedList)rsp.getResponse().get("moreLikeThis");
            if (mltResults != null && mltResults.get(item.getType() + "-" + item.getID()) != null) {
                SolrDocumentList relatedDocs = (SolrDocumentList)mltResults.get(item.getType() + "-" + item.getID());
                for (Object relatedDoc : relatedDocs) {
                    SolrDocument relatedDocument = (SolrDocument)relatedDoc;
                    IndexableObject relatedItem = this.findIndexableObject(context, relatedDocument);
                    if (!(relatedItem instanceof IndexableItem)) continue;
                    results.add((Item)((IndexableItem)relatedItem).getIndexedObject());
                }
            }
        }
        catch (IOException | SQLException | SolrServerException e) {
            log.error(LogHelper.getHeader(context, "Error while retrieving related items", "Handle: " + item.getHandle()), e);
        }
        return results;
    }

    @Override
    public String toSortFieldIndex(String metadataField, String type) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"score", (CharSequence)metadataField)) {
            return "score";
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"date")) {
            return metadataField + "_dt";
        }
        return metadataField + "_sort";
    }

    protected String transformPrefixFacetField(DiscoverFacetField facetFieldConfig, String field, boolean removePostfix) {
        if (facetFieldConfig.getType().equals("text") || facetFieldConfig.getType().equals("hierarchical")) {
            if (removePostfix) {
                return field.substring(0, field.lastIndexOf(SOLR_FIELD_SUFFIX_FACET_PREFIXES));
            }
            return field + SOLR_FIELD_SUFFIX_FACET_PREFIXES;
        }
        return this.transformFacetField(facetFieldConfig, field, removePostfix);
    }

    protected String transformFacetField(DiscoverFacetField facetFieldConfig, String field, boolean removePostfix) {
        if (field.contains(SOLR_FIELD_SUFFIX_FACET_PREFIXES)) {
            return this.transformPrefixFacetField(facetFieldConfig, field, removePostfix);
        }
        if (facetFieldConfig.getType().equals("text")) {
            if (removePostfix) {
                return field.substring(0, field.lastIndexOf("_filter"));
            }
            return field + "_filter";
        }
        if (facetFieldConfig.getType().equals("date")) {
            if (removePostfix) {
                return field.substring(0, field.lastIndexOf(".year"));
            }
            return field + ".year";
        }
        if (facetFieldConfig.getType().equals("ac")) {
            if (removePostfix) {
                return field.substring(0, field.lastIndexOf("_ac"));
            }
            return field + "_ac";
        }
        if (facetFieldConfig.getType().equals("hierarchical")) {
            if (removePostfix) {
                return StringUtils.substringBeforeLast((String)field, (String)"_tax_");
            }
            return field + "_tax_0_filter";
        }
        if (facetFieldConfig.getType().equals("authority")) {
            if (removePostfix) {
                return field.substring(0, field.lastIndexOf("_acid"));
            }
            return field + "_acid";
        }
        return field;
    }

    protected String transformDisplayedValue(Context context, String field, String value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (field.equals("location.comm") || field.equals("location.coll")) {
            value = this.locationToName(context, field, value);
        } else if (field.endsWith("_filter") || field.endsWith("_ac") || field.endsWith("_acid") || field.endsWith(SOLR_FIELD_SUFFIX_FACET_PREFIXES)) {
            int start;
            String separator = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.solr.facets.split.char");
            if (separator == null) {
                separator = "\n|||\n";
            }
            separator = Pattern.quote(separator);
            String[] fqParts = value.split(separator);
            StringBuilder valueBuffer = new StringBuilder();
            for (int i = start = fqParts.length / 2; i < fqParts.length; ++i) {
                String[] split = fqParts[i].split("###", 2);
                valueBuffer.append(split[0]);
            }
            value = valueBuffer.toString();
        } else if (value.matches("\\((.*?)\\)")) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    protected String transformAuthorityValue(Context context, String field, String value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (field.equals("location.comm") || field.equals("location.coll")) {
            return value;
        }
        if (field.endsWith("_filter") || field.endsWith("_ac") || field.endsWith("_acid") || field.endsWith(SOLR_FIELD_SUFFIX_FACET_PREFIXES)) {
            int start;
            String separator = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.solr.facets.split.char");
            if (separator == null) {
                separator = "\n|||\n";
            }
            separator = Pattern.quote(separator);
            String[] fqParts = value.split(separator);
            StringBuilder authorityBuffer = new StringBuilder();
            for (int i = start = fqParts.length / 2; i < fqParts.length; ++i) {
                String[] split = fqParts[i].split("###", 2);
                if (split.length != 2) continue;
                authorityBuffer.append(split[1]);
            }
            if (authorityBuffer.length() > 0) {
                return authorityBuffer.toString();
            }
        }
        return null;
    }

    protected String transformSortValue(Context context, String field, String value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (field.equals("location.comm") || field.equals("location.coll")) {
            value = this.locationToName(context, field, value);
        } else if (field.endsWith("_filter") || field.endsWith("_ac") || field.endsWith("_acid")) {
            String separator = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.solr.facets.split.char");
            if (separator == null) {
                separator = "\n|||\n";
            }
            separator = Pattern.quote(separator);
            String[] fqParts = value.split(separator);
            StringBuilder valueBuffer = new StringBuilder();
            int end = fqParts.length / 2;
            for (int i = 0; i < end; ++i) {
                valueBuffer.append(fqParts[i]);
            }
            value = valueBuffer.toString();
        } else if (value.matches("\\((.*?)\\)")) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    @Override
    public void indexContent(Context context, IndexableObject dso, boolean force, boolean commit) throws SearchServiceException, SQLException {
        this.indexContent(context, dso, force);
        if (commit) {
            this.commit();
        }
    }

    @Override
    public void indexContent(Context context, IndexableObject indexableObject, boolean force, boolean commit, boolean preDb) throws SearchServiceException, SQLException {
        if (preDb) {
            try {
                IndexFactory indexableObjectFactory = this.indexObjectServiceFactory.getIndexableObjectFactory(indexableObject);
                if (force || this.requiresIndexing(indexableObject.getUniqueIndexID(), indexableObject.getLastModified())) {
                    this.update(context, indexableObjectFactory, indexableObject, true);
                    log.info(LogHelper.getHeader(context, "indexed_object", indexableObject.getUniqueIndexID()));
                }
            }
            catch (IOException | SQLException | SolrServerException | SearchServiceException e) {
                log.error(e.getMessage(), e);
            }
        } else {
            this.indexContent(context, indexableObject, force);
        }
        if (commit) {
            this.commit();
        }
    }

    @Override
    public void commit() throws SearchServiceException {
        try {
            if (this.solrSearchCore.getSolr() != null) {
                this.solrSearchCore.getSolr().commit();
            }
        }
        catch (IOException | SolrServerException e) {
            throw new SearchServiceException(e.getMessage(), e);
        }
    }

    @Override
    public String escapeQueryChars(String query) {
        return ClientUtils.escapeQueryChars((String)query);
    }

    @Override
    public FacetYearRange getFacetYearRange(Context context, IndexableObject scope, DiscoverySearchFilterFacet facet, List<String> filterQueries, DiscoverQuery parentQuery) throws SearchServiceException {
        FacetYearRange result = new FacetYearRange(facet);
        result.calculateRange(context, filterQueries, scope, this, parentQuery);
        return result;
    }

    @Override
    public String calculateExtremeValue(Context context, String valueField, String sortField, DiscoverQuery.SORT_ORDER sortOrder) throws SearchServiceException {
        List<DiscoverResult.SearchDocument> searchDocuments;
        DiscoverQuery maxQuery = new DiscoverQuery();
        maxQuery.setMaxResults(1);
        maxQuery.addFieldPresentQueries(valueField);
        maxQuery.setSortField(sortField, sortOrder);
        maxQuery.addSearchField(valueField);
        DiscoverResult maxResult = this.search(context, maxQuery);
        if (0 < maxResult.getIndexableObjects().size() && 0 < (searchDocuments = maxResult.getSearchDocument(maxResult.getIndexableObjects().get(0))).size() && 0 < searchDocuments.get(0).getSearchFieldValues(valueField).size()) {
            return searchDocuments.get(0).getSearchFieldValues(valueField).get(0);
        }
        return null;
    }

    private class SearchIterator
    implements Iterator<Item> {
        private Context context;
        private DiscoverQuery discoverQuery;
        private DiscoverResult discoverResult;
        private IndexableObject dso;
        private int absoluteCursor;
        private int relativeCursor;
        private int pagesize;

        SearchIterator(Context context, DiscoverQuery discoverQuery) throws SearchServiceException {
            this.context = context;
            this.discoverQuery = discoverQuery;
            this.absoluteCursor = discoverQuery.getStart();
            this.initialise();
        }

        SearchIterator(Context context, IndexableObject dso, DiscoverQuery discoverQuery) throws SearchServiceException {
            this.context = context;
            this.dso = dso;
            this.discoverQuery = discoverQuery;
            this.initialise();
        }

        private void initialise() throws SearchServiceException {
            this.relativeCursor = 0;
            this.pagesize = this.discoverQuery.getMaxResults() != -1 ? this.discoverQuery.getMaxResults() : 10;
            this.discoverQuery.setMaxResults(this.pagesize);
            this.discoverResult = SolrServiceImpl.this.search(this.context, this.dso, this.discoverQuery);
        }

        @Override
        public boolean hasNext() {
            return (long)this.absoluteCursor < this.discoverResult.getTotalSearchResults();
        }

        @Override
        public Item next() {
            if (this.relativeCursor == this.pagesize) {
                int offset = this.absoluteCursor;
                this.relativeCursor = 0;
                this.discoverQuery.setStart(offset);
                try {
                    this.discoverResult = SolrServiceImpl.this.search(this.context, this.dso, this.discoverQuery);
                }
                catch (SearchServiceException e) {
                    log.error("error while getting search results", (Throwable)e);
                }
            }
            IndexableObject res = this.discoverResult.getIndexableObjects().get(this.relativeCursor);
            ++this.relativeCursor;
            ++this.absoluteCursor;
            return (Item)res.getIndexedObject();
        }
    }
}

