/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.requestitem.RequestItem;
import org.dspace.app.requestitem.service.RequestItemService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.DSpaceObjectServiceImpl;
import org.dspace.content.Item;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.dao.BitstreamDAO;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.event.Event;
import org.dspace.storage.bitstore.service.BitstreamStorageService;
import org.springframework.beans.factory.annotation.Autowired;

public class BitstreamServiceImpl
extends DSpaceObjectServiceImpl<Bitstream>
implements BitstreamService {
    private static final Logger log = LogManager.getLogger();
    @Autowired(required=true)
    protected BitstreamDAO bitstreamDAO;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected BitstreamFormatService bitstreamFormatService;
    @Autowired(required=true)
    protected BundleService bundleService;
    @Autowired(required=true)
    protected BitstreamStorageService bitstreamStorageService;
    @Autowired(required=true)
    protected RequestItemService requestItemService;

    protected BitstreamServiceImpl() {
    }

    @Override
    public Bitstream find(Context context, UUID id) throws SQLException {
        Bitstream bitstream = (Bitstream)this.bitstreamDAO.findByID(context, Bitstream.class, id);
        if (bitstream == null) {
            if (log.isDebugEnabled()) {
                log.debug(LogHelper.getHeader(context, "find_bitstream", "not_found,bitstream_id=" + id));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug(LogHelper.getHeader(context, "find_bitstream", "bitstream_id=" + id));
        }
        return bitstream;
    }

    @Override
    public List<Bitstream> findAll(Context context) throws SQLException {
        return this.bitstreamDAO.findAll(context, Bitstream.class);
    }

    @Override
    public Bitstream clone(Context context, Bitstream bitstream) throws SQLException, AuthorizeException {
        Bitstream clonedBitstream = this.bitstreamDAO.create(context, new Bitstream());
        clonedBitstream.setInternalId(bitstream.getInternalId());
        clonedBitstream.setSizeBytes(bitstream.getSizeBytes());
        clonedBitstream.setChecksum(bitstream.getChecksum());
        clonedBitstream.setChecksumAlgorithm(bitstream.getChecksumAlgorithm());
        clonedBitstream.setFormat(bitstream.getBitstreamFormat());
        this.update(context, clonedBitstream);
        return clonedBitstream;
    }

    @Override
    public Iterator<Bitstream> findAll(Context context, int limit, int offset) throws SQLException {
        return this.bitstreamDAO.findAll(context, limit, offset);
    }

    @Override
    public Bitstream create(Context context, InputStream is) throws IOException, SQLException {
        UUID bitstreamID = this.bitstreamStorageService.store(context, this.bitstreamDAO.create(context, new Bitstream()), is);
        log.info(LogHelper.getHeader(context, "create_bitstream", "bitstream_id=" + bitstreamID));
        Bitstream bitstream = this.find(context, bitstreamID);
        this.setFormat(context, bitstream, null);
        context.addEvent(new Event(1, 0, bitstreamID, null, this.getIdentifiers(context, bitstream)));
        return bitstream;
    }

    @Override
    public Bitstream create(Context context, Bundle bundle, InputStream is) throws IOException, SQLException, AuthorizeException {
        this.authorizeService.authorizeAction(context, bundle, 3);
        Bitstream b = this.create(context, is);
        this.bundleService.addBitstream(context, bundle, b);
        return b;
    }

    @Override
    public Bitstream register(Context context, Bundle bundle, int assetstore, String bitstreamPath) throws IOException, SQLException, AuthorizeException {
        this.authorizeService.authorizeAction(context, bundle, 3);
        Bitstream bitstream = this.register(context, assetstore, bitstreamPath);
        this.bundleService.addBitstream(context, bundle, bitstream);
        return bitstream;
    }

    @Override
    public Bitstream register(Context context, int assetstore, String bitstreamPath) throws IOException, SQLException, AuthorizeException {
        Bitstream bitstream = this.bitstreamDAO.create(context, new Bitstream());
        this.bitstreamStorageService.register(context, bitstream, assetstore, bitstreamPath);
        log.info(LogHelper.getHeader(context, "create_bitstream", "bitstream_id=" + bitstream.getID()));
        this.setFormat(context, bitstream, null);
        context.addEvent(new Event(1, 0, bitstream.getID(), "REGISTER", this.getIdentifiers(context, bitstream)));
        return bitstream;
    }

    @Override
    public void setUserFormatDescription(Context context, Bitstream bitstream, String desc) throws SQLException {
        this.setFormat(context, bitstream, null);
        this.setMetadataSingleValue(context, bitstream, MetadataSchemaEnum.DC.getName(), "format", null, null, desc);
    }

    @Override
    public String getFormatDescription(Context context, Bitstream bitstream) throws SQLException {
        if (bitstream.getFormat(context).getShortDescription().equals("Unknown")) {
            String desc = bitstream.getUserFormatDescription();
            if (desc == null) {
                return "Unknown";
            }
            return desc;
        }
        return bitstream.getFormat(context).getShortDescription();
    }

    @Override
    public void setFormat(Context context, Bitstream bitstream, BitstreamFormat bitstreamFormat) throws SQLException {
        if (bitstreamFormat == null) {
            bitstreamFormat = this.bitstreamFormatService.findUnknown(context);
        }
        this.clearMetadata(context, bitstream, MetadataSchemaEnum.DC.getName(), "format", null, "*");
        bitstream.setFormat(bitstreamFormat);
    }

    @Override
    public void update(Context context, Bitstream bitstream) throws SQLException, AuthorizeException {
        this.authorizeService.authorizeAction(context, bitstream, 1);
        log.info(LogHelper.getHeader(context, "update_bitstream", "bitstream_id=" + bitstream.getID()));
        super.update(context, bitstream);
        if (bitstream.isModified()) {
            context.addEvent(new Event(2, 0, bitstream.getID(), null, this.getIdentifiers(context, bitstream)));
            bitstream.setModified();
        }
        if (bitstream.isMetadataModified()) {
            context.addEvent(new Event(4, 0, bitstream.getID(), bitstream.getDetails(), this.getIdentifiers(context, bitstream)));
            bitstream.clearModified();
            bitstream.clearDetails();
        }
        this.bitstreamDAO.save(context, bitstream);
    }

    @Override
    public void delete(Context context, Bitstream bitstream) throws SQLException, AuthorizeException {
        this.authorizeService.authorizeAction(context, bitstream, 2);
        log.info(LogHelper.getHeader(context, "delete_bitstream", "bitstream_id=" + bitstream.getID()));
        context.addEvent(new Event(32, 0, bitstream.getID(), String.valueOf(bitstream.getSequenceID()), this.getIdentifiers(context, bitstream)));
        bitstream.setDeleted(true);
        this.update(context, bitstream);
        List<Bundle> bundles = bitstream.getBundles();
        for (Bundle bundle : bundles) {
            this.authorizeService.authorizeAction(context, bundle, 4);
            if (bitstream.equals(bundle.getPrimaryBitstream())) {
                bundle.unsetPrimaryBitstreamID();
            }
            bundle.removeBitstream(bitstream);
        }
        bundles.clear();
        List<RequestItem> requestItems = this.requestItemService.findAll(context);
        for (RequestItem requestItem : requestItems) {
            if (!bitstream.equals(requestItem.getBitstream())) continue;
            this.requestItemService.delete(context, requestItem);
        }
        this.authorizeService.removeAllPolicies(context, bitstream);
    }

    @Override
    public int getSupportsTypeConstant() {
        return 0;
    }

    @Override
    public InputStream retrieve(Context context, Bitstream bitstream) throws IOException, SQLException, AuthorizeException {
        this.authorizeService.authorizeAction(context, bitstream, 0);
        return this.bitstreamStorageService.retrieve(context, bitstream);
    }

    @Override
    public boolean isRegisteredBitstream(Bitstream bitstream) {
        return this.bitstreamStorageService.isRegisteredBitstream(bitstream.getInternalId());
    }

    @Override
    public DSpaceObject getParentObject(Context context, Bitstream bitstream) throws SQLException {
        List<Bundle> bundles = bitstream.getBundles();
        if (CollectionUtils.isNotEmpty(bundles)) {
            Item item = (Item)this.bundleService.getParentObject(context, bundles.iterator().next());
            if (item != null) {
                return item;
            }
            return null;
        }
        if (bitstream.getCommunity() != null) {
            return bitstream.getCommunity();
        }
        if (bitstream.getCollection() != null) {
            return bitstream.getCollection();
        }
        return null;
    }

    @Override
    public void updateLastModified(Context context, Bitstream bitstream) {
        context.addEvent(new Event(2, 0, bitstream.getID(), null, this.getIdentifiers(context, bitstream)));
    }

    @Override
    public List<Bitstream> findDeletedBitstreams(Context context, int limit, int offset) throws SQLException {
        return this.bitstreamDAO.findDeletedBitstreams(context, limit, offset);
    }

    @Override
    public void expunge(Context context, Bitstream bitstream) throws SQLException, AuthorizeException {
        this.authorizeService.authorizeAction(context, bitstream, 2);
        if (!bitstream.isDeleted()) {
            throw new IllegalStateException("Bitstream " + bitstream.getID().toString() + " must be deleted before it can be removed from the database.");
        }
        this.bitstreamDAO.delete(context, bitstream);
    }

    @Override
    public List<Bitstream> findDuplicateInternalIdentifier(Context context, Bitstream bitstream) throws SQLException {
        return this.bitstreamDAO.findDuplicateInternalIdentifier(context, bitstream);
    }

    @Override
    public Iterator<Bitstream> getItemBitstreams(Context context, Item item) throws SQLException {
        return this.bitstreamDAO.findByItem(context, item);
    }

    @Override
    public Iterator<Bitstream> getCollectionBitstreams(Context context, Collection collection) throws SQLException {
        return this.bitstreamDAO.findByCollection(context, collection);
    }

    @Override
    public Iterator<Bitstream> getCommunityBitstreams(Context context, Community community) throws SQLException {
        return this.bitstreamDAO.findByCommunity(context, community);
    }

    @Override
    public List<Bitstream> findBitstreamsWithNoRecentChecksum(Context context) throws SQLException {
        return this.bitstreamDAO.findBitstreamsWithNoRecentChecksum(context);
    }

    @Override
    public Bitstream getBitstreamByName(Item item, String bundleName, String bitstreamName) throws SQLException {
        List<Bundle> bundles = this.itemService.getBundles(item, bundleName);
        for (int i = 0; i < bundles.size(); ++i) {
            Bundle bundle = bundles.get(i);
            List<Bitstream> bitstreams = bundle.getBitstreams();
            for (int j = 0; j < bitstreams.size(); ++j) {
                Bitstream bitstream = bitstreams.get(j);
                if (!StringUtils.equals((CharSequence)bitstream.getName(), (CharSequence)bitstreamName)) continue;
                return bitstream;
            }
        }
        return null;
    }

    @Override
    public Bitstream getFirstBitstream(Item item, String bundleName) throws SQLException {
        List<Bitstream> bitstreams;
        List<Bundle> bundles = this.itemService.getBundles(item, bundleName);
        if (CollectionUtils.isNotEmpty(bundles) && CollectionUtils.isNotEmpty(bitstreams = bundles.get(0).getBitstreams())) {
            return bitstreams.get(0);
        }
        return null;
    }

    @Override
    public Bitstream getThumbnail(Context context, Bitstream bitstream) throws SQLException {
        Pattern pattern = this.getBitstreamNamePattern(bitstream);
        for (Bundle bundle : bitstream.getBundles()) {
            for (Item item : bundle.getItems()) {
                for (Bundle thumbnails : this.itemService.getBundles(item, "THUMBNAIL")) {
                    for (Bitstream thumbnail : thumbnails.getBitstreams()) {
                        if (!pattern.matcher(thumbnail.getName()).matches()) continue;
                        return thumbnail;
                    }
                }
            }
        }
        return null;
    }

    protected Pattern getBitstreamNamePattern(Bitstream bitstream) {
        if (bitstream.getName() != null) {
            return Pattern.compile("^" + Pattern.quote(bitstream.getName()) + ".([^.]+)$");
        }
        return Pattern.compile("^" + bitstream.getName() + ".([^.]+)$");
    }

    @Override
    public BitstreamFormat getFormat(Context context, Bitstream bitstream) throws SQLException {
        if (bitstream.getBitstreamFormat() == null) {
            return this.bitstreamFormatService.findUnknown(context);
        }
        return bitstream.getBitstreamFormat();
    }

    @Override
    public Iterator<Bitstream> findByStoreNumber(Context context, Integer storeNumber) throws SQLException {
        return this.bitstreamDAO.findByStoreNumber(context, storeNumber);
    }

    @Override
    public Long countByStoreNumber(Context context, Integer storeNumber) throws SQLException {
        return this.bitstreamDAO.countByStoreNumber(context, storeNumber);
    }

    @Override
    public int countTotal(Context context) throws SQLException {
        return this.bitstreamDAO.countRows(context);
    }

    @Override
    public Bitstream findByIdOrLegacyId(Context context, String id) throws SQLException {
        try {
            if (StringUtils.isNumeric((CharSequence)id)) {
                return this.findByLegacyId(context, Integer.parseInt(id));
            }
            return this.find(context, UUID.fromString(id));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public Bitstream findByLegacyId(Context context, int id) throws SQLException {
        return this.bitstreamDAO.findByLegacyId(context, id, Bitstream.class);
    }

    @Override
    public int countDeletedBitstreams(Context context) throws SQLException {
        return this.bitstreamDAO.countDeleted(context);
    }

    @Override
    public int countBitstreamsWithoutPolicy(Context context) throws SQLException {
        return this.bitstreamDAO.countWithNoPolicy(context);
    }

    @Override
    public List<Bitstream> getNotReferencedBitstreams(Context context) throws SQLException {
        return this.bitstreamDAO.getNotReferencedBitstreams(context);
    }

    @Override
    @Nullable
    public Long getLastModified(Bitstream bitstream) throws IOException {
        return this.bitstreamStorageService.getLastModified(bitstream);
    }
}

