/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import org.dspace.checker.ChecksumResult;
import org.dspace.content.Bitstream;
import org.dspace.core.ReloadableEntity;

@Entity
@Table(name="checksum_history")
public class ChecksumHistory
implements ReloadableEntity<Long> {
    @Id
    @Column(name="check_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="checksum_history_check_id_seq")
    @SequenceGenerator(name="checksum_history_check_id_seq", sequenceName="checksum_history_check_id_seq", allocationSize=1)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="bitstream_id")
    private Bitstream bitstream;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="process_start_date", nullable=false)
    private Date processStartDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="process_end_date", nullable=false)
    private Date processEndDate;
    @Column(name="checksum_expected", nullable=false)
    private String checksumExpected;
    @Column(name="checksum_calculated", nullable=false)
    private String checksumCalculated;
    @ManyToOne
    @JoinColumn(name="result", referencedColumnName="result_code")
    private ChecksumResult checksumResult;

    protected ChecksumHistory() {
    }

    @Override
    public Long getID() {
        return this.id;
    }

    public Bitstream getBitstream() {
        return this.bitstream;
    }

    public void setBitstream(Bitstream bitstream) {
        this.bitstream = bitstream;
    }

    public String getChecksumCalculated() {
        return this.checksumCalculated;
    }

    public void setChecksumCalculated(String checksumCalculated) {
        this.checksumCalculated = checksumCalculated;
    }

    public String getChecksumExpected() {
        return this.checksumExpected;
    }

    public void setChecksumExpected(String checksumExpected) {
        this.checksumExpected = checksumExpected;
    }

    public Date getProcessEndDate() {
        return this.processEndDate == null ? null : new Date(this.processEndDate.getTime());
    }

    public void setProcessEndDate(Date processEndDate) {
        this.processEndDate = processEndDate == null ? null : new Date(processEndDate.getTime());
    }

    public Date getProcessStartDate() {
        return this.processStartDate == null ? null : new Date(this.processStartDate.getTime());
    }

    public void setProcessStartDate(Date processStartDate) {
        this.processStartDate = processStartDate == null ? null : new Date(processStartDate.getTime());
    }

    public ChecksumResult getResult() {
        return this.checksumResult;
    }

    public void setResult(ChecksumResult result) {
        this.checksumResult = result;
    }
}

