/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.suggestion.openaire;

import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.dspace.app.suggestion.SuggestionEvidence;
import org.dspace.app.suggestion.SuggestionUtils;
import org.dspace.app.suggestion.openaire.EvidenceScorer;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.ItemService;
import org.dspace.external.model.ExternalDataObject;
import org.dspace.util.MultiFormatDateParser;
import org.springframework.beans.factory.annotation.Autowired;

public class DateScorer
implements EvidenceScorer {
    private String birthDateMetadata;
    private String educationDateMetadata;
    private int birthDateDelta = 20;
    private int birthDateRange = 50;
    private int educationDateDelta = -3;
    private int educationDateRange = 50;
    @Autowired
    private ItemService itemService;
    private String publicationDateMetadata;

    public void setItemService(ItemService itemService) {
        this.itemService = itemService;
    }

    public void setBirthDateMetadata(String birthDate) {
        this.birthDateMetadata = birthDate;
    }

    public String getBirthDateMetadata() {
        return this.birthDateMetadata;
    }

    public void setEducationDateMetadata(String educationDate) {
        this.educationDateMetadata = educationDate;
    }

    public String getEducationDateMetadata() {
        return this.educationDateMetadata;
    }

    public void setBirthDateDelta(int birthDateDelta) {
        this.birthDateDelta = birthDateDelta;
    }

    public void setBirthDateRange(int birthDateRange) {
        this.birthDateRange = birthDateRange;
    }

    public void setEducationDateDelta(int educationDateDelta) {
        this.educationDateDelta = educationDateDelta;
    }

    public void setEducationDateRange(int educationDateRange) {
        this.educationDateRange = educationDateRange;
    }

    public void setPublicationDateMetadata(String publicationDateMetadata) {
        this.publicationDateMetadata = publicationDateMetadata;
    }

    @Override
    public SuggestionEvidence computeEvidence(Item researcher, ExternalDataObject importRecord) {
        Integer[] range = this.calculateRange(researcher);
        if (range == null) {
            return new SuggestionEvidence(this.getClass().getSimpleName(), 0.0, "No assumption was possible about the publication year range. Please consider setting your birthday in your profile.");
        }
        String optDate = SuggestionUtils.getFirstEntryByMetadatum(importRecord, this.publicationDateMetadata);
        int year = this.getYear(optDate);
        if (year > 0) {
            if (!(range[0] != null && year < range[0] || range[1] != null && year > range[1])) {
                return new SuggestionEvidence(this.getClass().getSimpleName(), 10.0, "The publication date is within the expected range [" + range[0] + ", " + range[1] + "]");
            }
            return null;
        }
        return new SuggestionEvidence(this.getClass().getSimpleName(), 0.0, "No assumption was possible as the publication date is " + (String)(optDate != null ? "unprocessable [" + optDate + "]" : "unknown"));
    }

    private Integer[] calculateRange(Item researcher) {
        String birthDateStr = this.getSingleValue(researcher, this.birthDateMetadata);
        int birthDateYear = this.getYear(birthDateStr);
        int educationDateYear = this.getListMetadataValues(researcher, this.educationDateMetadata).stream().mapToInt(x -> this.getYear(x.getValue())).filter(d -> d > 0).min().orElse(-1);
        if (educationDateYear > 0) {
            return new Integer[]{educationDateYear + this.educationDateDelta, educationDateYear + this.educationDateDelta + this.educationDateRange};
        }
        if (birthDateYear > 0) {
            return new Integer[]{birthDateYear + this.birthDateDelta, birthDateYear + this.birthDateDelta + this.birthDateRange};
        }
        return null;
    }

    private List<MetadataValue> getListMetadataValues(Item researcher, String metadataKey) {
        if (metadataKey != null) {
            return this.itemService.getMetadataByMetadataString(researcher, metadataKey);
        }
        return Collections.EMPTY_LIST;
    }

    private String getSingleValue(Item researcher, String metadataKey) {
        if (metadataKey != null) {
            return this.itemService.getMetadata(researcher, metadataKey);
        }
        return null;
    }

    private int getYear(String birthDateStr) {
        Date birthDate;
        int birthDateYear = -1;
        if (birthDateStr != null && (birthDate = MultiFormatDateParser.parse(birthDateStr)) != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(birthDate);
            birthDateYear = calendar.get(1);
        }
        return birthDateYear;
    }
}

