/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.ldn.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonSyntaxException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.ldn.LDNMessageEntity;
import org.dspace.app.ldn.LDNRouter;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.ldn.dao.LDNMessageDao;
import org.dspace.app.ldn.dao.NotifyServiceDao;
import org.dspace.app.ldn.model.Notification;
import org.dspace.app.ldn.model.NotifyRequestStatus;
import org.dspace.app.ldn.model.NotifyRequestStatusEnum;
import org.dspace.app.ldn.model.RequestStatus;
import org.dspace.app.ldn.model.Service;
import org.dspace.app.ldn.processor.LDNProcessor;
import org.dspace.app.ldn.service.LDNMessageService;
import org.dspace.app.ldn.utility.LDNUtils;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.discovery.indexobject.IndexableLDNNotification;
import org.dspace.event.Event;
import org.dspace.handle.service.HandleService;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class LDNMessageServiceImpl
implements LDNMessageService {
    @Autowired(required=true)
    private LDNMessageDao ldnMessageDao;
    @Autowired(required=true)
    private NotifyServiceDao notifyServiceDao;
    @Autowired(required=true)
    private ConfigurationService configurationService;
    @Autowired(required=true)
    private HandleService handleService;
    @Autowired(required=true)
    private ItemService itemService;
    @Autowired(required=true)
    private LDNRouter ldnRouter;
    private static final Logger log = LogManager.getLogger(LDNMessageServiceImpl.class);
    private static final String LDN_ID_PREFIX = "urn:uuid:";

    protected LDNMessageServiceImpl() {
    }

    @Override
    public LDNMessageEntity find(Context context, String id) throws SQLException {
        if (id == null) {
            return null;
        }
        id = ((String)id).startsWith(LDN_ID_PREFIX) ? id : LDN_ID_PREFIX + (String)id;
        return (LDNMessageEntity)this.ldnMessageDao.findByID(context, LDNMessageEntity.class, (String)id);
    }

    @Override
    public List<LDNMessageEntity> findAll(Context context) throws SQLException {
        return this.ldnMessageDao.findAll(context, LDNMessageEntity.class);
    }

    @Override
    public LDNMessageEntity create(Context context, String id) throws SQLException {
        LDNMessageEntity result = (LDNMessageEntity)this.ldnMessageDao.findByID(context, LDNMessageEntity.class, id);
        if (result != null) {
            throw new SQLException("Duplicate LDN Message ID [" + id + "] detected. This message is rejected.");
        }
        return this.ldnMessageDao.create(context, new LDNMessageEntity(id));
    }

    @Override
    public LDNMessageEntity create(Context context, Notification notification, String sourceIp) throws SQLException {
        LDNMessageEntity ldnMessage = this.create(context, notification.getId());
        DSpaceObject obj = this.findDspaceObjectByUrl(context, notification.getObject().getId());
        if (obj == null) {
            obj = this.isTargetCurrent(notification) ? this.findDspaceObjectByUrl(context, notification.getObject().getAsObject()) : this.findDspaceObjectByUrl(context, notification.getObject().getAsSubject());
        }
        ldnMessage.setObject(obj);
        if (null != notification.getContext()) {
            ldnMessage.setContext(this.findDspaceObjectByUrl(context, notification.getContext().getId()));
        }
        ldnMessage.setOrigin(this.findNotifyService(context, notification.getOrigin()));
        ldnMessage.setInReplyTo(this.find(context, notification.getInReplyTo()));
        ObjectMapper mapper = new ObjectMapper();
        String message = null;
        try {
            message = mapper.writeValueAsString((Object)notification);
            ldnMessage.setMessage(message);
        }
        catch (JsonProcessingException e) {
            log.error("Notification json can't be correctly processed and stored inside the LDN Message Entity" + ldnMessage);
            log.error((Object)e);
        }
        ldnMessage.setType(StringUtils.joinWith((String)",", (Object[])new Object[]{notification.getType()}));
        Set<String> notificationType = notification.getType();
        if (notificationType == null) {
            log.error("Notification has no notificationType attribute! " + notification);
            return null;
        }
        ArrayList<String> notificationTypeArrayList = new ArrayList<String>(notificationType);
        Collections.sort(notificationTypeArrayList);
        ldnMessage.setActivityStreamType(notificationTypeArrayList.get(0));
        if (notificationTypeArrayList.size() > 1) {
            ldnMessage.setCoarNotifyType(notificationTypeArrayList.get(1));
        } else if (ldnMessage.getInReplyTo() != null) {
            ldnMessage.setCoarNotifyType(ldnMessage.getInReplyTo().getCoarNotifyType());
        }
        ldnMessage.setQueueStatus(LDNMessageEntity.QUEUE_STATUS_QUEUED);
        ldnMessage.setSourceIp(sourceIp);
        if (ldnMessage.getOrigin() == null && !"Offer".equalsIgnoreCase(ldnMessage.getActivityStreamType())) {
            ldnMessage.setQueueStatus(LDNMessageEntity.QUEUE_STATUS_UNTRUSTED);
        } else {
            boolean ipCheckRangeEnabled = this.configurationService.getBooleanProperty("ldn.ip-range.enabled", true);
            if (ipCheckRangeEnabled && !this.isValidIp(ldnMessage.getOrigin(), sourceIp)) {
                ldnMessage.setQueueStatus(LDNMessageEntity.QUEUE_STATUS_UNTRUSTED_IP);
            }
        }
        ldnMessage.setQueueTimeout(new Date());
        this.update(context, ldnMessage);
        return ldnMessage;
    }

    @Override
    public boolean isValidIp(NotifyServiceEntity origin, String sourceIp) {
        String lowerIp = origin.getLowerIp();
        String upperIp = origin.getUpperIp();
        try {
            InetAddress ip = InetAddress.getByName(sourceIp);
            InetAddress lowerBoundAddress = InetAddress.getByName(lowerIp);
            InetAddress upperBoundAddress = InetAddress.getByName(upperIp);
            long ipLong = this.ipToLong(ip);
            long lowerBoundLong = this.ipToLong(lowerBoundAddress);
            long upperBoundLong = this.ipToLong(upperBoundAddress);
            return ipLong >= lowerBoundLong && ipLong <= upperBoundLong;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    private long ipToLong(InetAddress ip) {
        byte[] octets = ip.getAddress();
        long result = 0L;
        for (byte octet : octets) {
            result <<= 8;
            result |= (long)(octet & 0xFF);
        }
        return result;
    }

    @Override
    public void update(Context context, LDNMessageEntity ldnMessage) throws SQLException {
        if (ldnMessage.getOrigin() != null && LDNMessageEntity.QUEUE_STATUS_UNTRUSTED.compareTo(ldnMessage.getQueueStatus()) == 0) {
            ldnMessage.setQueueStatus(LDNMessageEntity.QUEUE_STATUS_QUEUED);
        }
        this.ldnMessageDao.save(context, ldnMessage);
        UUID notificationUUID = UUID.fromString(ldnMessage.getID().replace(LDN_ID_PREFIX, ""));
        ArrayList<String> identifiersList = new ArrayList<String>();
        identifiersList.add(ldnMessage.getID());
        context.addEvent(new Event(2, 8, notificationUUID, IndexableLDNNotification.TYPE, identifiersList));
    }

    private DSpaceObject findDspaceObjectByUrl(Context context, String url) throws SQLException {
        String dspaceUrl = this.configurationService.getProperty("dspace.ui.url") + "/handle/";
        if (StringUtils.startsWith((CharSequence)url, (CharSequence)dspaceUrl)) {
            return this.handleService.resolveToObject(context, url.substring(dspaceUrl.length()));
        }
        String handleResolver = this.configurationService.getProperty("handle.canonical.prefix", "https://hdl.handle.net/");
        if (StringUtils.startsWith((CharSequence)url, (CharSequence)handleResolver)) {
            return this.handleService.resolveToObject(context, url.substring(handleResolver.length()));
        }
        dspaceUrl = this.configurationService.getProperty("dspace.ui.url") + "/items/";
        if (StringUtils.startsWith((CharSequence)url, (CharSequence)dspaceUrl)) {
            return this.itemService.find(context, UUID.fromString(url.substring(dspaceUrl.length())));
        }
        return null;
    }

    @Override
    public NotifyServiceEntity findNotifyService(Context context, Service service) throws SQLException {
        return this.notifyServiceDao.findByLdnUrl(context, service.getInbox());
    }

    @Override
    public List<LDNMessageEntity> findOldestMessagesToProcess(Context context) throws SQLException {
        List<LDNMessageEntity> result = null;
        int max_attempts = this.configurationService.getIntProperty("ldn.processor.max.attempts");
        result = this.ldnMessageDao.findOldestMessageToProcess(context, max_attempts);
        return result;
    }

    @Override
    public List<LDNMessageEntity> findMessagesToBeReprocessed(Context context) throws SQLException {
        List<LDNMessageEntity> result = null;
        result = this.ldnMessageDao.findMessagesToBeReprocessed(context);
        return result;
    }

    @Override
    public List<LDNMessageEntity> findProcessingTimedoutMessages(Context context) throws SQLException {
        List<LDNMessageEntity> result = null;
        int max_attempts = this.configurationService.getIntProperty("ldn.processor.max.attempts");
        result = this.ldnMessageDao.findProcessingTimedoutMessages(context, max_attempts);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int extractAndProcessMessageFromQueue(Context context) throws SQLException {
        int count = 0;
        int timeoutInMinutes = this.configurationService.getIntProperty("ldn.processor.queue.msg.timeout", 60);
        List<LDNMessageEntity> messages = this.findOldestMessagesToProcess(context);
        messages.addAll(this.findMessagesToBeReprocessed(context));
        Optional<LDNMessageEntity> msgOpt = this.getSingleMessageEntity(messages);
        while (msgOpt.isPresent()) {
            LDNProcessor processor = null;
            LDNMessageEntity msg = msgOpt.get();
            processor = this.ldnRouter.route(msg);
            try {
                boolean isServiceDisabled;
                boolean bl = isServiceDisabled = !this.isServiceEnabled(msg);
                if (processor == null || isServiceDisabled) {
                    log.warn("No processor found for LDN message " + msg);
                    Integer status = isServiceDisabled ? LDNMessageEntity.QUEUE_STATUS_UNTRUSTED : LDNMessageEntity.QUEUE_STATUS_UNMAPPED_ACTION;
                    msg.setQueueStatus(status);
                    msg.setQueueAttempts(msg.getQueueAttempts() + 1);
                    this.update(context, msg);
                } else {
                    msg.setQueueLastStartTime(new Date());
                    msg.setQueueStatus(LDNMessageEntity.QUEUE_STATUS_PROCESSING);
                    msg.setQueueTimeout(DateUtils.addMinutes((Date)new Date(), (int)timeoutInMinutes));
                    this.update(context, msg);
                    ObjectMapper mapper = new ObjectMapper();
                    Notification notification = (Notification)mapper.readValue(msg.getMessage(), Notification.class);
                    processor.process(context, notification);
                    msg.setQueueStatus(LDNMessageEntity.QUEUE_STATUS_PROCESSED);
                    ++count;
                }
            }
            catch (JsonSyntaxException jse) {
                log.error("Unable to read JSON notification from LdnMessage " + msg, (Throwable)jse);
                msg.setQueueStatus(LDNMessageEntity.QUEUE_STATUS_FAILED);
            }
            catch (Exception e) {
                log.error((Object)e);
                msg.setQueueStatus(LDNMessageEntity.QUEUE_STATUS_FAILED);
            }
            finally {
                msg.setQueueAttempts(msg.getQueueAttempts() + 1);
                this.update(context, msg);
            }
            messages = this.findOldestMessagesToProcess(context);
            messages.addAll(this.findMessagesToBeReprocessed(context));
            msgOpt = this.getSingleMessageEntity(messages);
        }
        return count;
    }

    private boolean isServiceEnabled(LDNMessageEntity msg) {
        String localInboxUrl = this.configurationService.getProperty("ldn.notify.inbox");
        if (msg.getTarget() == null || StringUtils.equals((CharSequence)msg.getTarget().getLdnUrl(), (CharSequence)localInboxUrl)) {
            return msg.getOrigin().isEnabled();
        }
        return msg.getTarget().isEnabled();
    }

    @Override
    public int checkQueueMessageTimeout(Context context) throws SQLException {
        int count = 0;
        int maxAttempts = this.configurationService.getIntProperty("ldn.processor.max.attempts", 5);
        Optional<LDNMessageEntity> msgOpt = this.getSingleMessageEntity(this.findProcessingTimedoutMessages(context));
        while (msgOpt.isPresent()) {
            LDNMessageEntity msg = msgOpt.get();
            try {
                if (msg.getQueueAttempts() >= maxAttempts) {
                    msg.setQueueStatus(LDNMessageEntity.QUEUE_STATUS_FAILED);
                } else {
                    msg.setQueueStatus(LDNMessageEntity.QUEUE_STATUS_QUEUED);
                }
                this.update(context, msg);
                ++count;
            }
            catch (SQLException e) {
                log.error("Can't update LDN message " + msg, (Throwable)e);
            }
            msgOpt = this.getSingleMessageEntity(this.findProcessingTimedoutMessages(context));
        }
        return count;
    }

    public Optional<LDNMessageEntity> getSingleMessageEntity(Collection<LDNMessageEntity> messages) {
        return messages.stream().findFirst();
    }

    @Override
    public NotifyRequestStatus findRequestsByItem(Context context, Item item) throws SQLException {
        NotifyRequestStatus result = new NotifyRequestStatus();
        result.setItemUuid(item.getID());
        List<LDNMessageEntity> msgs = this.ldnMessageDao.findAllMessagesByItem(context, item, "Offer");
        if (msgs != null && !msgs.isEmpty()) {
            for (LDNMessageEntity msg : msgs) {
                RequestStatus offer = new RequestStatus();
                NotifyServiceEntity nse = msg.getOrigin();
                if (nse == null) {
                    nse = msg.getTarget();
                }
                offer.setServiceName(nse == null ? "Unknown Service" : nse.getName());
                offer.setServiceUrl(nse == null ? "" : nse.getUrl());
                offer.setOfferType(LDNUtils.getNotifyType(msg.getCoarNotifyType()));
                List<LDNMessageEntity> acks = this.ldnMessageDao.findAllRelatedMessagesByItem(context, msg, item, "Accept", "Reject", "TentativeReject", "TentativeAccept", "Announce");
                if (acks == null || acks.isEmpty()) {
                    offer.setStatus(NotifyRequestStatusEnum.REQUESTED);
                } else if (acks.stream().filter(c -> c.getActivityStreamType().equalsIgnoreCase("TentativeReject")).findAny().isPresent()) {
                    offer.setStatus(NotifyRequestStatusEnum.TENTATIVE_REJECT);
                } else if (acks.stream().filter(c -> c.getActivityStreamType().equalsIgnoreCase("Reject")).findAny().isPresent()) {
                    offer.setStatus(NotifyRequestStatusEnum.REJECTED);
                } else if (acks.stream().filter(c -> c.getActivityStreamType().equalsIgnoreCase("TentativeAccept") || c.getActivityStreamType().equalsIgnoreCase("Accept")).findAny().isPresent()) {
                    offer.setStatus(NotifyRequestStatusEnum.ACCEPTED);
                }
                if (!acks.stream().filter(c -> c.getActivityStreamType().equalsIgnoreCase("Announce")).findAny().isEmpty()) continue;
                result.addRequestStatus(offer);
            }
        }
        return result;
    }

    @Override
    public String findEndorsementOrReviewResubmissionIdByItem(Context context, Item item, NotifyServiceEntity service) throws SQLException {
        List<LDNMessageEntity> msgs = this.ldnMessageDao.findAllMessagesByItem(context, item, "TentativeReject");
        if (msgs != null && !msgs.isEmpty()) {
            for (LDNMessageEntity msg : msgs) {
                if (!msg.getCoarNotifyType().contains("EndorsementAction") && !msg.getCoarNotifyType().contains("ReviewAction") || msg.getOrigin() == null || !msg.getOrigin().getID().equals(service.getID())) continue;
                return msg.getID();
            }
        }
        return null;
    }

    @Override
    public void delete(Context context, LDNMessageEntity ldnMessage) throws SQLException {
        this.ldnMessageDao.delete(context, ldnMessage);
    }

    @Override
    public boolean isTargetCurrent(Notification notification) {
        String localInboxUrl = this.configurationService.getProperty("ldn.notify.inbox");
        return StringUtils.equals((CharSequence)notification.getTarget().getInbox(), (CharSequence)localInboxUrl);
    }
}

